/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.DycGeneralVerifyFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralVerifyFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralVerifyFuncRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.common.api.DycGeneralVerifyFunction"})
public class DycGeneralVerifyFunctionImpl
implements DycGeneralVerifyFunction {
    private static final Logger log = LoggerFactory.getLogger(DycGeneralVerifyFunctionImpl.class);
    @Value(value="${qry.rule.url}")
    private String qryRuleUrl;
    @Value(value="${call.rule.url}")
    private String callRuleUrl;

    @PostMapping(value={"generalVerify"})
    public DycGeneralVerifyFuncRspBO generalVerify(@RequestBody DycGeneralVerifyFuncReqBO reqBO) {
        JSONObject qryRuleReqJsonObj = new JSONObject();
        qryRuleReqJsonObj.put("serviceCode", (Object)reqBO.getServiceCode());
        qryRuleReqJsonObj.put("dealType", (Object)"RULE_TYPE_VALIDATE");
        String qryRuleRspJsonObjStr = HttpUtil.post((String)this.qryRuleUrl, (String)qryRuleReqJsonObj.toJSONString(), (int)4000);
        JSONObject qryRuleRspJsonObj = JSON.parseObject((String)qryRuleRspJsonObjStr);
        JSONArray ruleInfos = qryRuleRspJsonObj.getJSONArray("ruleInfos");
        if (!ruleInfos.isEmpty()) {
            for (int i = 0; i < ruleInfos.size(); ++i) {
                JSONObject ruleInfo = JSON.parseObject((String)JSON.toJSONString((Object)ruleInfos.get(i)));
                Long ruleId = ruleInfo.getLong("ruleId");
                List fields = ruleInfo.getJSONArray("fields").toJavaList(String.class);
                JSONObject callRuleReqJsonObj = new JSONObject();
                callRuleReqJsonObj.put("ruleId", (Object)ruleId);
                if (!CollectionUtils.isEmpty((Collection)fields)) {
                    JSONObject callRuleReqParamsJsonObj = new JSONObject();
                    Map ruleParams = (Map)JSON.parseObject((String)reqBO.getParamJsonStr(), Map.class);
                    for (String field : fields) {
                        if (!ruleParams.containsKey(field)) continue;
                        callRuleReqParamsJsonObj.put(field, ruleParams.get(field));
                    }
                    callRuleReqJsonObj.put("params", (Object)callRuleReqParamsJsonObj.toJSONString());
                }
                log.info("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5165\u53c2\u4e3a\uff1a" + callRuleReqJsonObj.toJSONString());
                String callRuleRspJsonObjStr = HttpUtil.post((String)this.callRuleUrl, (String)callRuleReqJsonObj.toJSONString(), (int)4000);
                log.info("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u4e3a\uff1a" + callRuleRspJsonObjStr);
                JSONObject callRuleRspJsonObj = JSON.parseObject((String)callRuleRspJsonObjStr);
                JSONObject resultJson = callRuleRspJsonObj.getJSONObject("result");
                Boolean verifyResult = resultJson.getBoolean("verifyResult");
                if (verifyResult.booleanValue()) continue;
                String verifyResultDesc = resultJson.get((Object)"verifyResultDesc").toString();
                throw new ZTBusinessException(verifyResultDesc);
            }
        }
        return new DycGeneralVerifyFuncRspBO();
    }
}

