/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.atom.common.api.UmcMdmImportPerInfoFunction;
import com.tydic.dyc.atom.common.bo.UmcMdmImportPerInfoReqBO;
import com.tydic.dyc.atom.common.bo.UmcMdmImportPerInfoRspBO;
import com.tydic.dyc.atom.mdm.api.MdmPersonelAtomService;
import com.tydic.dyc.atom.mdm.bo.MdmPersonelAtomReqBo;
import com.tydic.dyc.atom.mdm.bo.MdmPersonelAtomRspBo;
import com.tydic.dyc.atom.transaction.api.UmcMdmSavePersonTmpService;
import com.tydic.dyc.atom.transaction.bo.UmcMdmPersonBO;
import com.tydic.dyc.atom.transaction.bo.UmcMdmPersonPositionsBO;
import com.tydic.dyc.atom.transaction.bo.UmcMdmSavePersonTmpReqBO;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.common.api.UmcMdmImportPerInfoFunction"})
public class UmcMdmImportPerInfoFunctionImpl
implements UmcMdmImportPerInfoFunction {
    private static final Logger log = LoggerFactory.getLogger(UmcMdmImportPerInfoFunctionImpl.class);
    @Autowired
    private MdmPersonelAtomService mdmPersonelAtomService;
    @Resource(name="mdmImportPerInfoMqServiceProvider")
    private ProxyMessageProducer mdmImportPerInfoMqServiceProvider;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcMdmSavePersonTmpService umcMdmSavePersonTmpService;
    @Value(value="${MDM_IMPORT_PER_INFO_TOPIC:MDM_IMPORT_PER_INFO_TOPIC}")
    private String MDM_IMPORT_PER_INFO_TOPIC;
    @Value(value="${MDM_IMPORT_PER_INFO_TAG:MDM_IMPORT_PER_INFO_TAG}")
    private String MDM_IMPORT_PER_INFO_TAG;
    @Resource(name="mdmImportPerInfoByOrgMqServiceProvider")
    private ProxyMessageProducer mdmImportPerInfoByOrgMqServiceProvider;
    @Value(value="${MDM_IMPORT_PER_INFO_BY_ORG_TOPIC:MDM_IMPORT_PER_INFO_BY_ORG_TOPIC}")
    private String MDM_IMPORT_PER_INFO_BY_ORG_TOPIC;
    @Value(value="${MDM_IMPORT_PER_INFO_BY_ORG_TAG:MDM_IMPORT_PER_INFO_BY_ORG_TAG}")
    private String MDM_IMPORT_PER_INFO_BY_ORG_TAG;

    @PostMapping(value={"importPerInfo"})
    public UmcMdmImportPerInfoRspBO importPerInfo(@RequestBody UmcMdmImportPerInfoReqBO reqBO) {
        if (!StringUtils.isEmpty((Object)reqBO.getBuss_sys_id())) {
            UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
            umcOrgInfoPo.setExtField3(reqBO.getBuss_sys_id());
            UmcOrgInfoPo checkOrgInfoPo = this.umcOrgInfoMapper.getModelBy(umcOrgInfoPo);
            if (null != checkOrgInfoPo) {
                UmcOrgInfoPo qryOrgInfo = new UmcOrgInfoPo();
                qryOrgInfo.setOrgTreePath(checkOrgInfoPo.getOrgTreePath());
                Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
                List umcOrgInfoPoList = this.umcOrgInfoMapper.getListByLikeOrgTreePath(qryOrgInfo, page);
                for (UmcOrgInfoPo orgInfoPo : umcOrgInfoPoList) {
                    reqBO.setOrgCode(orgInfoPo.getExtField3());
                    log.info("\u4e3b\u6570\u636e\u4eba\u5458\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
                    ProxyMessage message = new ProxyMessage(this.MDM_IMPORT_PER_INFO_BY_ORG_TOPIC, this.MDM_IMPORT_PER_INFO_BY_ORG_TAG, JSON.toJSONString((Object)reqBO));
                    try {
                        ProxySendResult proxySendResult = this.mdmImportPerInfoByOrgMqServiceProvider.send(message);
                    }
                    catch (Exception e) {
                        log.info("\u521b\u5efa\u4e3b\u6570\u636e\u4eba\u5458\u6d88\u606f\u6d88\u606f\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)reqBO));
                    }
                }
            }
        } else if (!StringUtils.isEmpty((Object)reqBO.getOrgCode())) {
            ProxyMessage message = new ProxyMessage(this.MDM_IMPORT_PER_INFO_BY_ORG_TOPIC, this.MDM_IMPORT_PER_INFO_BY_ORG_TAG, JSON.toJSONString((Object)reqBO));
            try {
                ProxySendResult checkOrgInfoPo = this.mdmImportPerInfoByOrgMqServiceProvider.send(message);
            }
            catch (Exception e) {
                log.info("\u521b\u5efa\u4e3b\u6570\u636e\u4eba\u5458\u6d88\u606f\u6d88\u606f\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
        } else {
            this.dealImportOrgPerson(reqBO, null);
        }
        UmcMdmImportPerInfoRspBO rspBO = new UmcMdmImportPerInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealImportOrgPerson(UmcMdmImportPerInfoReqBO reqBO, @Nullable String orgCode) {
        JSONObject data;
        String puuid = UUID.randomUUID().toString().replaceAll("-", "");
        MdmPersonelAtomReqBo atomReqBo = new MdmPersonelAtomReqBo();
        atomReqBo.setBusiness_phone(reqBO.getBusiness_phone());
        atomReqBo.setName(reqBO.getName());
        atomReqBo.setCountperpage(reqBO.getCountperpage());
        atomReqBo.setCurrentpage(reqBO.getCurrentpage());
        if (!StringUtils.isEmpty((Object)orgCode)) {
            JSONArray valuelist = new JSONArray();
            JSONObject value = new JSONObject();
            value.put("org_code", (Object)orgCode);
            value.put("specialitycode", (Object)"D01");
            valuelist.add((Object)value);
            JSONObject multivalue = new JSONObject();
            multivalue.put("valuelist", (Object)valuelist);
            atomReqBo.setMulticode(multivalue);
        }
        atomReqBo.setPuuid(puuid);
        MdmPersonelAtomRspBo atomRspBo = this.mdmPersonelAtomService.getMdmPersonelAtom(atomReqBo);
        if ("0000".equals(atomRspBo.getRespCode()) && null != (data = atomRspBo.getData())) {
            this.savePersonToTmp(data);
            JSONObject splitpage = data.getJSONObject("splitpage");
            Integer totalpages = splitpage.getInteger("totalpages");
            for (int pageNum = 2; pageNum <= totalpages; ++pageNum) {
                atomReqBo.setCurrentpage(pageNum);
                log.info("\u5bfc\u5165\u4e3b\u6570\u636e\u5e73\u53f0\u4eba\u5458\u6570\u636e\u6d88\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)atomReqBo));
                ProxyMessage message = new ProxyMessage(this.MDM_IMPORT_PER_INFO_TOPIC, this.MDM_IMPORT_PER_INFO_TAG, JSON.toJSONString((Object)atomReqBo));
                try {
                    ProxySendResult proxySendResult = this.mdmImportPerInfoMqServiceProvider.send(message);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u521b\u5efa\u5bfc\u5165\u4e3b\u6570\u636e\u5e73\u53f0\u4eba\u5458\u6570\u636e\u6d88\u606f\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)atomReqBo));
                }
            }
        }
    }

    private void savePersonToTmp(JSONObject data) {
        JSONArray dataInfoArray = data.getJSONObject("datainfos").getJSONArray("datainfo");
        if (!CollectionUtils.isEmpty((Collection)dataInfoArray)) {
            ArrayList<UmcMdmPersonBO> mdmPersonList = new ArrayList<UmcMdmPersonBO>();
            for (Object object : dataInfoArray) {
                JSONObject personJson = (JSONObject)object;
                UmcMdmPersonBO mdmPersonBO = this.buildPersonJson(personJson);
                mdmPersonList.add(mdmPersonBO);
            }
            if (!CollectionUtils.isEmpty(mdmPersonList)) {
                UmcMdmSavePersonTmpReqBO mdmPersonTmpReqBO = new UmcMdmSavePersonTmpReqBO();
                mdmPersonTmpReqBO.setMdmPersonList(mdmPersonList);
                this.umcMdmSavePersonTmpService.savePersonTmp(mdmPersonTmpReqBO);
            }
        }
    }

    private UmcMdmPersonBO buildPersonJson(JSONObject personJson) {
        JSONArray list;
        UmcMdmPersonBO umcMdmPersonBO = new UmcMdmPersonBO();
        umcMdmPersonBO.setPersonCode(personJson.getString("person_code"));
        umcMdmPersonBO.setPersonType(personJson.getString("person_type"));
        umcMdmPersonBO.setName(personJson.getString("name"));
        umcMdmPersonBO.setEnName(personJson.getString("en_name"));
        umcMdmPersonBO.setChinesePhoneticAlphabetOfName(personJson.getString("chinese_phonetic_alphabet_of_name"));
        umcMdmPersonBO.setEMail(personJson.getString("e_mail"));
        umcMdmPersonBO.setBusinessPhone(personJson.getString("business_phone"));
        umcMdmPersonBO.setTel1(personJson.getString("tel1"));
        umcMdmPersonBO.setTel2(personJson.getString("tel2"));
        umcMdmPersonBO.setOthPhone(personJson.getString("oth_phone"));
        umcMdmPersonBO.setDataStatus(personJson.getString("data_status"));
        umcMdmPersonBO.setSourceSys(personJson.getString("source_sys"));
        umcMdmPersonBO.setCertNation(personJson.getString("cert_nation"));
        umcMdmPersonBO.setMainCertType(personJson.getString("main_cert_type"));
        umcMdmPersonBO.setMainCertNum(personJson.getString("main_cert_num"));
        umcMdmPersonBO.setGender(personJson.getString("gender"));
        umcMdmPersonBO.setNationality(personJson.getString("nationality"));
        umcMdmPersonBO.setNationPlace(personJson.getString("nation_place"));
        umcMdmPersonBO.setNation(personJson.getString("nation"));
        umcMdmPersonBO.setPolStatus(personJson.getString("pol_status"));
        umcMdmPersonBO.setMariStatus(personJson.getString("mari_status"));
        umcMdmPersonBO.setExpirationDate(personJson.getString("expiration_date"));
        umcMdmPersonBO.setIfSeniorManager(personJson.getString("if_senior_manager"));
        umcMdmPersonBO.setIdentityOfSeniorManager(personJson.getString("identity_of_senior_manager"));
        umcMdmPersonBO.setStartDate(personJson.getString("start_date"));
        umcMdmPersonBO.setJoinDate(personJson.getString("join_date"));
        umcMdmPersonBO.setJoinSecGrpDate(personJson.getString("join_sec_grp_date"));
        umcMdmPersonBO.setJoinCmpDate(personJson.getString("join_cmp_date"));
        umcMdmPersonBO.setTrialEndDate(personJson.getString("trial_end_date"));
        umcMdmPersonBO.setLineMgr(personJson.getString("line_mgr"));
        umcMdmPersonBO.setHighestEducation(personJson.getString("highest_education"));
        umcMdmPersonBO.setIfOpenMail(personJson.getString("if_open_mail"));
        ArrayList<UmcMdmPersonPositionsBO> mdmPersonPositionsBOList = new ArrayList<UmcMdmPersonPositionsBO>();
        umcMdmPersonBO.setMdmPersonPositionsBOList(mdmPersonPositionsBOList);
        JSONObject positions = personJson.getJSONObject("positions");
        if (positions != null && !CollectionUtils.isEmpty((Collection)(list = positions.getJSONArray("list")))) {
            for (Object position : list) {
                JSONObject positionJson = (JSONObject)position;
                UmcMdmPersonPositionsBO positionsBO = this.buildPersonPositionJson(umcMdmPersonBO.getPersonCode(), positionJson);
                mdmPersonPositionsBOList.add(positionsBO);
            }
        }
        return umcMdmPersonBO;
    }

    private UmcMdmPersonPositionsBO buildPersonPositionJson(String personCode, JSONObject positionJson) {
        UmcMdmPersonPositionsBO positionsBO = new UmcMdmPersonPositionsBO();
        positionsBO.setPersonCode(personCode);
        positionsBO.setOrganizationCode(positionJson.getString("organization_code"));
        positionsBO.setSourceSystemPersonnelStatus(positionJson.getString("source_system_personnel_status"));
        positionsBO.setEffectiveDate(positionJson.getString("effective_date"));
        positionsBO.setPersonClassify(positionJson.getString("person_classify"));
        positionsBO.setOrganizationView(positionJson.getString("organization_view"));
        positionsBO.setIfMainPost(positionJson.getString("if_main_post"));
        positionsBO.setPostSeq(positionJson.getString("post_seq"));
        positionsBO.setPositionId(positionJson.getString("position_id"));
        positionsBO.setPostId(positionJson.getString("post_id"));
        positionsBO.setSortingNumberWithinDepartments(positionJson.getString("sorting_number_within_departments"));
        positionsBO.setAccountCode(positionJson.getString("account_code"));
        positionsBO.setPositionName(positionJson.getString("position_name"));
        positionsBO.setPostName(positionJson.getString("post_name"));
        positionsBO.setOrgIdPath(positionJson.getString("org_id_path"));
        positionsBO.setPositionInTheCompany(positionJson.getString("position_in_the_company"));
        positionsBO.setPositionInTheCompanyName(positionJson.getString("position_in_the_company_name"));
        positionsBO.setClsInGroupId(positionJson.getString("cls_in_group_id"));
        positionsBO.setClsInGroupName(positionJson.getString("cls_in_group_name"));
        positionsBO.setPayEasId(positionJson.getString("pay_eas_id"));
        positionsBO.setPayEasDescr(positionJson.getString("pay_eas_descr"));
        positionsBO.setStandardPositionName(positionJson.getString("standard_position_name"));
        positionsBO.setStandardPositionId(positionJson.getString("standard_position_id"));
        positionsBO.setStandardPositionDesc(positionJson.getString("standard_position_desc"));
        positionsBO.setSuppleDuty1Desc(positionJson.getString("supple_duty1_desc"));
        positionsBO.setSuppleDuty2Desc(positionJson.getString("supple_duty2_desc"));
        positionsBO.setSuppleDuty2Id(positionJson.getString("supple_duty2_id"));
        positionsBO.setSeq1Desc(positionJson.getString("seq1_desc"));
        positionsBO.setSeq1Id(positionJson.getString("seq1_id"));
        positionsBO.setSeq2Desc(positionJson.getString("seq2_desc"));
        positionsBO.setSeq2Id(positionJson.getString("seq2_id"));
        positionsBO.setSeq3Desc(positionJson.getString("seq3_desc"));
        positionsBO.setSeq3Id(positionJson.getString("seq3_id"));
        positionsBO.setOnGuardStatus(positionJson.getString("on_guard_status"));
        positionsBO.setOnRegisterStatus(positionJson.getString("on_register_status"));
        positionsBO.setFeesBearOrgId(positionJson.getString("fees_bear_org_id"));
        positionsBO.setFeesBearOrgName(positionJson.getString("fees_bear_org_name"));
        positionsBO.setFeesBearDepId(positionJson.getString("fees_bear_dep_id"));
        positionsBO.setFeesBearDepName(positionJson.getString("fees_bear_dep_name"));
        return positionsBO;
    }
}

