/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.atom.transaction.api.DycAutoCreateRatingOrderTaskFunction;
import com.tydic.dyc.atom.transaction.bo.DycAutoCreateRatingOrderTaskFunctionReqBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoCreateRatingOrderConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(AutoCreateRatingOrderConsumer.class);
    @Resource
    private DycAutoCreateRatingOrderTaskFunction dycAutoCreateRatingOrderTaskFunction;
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("\u81ea\u52a8\u521b\u5efa\u8bc4\u5206\u8868\u6d88\u8d39\u8005\u5f00\u59cb------------------\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)message));
        Long count = this.cacheClient.setnx(message.getMessageId(), (Object)message.getMessageId());
        if (count != 1L) {
            log.info("\u81ea\u52a8\u521b\u5efa\u8bc4\u5206\u8868\u8be5\u6d88\u606f\u6b63\u5728\u5904\u7406\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77:{}", (Object)JSON.toJSONString((Object)message));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        try {
            this.cacheClient.expire(message.getMessageId(), 120);
            DycAutoCreateRatingOrderTaskFunctionReqBO reqBO = (DycAutoCreateRatingOrderTaskFunctionReqBO)JSON.parseObject((String)message.getContent(), DycAutoCreateRatingOrderTaskFunctionReqBO.class);
            log.info("\u81ea\u52a8\u521b\u5efa\u8bc4\u5206\u8868\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            this.dycAutoCreateRatingOrderTaskFunction.autoCreateRatingOrderTask(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            ProxyConsumerStatus proxyConsumerStatus = ProxyConsumerStatus.RECONSUME_LATER;
            return proxyConsumerStatus;
        }
        finally {
            this.cacheClient.delete(message.getMessageId());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

