/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.atom.transaction.api.DycCalculateRatingResultsFunction;
import com.tydic.dyc.atom.transaction.bo.DycCalculateRatingResultsFunctionReqBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CalculateRatingResultsConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(CalculateRatingResultsConsumer.class);
    @Resource
    private DycCalculateRatingResultsFunction dycCalculateRatingResultsFunction;
    @Autowired
    private CacheClient cacheClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("\u8ba1\u7b97\u8bc4\u5206\u7ed3\u679c\u6d88\u8d39\u8005\u5f00\u59cb------------------\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)message));
        log.info("messageId========{}", (Object)message.getMessageId());
        Long count = this.cacheClient.setnx(message.getMessageId(), (Object)message.getMessageId());
        if (count != 1L) {
            log.info("\u8ba1\u7b97\u8bc4\u5206\u7ed3\u679c\u8be5\u6d88\u606f\u6b63\u5728\u5904\u7406\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77:{}", (Object)JSON.toJSONString((Object)message));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        try {
            this.cacheClient.expire(message.getMessageId(), 120);
            Thread.sleep(5000L);
            DycCalculateRatingResultsFunctionReqBO reqBO = (DycCalculateRatingResultsFunctionReqBO)JSON.parseObject((String)message.getContent(), DycCalculateRatingResultsFunctionReqBO.class);
            log.info("\u8ba1\u7b97\u8bc4\u5206\u7ed3\u679c\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            this.dycCalculateRatingResultsFunction.calculateRatingResults(reqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            ProxyConsumerStatus proxyConsumerStatus = ProxyConsumerStatus.RECONSUME_LATER;
            return proxyConsumerStatus;
        }
        finally {
            this.cacheClient.delete(message.getMessageId());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

