/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.atom.transaction.api.UmcMdmSaveOrgInfoFailFunction;
import com.tydic.dyc.atom.transaction.api.UmcPersonelSaveListService;
import com.tydic.dyc.atom.transaction.bo.UmcMdmSaveOrgInfoFailFuncReqBO;
import com.tydic.dyc.atom.transaction.bo.UmcPersonelQryListReqBo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MdmImportPerInfoConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MdmImportPerInfoConsumer.class);
    @Autowired
    private CacheClient cacheClient;
    @Resource
    private UmcPersonelSaveListService umcPersonelSaveListService;
    @Autowired
    private UmcMdmSaveOrgInfoFailFunction umcMdmSaveOrgInfoFunction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("\u5bfc\u5165\u4e3b\u6570\u636e\u5e73\u53f0\u4eba\u5458\u6570\u636e\u6d88\u8d39\u8005\u5f00\u59cb------------------\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)message));
        Long count = this.cacheClient.setnx(message.getMessageId(), (Object)message.getMessageId());
        if (count != 1L) {
            log.info("\u5bfc\u5165\u4e3b\u6570\u636e\u5e73\u53f0\u4eba\u5458\u6570\u636e\u6d88\u8d39\u6b63\u5728\u5904\u7406\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77:{}", (Object)JSON.toJSONString((Object)message));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        try {
            this.cacheClient.expire(message.getMessageId(), 120);
            UmcPersonelQryListReqBo reqBO = (UmcPersonelQryListReqBo)JSON.parseObject((String)message.getContent(), UmcPersonelQryListReqBo.class);
            log.info("\u5bfc\u5165\u4e3b\u6570\u636e\u5e73\u53f0\u4eba\u5458\u6570\u636e\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            this.umcPersonelSaveListService.savePerQryList(reqBO);
        }
        catch (Exception e) {
            UmcMdmSaveOrgInfoFailFuncReqBO funcReq = new UmcMdmSaveOrgInfoFailFuncReqBO();
            funcReq.setContent(message.getContent());
            funcReq.setMessageId(message.getMessageId());
            funcReq.setFailReson(e.getMessage());
            funcReq.setImportType(Integer.valueOf(2));
            this.umcMdmSaveOrgInfoFunction.saveMdmOrgInfoFail(funcReq);
            e.printStackTrace();
            ProxyConsumerStatus proxyConsumerStatus = ProxyConsumerStatus.RECONSUME_LATER;
            return proxyConsumerStatus;
        }
        finally {
            this.cacheClient.delete(message.getMessageId());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

