/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.mdm.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.mdm.api.MdmPersonelAtomService;
import com.tydic.dyc.atom.mdm.bo.MdmPersonelAtomReqBo;
import com.tydic.dyc.atom.mdm.bo.MdmPersonelAtomRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MdmPersonelAtomServiceImpl
implements MdmPersonelAtomService {
    private static final Logger log = LoggerFactory.getLogger(MdmPersonelAtomServiceImpl.class);
    @Value(value="${mdm.mdmOrganizationUrl:http://dyc-ability-web:8080/OSN/api/person/account/hr/new/v1}")
    private String mdmPersonelUrl;

    @Override
    public MdmPersonelAtomRspBo getMdmPersonelAtom(MdmPersonelAtomReqBo reqBO) {
        MdmPersonelAtomRspBo rspBo = new MdmPersonelAtomRspBo();
        JSONObject jsonObject = MdmPersonelAtomServiceImpl.buildRequestBody(reqBO);
        log.info("\u67e5\u8be2\u4eba\u4e8b\u4eba\u5458\u5168\u91cf\u6570\u636e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)jsonObject);
        String response = HttpUtil.post((String)this.mdmPersonelUrl, (String)jsonObject.toString());
        if (StringUtils.isEmpty((Object)response)) {
            throw new ZTBusinessException("\u67e5\u8be2\u4eba\u4e8b\u4eba\u5458\u5168\u91cf\u6570\u636e\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        log.info("\u67e5\u8be2\u4eba\u4e8b\u4eba\u5458\u5168\u91cf\u6570\u636e\u63a5\u53e3\u51fa\u53c2:{}", (Object)response);
        JSONObject object = JSONObject.parseObject((String)response);
        JSONObject esb = (JSONObject)object.get((Object)"esb");
        if (!ObjectUtils.isEmpty((Object)esb)) {
            JSONObject data = (JSONObject)esb.get((Object)"data");
            String desc = esb.getString("desc");
            String result = esb.getString("result");
            if (!"S".equals(result)) {
                throw new ZTBusinessException(desc);
            }
            if (!ObjectUtils.isEmpty((Object)data)) {
                rspBo.setData(data);
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @NotNull
    private static JSONObject buildRequestBody(MdmPersonelAtomReqBo reqBO) {
        JSONObject jsonObject = new JSONObject();
        JSONObject jsonObject1 = new JSONObject();
        JSONObject jsonObject2 = new JSONObject();
        JSONObject jsonObject3 = new JSONObject();
        JSONObject jsonObject4 = new JSONObject();
        JSONObject jsonObject5 = new JSONObject();
        jsonObject.put("esb", (Object)jsonObject1);
        jsonObject1.put("data", (Object)jsonObject2);
        jsonObject2.put("datainfos", (Object)jsonObject3);
        JSONArray jsonArray = new JSONArray();
        if (!StringUtils.isEmpty((Object)reqBO.getBusiness_phone())) {
            jsonObject4.put("business_phone", (Object)reqBO.getBusiness_phone());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getName())) {
            jsonObject4.put("name", (Object)reqBO.getName());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getLastmodifyrecordtime())) {
            jsonObject4.put("lastmodifyrecordtime", (Object)reqBO.getLastmodifyrecordtime());
        }
        if (!ObjectUtils.isEmpty((Object)reqBO.getMulticode())) {
            jsonObject4.put("multicode", (Object)reqBO.getMulticode());
        }
        jsonArray.add((Object)jsonObject4);
        jsonObject3.put("datainfo", (Object)jsonArray);
        if (!StringUtils.isEmpty((Object)reqBO.getPuuid())) {
            jsonObject3.put("puuid", (Object)reqBO.getPuuid());
        } else {
            jsonObject3.put("puuid", (Object)UUID.randomUUID().toString().replaceAll("-", ""));
        }
        jsonObject2.put("splitpage", (Object)jsonObject5);
        jsonObject5.put("countperpage", (Object)reqBO.getCountperpage());
        jsonObject5.put("currentpage", (Object)reqBO.getCurrentpage());
        jsonObject.put("randomId", (Object)IdUtil.nextId());
        return jsonObject;
    }
}

