/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.transaction.api.DycAutoCreateRatingOrderTaskFunction;
import com.tydic.dyc.atom.transaction.api.DycUmcAddSupRatingFunction;
import com.tydic.dyc.atom.transaction.bo.DycAutoCreateRatingOrderTaskFunctionReqBO;
import com.tydic.dyc.atom.transaction.bo.DycAutoCreateRatingOrderTaskFunctionRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.SupCommConstants;
import com.tydic.dyc.umc.repository.dao.SupIndicatorsStatisticsMonthMapper;
import com.tydic.dyc.umc.repository.dao.SupIndicatorsStatisticsQuarterMapper;
import com.tydic.dyc.umc.repository.dao.SupIndicatorsStatisticsRelationMapper;
import com.tydic.dyc.umc.repository.dao.SupIndicatorsStatisticsYearMapper;
import com.tydic.dyc.umc.repository.dao.SupInspectionMapper;
import com.tydic.dyc.umc.repository.dao.SupplierAssessmentRatingRulesMapper;
import com.tydic.dyc.umc.repository.po.SupIndicatorsStatisticsMonthPO;
import com.tydic.dyc.umc.repository.po.SupIndicatorsStatisticsQuarterPO;
import com.tydic.dyc.umc.repository.po.SupIndicatorsStatisticsRelationPO;
import com.tydic.dyc.umc.repository.po.SupIndicatorsStatisticsYearPO;
import com.tydic.dyc.umc.repository.po.SupInspectionPO;
import com.tydic.dyc.umc.service.inspectionweight.bo.DycSupInspectionWeightBO;
import com.tydic.dyc.umc.service.rating.bo.DycUmcAddSupRatingAbilityReqBO;
import com.tydic.dyc.umc.service.rules.bo.AssessmentRatingListBO;
import com.tydic.dyc.umc.service.rules.bo.DycSupplierEvaluateRuleQryDetailReqBO;
import com.tydic.dyc.umc.service.rules.bo.DycSupplierEvaluateRuleQryDetailRspBO;
import com.tydic.dyc.umc.service.rules.service.DycSupplierEvaluateRuleQryDetailService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.DycAutoCreateRatingOrderTaskFunction"})
public class DycAutoCreateRatingOrderTaskFunctionImpl
implements DycAutoCreateRatingOrderTaskFunction {
    private static final Logger log = LoggerFactory.getLogger(DycAutoCreateRatingOrderTaskFunctionImpl.class);
    @Autowired
    private DycUmcAddSupRatingFunction dycUmcAddSupRatingFunction;
    @Autowired
    private SupplierAssessmentRatingRulesMapper supplierAssessmentRatingRulesMapper;
    @Autowired
    private SupIndicatorsStatisticsMonthMapper supIndicatorsStatisticsMonthMapper;
    @Autowired
    private SupIndicatorsStatisticsQuarterMapper supIndicatorsStatisticsQuarterMapper;
    @Autowired
    private SupIndicatorsStatisticsYearMapper supIndicatorsStatisticsYearMapper;
    @Autowired
    private SupIndicatorsStatisticsRelationMapper supIndicatorsStatisticsRelationMapper;
    @Autowired
    private SupInspectionMapper supInspectionMapper;
    @Autowired
    private DycSupplierEvaluateRuleQryDetailService dycSupplierEvaluateRuleQryDetailService;

    @PostMapping(value={"autoCreateRatingOrderTask"})
    public DycAutoCreateRatingOrderTaskFunctionRspBO autoCreateRatingOrderTask(@RequestBody DycAutoCreateRatingOrderTaskFunctionReqBO reqBO) {
        DycAutoCreateRatingOrderTaskFunctionRspBO rspBO = new DycAutoCreateRatingOrderTaskFunctionRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Date nowDate = new Date();
        Map<String, String> valMap = this.valCreateDate(nowDate, reqBO);
        if ("false".equals(valMap.get("mark"))) {
            return new DycAutoCreateRatingOrderTaskFunctionRspBO();
        }
        DycUmcAddSupRatingAbilityReqBO addSupRatingAbilityReqBO = new DycUmcAddSupRatingAbilityReqBO();
        addSupRatingAbilityReqBO.setSupplierId(reqBO.getSupplierId());
        addSupRatingAbilityReqBO.setSupplierName(reqBO.getSupplierName());
        addSupRatingAbilityReqBO.setInspectionRuleId(reqBO.getRatingRulesId());
        addSupRatingAbilityReqBO.setInspectionRuleName(reqBO.getRatingRulesName());
        addSupRatingAbilityReqBO.setInspectionCycleType(Integer.valueOf(Integer.parseInt(reqBO.getRatingRulesCycle())));
        String ratingTime = valMap.get("ratingTime");
        String[] ratingTimeList = ratingTime.split("-");
        addSupRatingAbilityReqBO.setInspectionYear(Integer.valueOf(Integer.parseInt(ratingTimeList[0])));
        if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.MONTH))) {
            addSupRatingAbilityReqBO.setInspectionMonth(Integer.valueOf(Integer.parseInt(ratingTimeList[1])));
        } else if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.QUARTER))) {
            addSupRatingAbilityReqBO.setInspectionQuarter(Integer.valueOf(Integer.parseInt(ratingTimeList[1])));
        }
        addSupRatingAbilityReqBO.setRatingType(reqBO.getScoreMethod());
        addSupRatingAbilityReqBO.setScoringPrinciple(reqBO.getIntegralType());
        addSupRatingAbilityReqBO.setInspectionType(SupCommConstants.RatingBusinessType.RATING);
        addSupRatingAbilityReqBO.setInspectionDate(new Date());
        addSupRatingAbilityReqBO.setInspectionCompanyId(reqBO.getRelBusinessId());
        addSupRatingAbilityReqBO.setInspectionCompanyName(reqBO.getRatingRulesName());
        ArrayList<DycSupInspectionWeightBO> inspectionWeightBOS = new ArrayList<DycSupInspectionWeightBO>();
        DycSupplierEvaluateRuleQryDetailReqBO ruleQryDetailReqBO = new DycSupplierEvaluateRuleQryDetailReqBO();
        ruleQryDetailReqBO.setRatingRulesId(reqBO.getRatingRulesId());
        log.info("\u81ea\u52a8\u751f\u6210\u67e5\u8be2\u89c4\u5219\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)ruleQryDetailReqBO));
        DycSupplierEvaluateRuleQryDetailRspBO ruleQryDetailRspBO = this.dycSupplierEvaluateRuleQryDetailService.qryEvaluateRuleDetail(ruleQryDetailReqBO);
        log.info("\u81ea\u52a8\u751f\u6210\u67e5\u8be2\u89c4\u5219\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)ruleQryDetailRspBO));
        if (ObjectUtil.isEmpty((Object)ruleQryDetailRspBO.getAssessmentRatingListBOS())) {
            throw new ZTBusinessException("\u89c4\u5219\u660e\u7ec6\u4e3a\u7a7a");
        }
        addSupRatingAbilityReqBO.setScoringMode(ruleQryDetailRspBO.getScoreMethod());
        addSupRatingAbilityReqBO.setExpectDay(ruleQryDetailRspBO.getExpectDay());
        addSupRatingAbilityReqBO.setDraft(Boolean.valueOf(true));
        addSupRatingAbilityReqBO.setScoringType(ruleQryDetailRspBO.getScoreMethod());
        String version = "";
        for (AssessmentRatingListBO item : ruleQryDetailRspBO.getAssessmentRatingListBOS()) {
            DycSupInspectionWeightBO weightBO = new DycSupInspectionWeightBO();
            weightBO.setIndicatorsId(item.getIndicatorsId());
            weightBO.setRatingIndexId(item.getRatingIndexId());
            weightBO.setScoringDetailId(item.getScoringDetailId());
            weightBO.setInspectionRuleId(item.getRatingRulesId());
            weightBO.setWeightId(item.getWeightId());
            weightBO.setWeightSecondId(item.getWeightSecondId());
            weightBO.setWeightThirdId(item.getWeightThirdId());
            inspectionWeightBOS.add(weightBO);
            if (!ObjectUtil.isEmpty((Object)version)) continue;
            version = item.getVersion();
        }
        addSupRatingAbilityReqBO.setInspectionRuleVersion(version);
        addSupRatingAbilityReqBO.setInspectionWeightBOS(inspectionWeightBOS);
        addSupRatingAbilityReqBO.setTaskMark("0");
        log.info("\u81ea\u52a8\u751f\u6210\u8bc4\u5206\u8bc4\u7ea7\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addSupRatingAbilityReqBO));
        this.dycUmcAddSupRatingFunction.addSupRating(addSupRatingAbilityReqBO);
        return rspBO;
    }

    private Map<String, String> valCreateDate(Date nowDate, DycAutoCreateRatingOrderTaskFunctionReqBO reqBO) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        SimpleDateFormat sdfMonth = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfYear = new SimpleDateFormat("yyyy");
        int year = LocalDate.now().getYear();
        int month = LocalDate.now().getMonth().getValue();
        int quarter = (LocalDate.now().getMonth().getValue() - 1) / 3 + 1;
        if (reqBO.getRatingRulesCycleExt().equals(SupCommConstants.RatingRulesCycleExt.FRONT)) {
            if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.MONTH))) {
                Date firstDayOfMonthDate = this.getFirstDayForMonth();
                DateTime createDate = DateUtil.offset((Date)firstDayOfMonthDate, (DateField)DateField.DAY_OF_MONTH, (int)reqBO.getRatingRulesCycleNum());
                log.info("\u5f53\u524d\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{}", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
                if (month - 1 == 0) {
                    resultMap.put("ratingTime", year - 1 + "-" + 12);
                } else {
                    resultMap.put("ratingTime", year + "-" + String.valueOf(month - 1));
                }
            } else if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.QUARTER))) {
                Date firstDayOfQuarterDate = this.getFirstDayForQuarter();
                DateTime createDate = DateUtil.offset((Date)firstDayOfQuarterDate, (DateField)DateField.DAY_OF_MONTH, (int)reqBO.getRatingRulesCycleNum());
                if (!sdfMonth.format(nowDate).equals(sdfMonth.format((Date)createDate))) {
                    log.info("\u5f53\u524d\u5b63\u5ea6\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{},\u4e0e\u914d\u7f6e\u521b\u5efa\u65f6\u95f4\u4e0d\u5339\u914d", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
                    resultMap.put("mark", "false");
                    return resultMap;
                }
                if (quarter - 1 == 0) {
                    resultMap.put("ratingTime", year - 1 + "-" + 4);
                } else {
                    resultMap.put("ratingTime", year + "-" + String.valueOf(quarter - 1));
                }
            } else {
                LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
                Date firstDayOfYearDate = Date.from(firstDayOfYear.atStartOfDay(ZoneId.systemDefault()).toInstant());
                DateTime createDate = DateUtil.offset((Date)firstDayOfYearDate, (DateField)DateField.DAY_OF_MONTH, (int)reqBO.getRatingRulesCycleNum());
                if (!sdfMonth.format(nowDate).equals(sdfMonth.format((Date)createDate))) {
                    log.info("\u5f53\u524d\u5e74\u5ea6\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{},\u4e0e\u914d\u7f6e\u521b\u5efa\u65f6\u95f4\u4e0d\u5339\u914d", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
                    resultMap.put("mark", "false");
                    return resultMap;
                }
                resultMap.put("ratingTime", String.valueOf(year - 1));
            }
        } else if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.MONTH))) {
            Date lastDayOfMonthDate = this.getLastDayForMonth();
            DateTime createDate = DateUtil.offset((Date)lastDayOfMonthDate, (DateField)DateField.DAY_OF_MONTH, (int)(reqBO.getRatingRulesCycleNum() * -1));
            log.info("\u5f53\u524d\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{}", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
            if (!sdfMonth.format(nowDate).equals(sdfMonth.format((Date)createDate))) {
                log.info("\u5f53\u524d\u6708\u5ea6\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{},\u4e0e\u914d\u7f6e\u521b\u5efa\u65f6\u95f4\u4e0d\u5339\u914d", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
                resultMap.put("mark", "false");
                return resultMap;
            }
            resultMap.put("ratingTime", year + "-" + month);
        } else if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.QUARTER))) {
            Date lastDayOfQuarterDate = this.getLastDayForQuarter();
            DateTime createDate = DateUtil.offset((Date)lastDayOfQuarterDate, (DateField)DateField.DAY_OF_MONTH, (int)(reqBO.getRatingRulesCycleNum() * -1));
            if (!sdfMonth.format(nowDate).equals(sdfMonth.format((Date)createDate))) {
                log.info("\u5f53\u524d\u5b63\u5ea6\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{},\u4e0e\u914d\u7f6e\u521b\u5efa\u65f6\u95f4\u4e0d\u5339\u914d", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
                resultMap.put("mark", "false");
                return resultMap;
            }
            resultMap.put("ratingTime", year + "-" + quarter);
        } else {
            LocalDate lastDayOfYear = LocalDate.of(year, 12, 31);
            Date lastDayOfYearDate = Date.from(lastDayOfYear.atStartOfDay(ZoneId.systemDefault()).toInstant());
            DateTime createDate = DateUtil.offset((Date)lastDayOfYearDate, (DateField)DateField.DAY_OF_MONTH, (int)reqBO.getRatingRulesCycleNum());
            if (!sdfMonth.format(nowDate).equals(sdfMonth.format((Date)createDate))) {
                log.info("\u5f53\u524d\u5e74\u5ea6\u65f6\u95f4\uff1a{},\u521b\u5efa\u65f6\u95f4:{},\u4e0e\u914d\u7f6e\u521b\u5efa\u65f6\u95f4\u4e0d\u5339\u914d", (Object)sdfMonth.format(nowDate), (Object)sdfMonth.format((Date)createDate));
                resultMap.put("mark", "false");
                return resultMap;
            }
            resultMap.put("ratingTime", year + "");
        }
        resultMap.put("mark", "true");
        return resultMap;
    }

    private Date getFirstDayForMonth() {
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDate firstDayOfMonth = dateTime.withDayOfMonth(1).toLocalDate();
        Date firstDayOfMonthDate = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return firstDayOfMonthDate;
    }

    private Date getLastDayForMonth() {
        LocalDateTime dateTime = LocalDateTime.now();
        LocalDate lastDayOfMonth = dateTime.withDayOfMonth(LocalDate.now().lengthOfMonth()).toLocalDate();
        Date lastDayOfMonthDate = Date.from(lastDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return lastDayOfMonthDate;
    }

    private Date getFirstDayForQuarter() {
        LocalDate today = LocalDate.now();
        LocalDate firstDayOfQuarter = today.withMonth((today.getMonthValue() - 1) / 3 * 3 + 1).withDayOfMonth(1);
        Date firstDayOfQuarterDate = Date.from(firstDayOfQuarter.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return firstDayOfQuarterDate;
    }

    private Date getLastDayForQuarter() {
        LocalDate date = LocalDate.now();
        int quarter = (date.getMonthValue() - 1) / 3 + 1;
        LocalDate lastDayOfQuarter = date.withMonth(quarter * 3).withDayOfMonth(1).plusMonths(1L).minusDays(1L);
        Date lastDayOfQuarterDate = Date.from(lastDayOfQuarter.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return lastDayOfQuarterDate;
    }

    private void getStatisticData(DycAutoCreateRatingOrderTaskFunctionReqBO reqBO, String timeStr, List<AssessmentRatingListBO> assessmentRatingListBOS) {
        List supIndicatorsStatisticsRelationPOS = this.supIndicatorsStatisticsRelationMapper.getList(new SupIndicatorsStatisticsRelationPO());
        Map<String, List<SupIndicatorsStatisticsRelationPO>> supIndicatorsStatisticsRelationMapList = supIndicatorsStatisticsRelationPOS.stream().collect(Collectors.groupingBy(SupIndicatorsStatisticsRelationPO::getIndicatorsStatisticsCode));
        Map<String, List<AssessmentRatingListBO>> assessmentRatingListMap = assessmentRatingListBOS.stream().collect(Collectors.groupingBy(o -> o.getIndicatorsId() + "-" + o.getRatingIndexId() + "-" + o.getScoringDetailId()));
        if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.MONTH))) {
            String[] timeStrList = timeStr.split("-");
            String year = timeStrList[0];
            String month = timeStrList[1];
            SupIndicatorsStatisticsMonthPO supIndicatorsStatisticsMonthPO = new SupIndicatorsStatisticsMonthPO();
            supIndicatorsStatisticsMonthPO.setSupplierId(reqBO.getSupplierId());
            supIndicatorsStatisticsMonthPO.setBusinessCompanyId(reqBO.getRelBusinessId());
            supIndicatorsStatisticsMonthPO.setStatisticsDateYear(year);
            supIndicatorsStatisticsMonthPO.setStatisticsDateMonth(month);
            supIndicatorsStatisticsMonthPO = this.supIndicatorsStatisticsMonthMapper.getModelBy(supIndicatorsStatisticsMonthPO);
            if (!ObjectUtil.isEmpty((Object)supIndicatorsStatisticsMonthPO)) {
                JSONObject object = (JSONObject)JSON.toJSON((Object)supIndicatorsStatisticsMonthPO);
                object.forEach((key, value) -> {
                    String assessmentRatingListMapKey;
                    log.info("key--------:{}", key);
                    log.info("val--------:{}", value);
                    List tempList = (List)supIndicatorsStatisticsRelationMapList.get(key);
                    BigDecimal score = BigDecimal.ZERO;
                    Long indicatorsId = null;
                    Long ratingIndexId = null;
                    Long scoringDetailId = null;
                    for (SupIndicatorsStatisticsRelationPO item : tempList) {
                        Boolean marks = false;
                        if (item.getScoringCriteriaType().equals(1)) {
                            if (item.getMaxScoreType().equals(1) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) > 0 && item.getMinScoreType().equals(3) && item.getMinScore().compareTo(new BigDecimal(value.toString())) < 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(1) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) > 0 && item.getMinScoreType().equals(4) && item.getMinScore().compareTo(new BigDecimal(value.toString())) <= 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(2) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) >= 0 && item.getMinScoreType().equals(3) && item.getMinScore().compareTo(new BigDecimal(value.toString())) < 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(2) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) >= 0 && item.getMinScoreType().equals(4) && item.getMinScore().compareTo(new BigDecimal(value.toString())) <= 0) {
                                marks = true;
                            }
                            if (!marks.booleanValue()) continue;
                            if (item.getComputeMode().equals(1)) {
                                score = score.add(item.getScore());
                            } else if (item.getComputeMode().equals(2)) {
                                score = score.subtract(item.getScore());
                            }
                            indicatorsId = item.getIndicatorsId();
                            ratingIndexId = item.getRatingIndexId();
                            scoringDetailId = item.getScoringDetailId();
                            break;
                        }
                        if (!item.getScoringCriteriaType().equals(2)) continue;
                        score = new BigDecimal(value.toString()).multiply(item.getScore());
                        indicatorsId = item.getIndicatorsId();
                        ratingIndexId = item.getRatingIndexId();
                        scoringDetailId = item.getScoringDetailId();
                        break;
                    }
                    if (ObjectUtil.isEmpty((Object)ObjectUtil.isEmpty(assessmentRatingListMap.get(assessmentRatingListMapKey = indicatorsId + "-" + ratingIndexId + "-" + scoringDetailId)))) {
                        List assessmentRatingList = (List)assessmentRatingListMap.get(assessmentRatingListMapKey);
                        for (AssessmentRatingListBO assessmentRatingListBO : assessmentRatingList) {
                            assessmentRatingListBO.setEstimatedScore(score);
                        }
                    }
                });
            }
        } else if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.QUARTER))) {
            String[] timeStrList = timeStr.split("-");
            String year = timeStrList[0];
            String quarter = timeStrList[1];
            SupIndicatorsStatisticsQuarterPO supIndicatorsStatisticsQuarterPO = new SupIndicatorsStatisticsQuarterPO();
            supIndicatorsStatisticsQuarterPO.setSupplierId(reqBO.getSupplierId());
            supIndicatorsStatisticsQuarterPO.setBusinessCompanyId(reqBO.getRelBusinessId());
            supIndicatorsStatisticsQuarterPO.setStatisticsDateYear(year);
            supIndicatorsStatisticsQuarterPO.setStatisticsDateQuarter(quarter);
            supIndicatorsStatisticsQuarterPO = this.supIndicatorsStatisticsQuarterMapper.getModelBy(supIndicatorsStatisticsQuarterPO);
            if (!ObjectUtil.isEmpty((Object)supIndicatorsStatisticsQuarterPO)) {
                JSONObject object = (JSONObject)JSON.toJSON((Object)supIndicatorsStatisticsQuarterPO);
                object.forEach((key, value) -> {
                    String assessmentRatingListMapKey;
                    log.info("key--------:{}", key);
                    log.info("val--------:{}", value);
                    List tempList = (List)supIndicatorsStatisticsRelationMapList.get(key);
                    BigDecimal score = BigDecimal.ZERO;
                    Long indicatorsId = null;
                    Long ratingIndexId = null;
                    Long scoringDetailId = null;
                    for (SupIndicatorsStatisticsRelationPO item : tempList) {
                        Boolean marks = false;
                        if (item.getScoringCriteriaType().equals(1)) {
                            if (item.getMaxScoreType().equals(1) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) > 0 && item.getMinScoreType().equals(3) && item.getMinScore().compareTo(new BigDecimal(value.toString())) < 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(1) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) > 0 && item.getMinScoreType().equals(4) && item.getMinScore().compareTo(new BigDecimal(value.toString())) <= 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(2) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) >= 0 && item.getMinScoreType().equals(3) && item.getMinScore().compareTo(new BigDecimal(value.toString())) < 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(2) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) >= 0 && item.getMinScoreType().equals(4) && item.getMinScore().compareTo(new BigDecimal(value.toString())) <= 0) {
                                marks = true;
                            }
                            if (!marks.booleanValue()) continue;
                            if (item.getComputeMode().equals(1)) {
                                score = score.add(item.getScore());
                            } else if (item.getComputeMode().equals(2)) {
                                score = score.subtract(item.getScore());
                            }
                            indicatorsId = item.getIndicatorsId();
                            ratingIndexId = item.getRatingIndexId();
                            scoringDetailId = item.getScoringDetailId();
                            break;
                        }
                        if (!item.getScoringCriteriaType().equals(2)) continue;
                        score = new BigDecimal(value.toString()).multiply(item.getScore());
                        indicatorsId = item.getIndicatorsId();
                        ratingIndexId = item.getRatingIndexId();
                        scoringDetailId = item.getScoringDetailId();
                        break;
                    }
                    if (ObjectUtil.isEmpty((Object)ObjectUtil.isEmpty(assessmentRatingListMap.get(assessmentRatingListMapKey = indicatorsId + "-" + ratingIndexId + "-" + scoringDetailId)))) {
                        List assessmentRatingList = (List)assessmentRatingListMap.get(assessmentRatingListMapKey);
                        for (AssessmentRatingListBO assessmentRatingListBO : assessmentRatingList) {
                            assessmentRatingListBO.setEstimatedScore(score);
                        }
                    }
                });
            }
        } else {
            String[] timeStrList = timeStr.split("-");
            String year = timeStrList[0];
            SupIndicatorsStatisticsYearPO supIndicatorsStatisticsYearPO = new SupIndicatorsStatisticsYearPO();
            supIndicatorsStatisticsYearPO.setSupplierId(reqBO.getSupplierId());
            supIndicatorsStatisticsYearPO.setBusinessCompanyId(reqBO.getRelBusinessId());
            supIndicatorsStatisticsYearPO.setStatisticsDateYear(year);
            supIndicatorsStatisticsYearPO = this.supIndicatorsStatisticsYearMapper.getModelBy(supIndicatorsStatisticsYearPO);
            if (!ObjectUtil.isEmpty((Object)supIndicatorsStatisticsYearPO)) {
                JSONObject object = (JSONObject)JSON.toJSON((Object)supIndicatorsStatisticsYearPO);
                object.forEach((key, value) -> {
                    String assessmentRatingListMapKey;
                    log.info("key--------:{}", key);
                    log.info("val--------:{}", value);
                    List tempList = (List)supIndicatorsStatisticsRelationMapList.get(key);
                    BigDecimal score = BigDecimal.ZERO;
                    Long indicatorsId = null;
                    Long ratingIndexId = null;
                    Long scoringDetailId = null;
                    for (SupIndicatorsStatisticsRelationPO item : tempList) {
                        Boolean marks = false;
                        if (item.getScoringCriteriaType().equals(1)) {
                            if (item.getMaxScoreType().equals(1) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) > 0 && item.getMinScoreType().equals(3) && item.getMinScore().compareTo(new BigDecimal(value.toString())) < 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(1) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) > 0 && item.getMinScoreType().equals(4) && item.getMinScore().compareTo(new BigDecimal(value.toString())) <= 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(2) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) >= 0 && item.getMinScoreType().equals(3) && item.getMinScore().compareTo(new BigDecimal(value.toString())) < 0) {
                                marks = true;
                            } else if (item.getMaxScoreType().equals(2) && item.getMaxScore().compareTo(new BigDecimal(value.toString())) >= 0 && item.getMinScoreType().equals(4) && item.getMinScore().compareTo(new BigDecimal(value.toString())) <= 0) {
                                marks = true;
                            }
                            if (!marks.booleanValue()) continue;
                            if (item.getComputeMode().equals(1)) {
                                score = score.add(item.getScore());
                            } else if (item.getComputeMode().equals(2)) {
                                score = score.subtract(item.getScore());
                            }
                            indicatorsId = item.getIndicatorsId();
                            ratingIndexId = item.getRatingIndexId();
                            scoringDetailId = item.getScoringDetailId();
                            break;
                        }
                        if (!item.getScoringCriteriaType().equals(2)) continue;
                        score = new BigDecimal(value.toString()).multiply(item.getScore());
                        indicatorsId = item.getIndicatorsId();
                        ratingIndexId = item.getRatingIndexId();
                        scoringDetailId = item.getScoringDetailId();
                        break;
                    }
                    if (ObjectUtil.isEmpty((Object)ObjectUtil.isEmpty(assessmentRatingListMap.get(assessmentRatingListMapKey = indicatorsId + "-" + ratingIndexId + "-" + scoringDetailId)))) {
                        List assessmentRatingList = (List)assessmentRatingListMap.get(assessmentRatingListMapKey);
                        for (AssessmentRatingListBO assessmentRatingListBO : assessmentRatingList) {
                            assessmentRatingListBO.setEstimatedScore(score);
                        }
                    }
                });
            }
        }
    }

    private void getCycleAverageScore(DycAutoCreateRatingOrderTaskFunctionReqBO reqBO, String timeStr) {
        String year;
        String[] timeStrList;
        SupInspectionPO supInspectionPO = new SupInspectionPO();
        supInspectionPO.setSupplierId(reqBO.getSupplierId());
        supInspectionPO.setInspectionCompanyId(reqBO.getRelBusinessId());
        supInspectionPO.setInspectionType(SupCommConstants.RatingBusinessType.RATING);
        if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.QUARTER))) {
            timeStrList = timeStr.split("-");
            year = timeStrList[0];
            String quarter = timeStrList[1];
            supInspectionPO.setInspectionYear(Integer.valueOf(Integer.parseInt(year)));
            supInspectionPO.setInspectionQuarter(Integer.valueOf(Integer.parseInt(quarter)));
        } else if (reqBO.getRatingRulesCycle().equals(String.valueOf(SupCommConstants.InspectionCycleType.YEAR))) {
            timeStrList = timeStr.split("-");
            year = timeStrList[0];
            supInspectionPO.setInspectionYear(Integer.valueOf(Integer.parseInt(year)));
        }
        List supInspectionPOS = this.supInspectionMapper.getList(supInspectionPO);
        Set ruleIds = supInspectionPOS.stream().map(SupInspectionPO::getInspectionRuleId).collect(Collectors.toSet());
        if (ruleIds.size() > 1) {
            throw new BaseBusinessException("161004", "\u81ea\u52a8\u521b\u5efa\u8bc4\u5206\u8868\u5931\u8d25:\u5468\u671f\u5185\u5b58\u5728\u4e0d\u4e00\u6837\u7684\u89c4\u5219");
        }
    }
}

