/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.atom.transaction.api.UmcDistributeQryListService;
import com.tydic.dyc.atom.transaction.api.UmcOrgQryCompensateListService;
import com.tydic.dyc.atom.transaction.bo.UmcDistributeQryListBo;
import com.tydic.dyc.atom.transaction.bo.UmcOrgQryCompensateListReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcOrgQryCompensateListRspBo;
import com.tydic.dyc.authority.repository.dao.SysOrgInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysOrgTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysOrgInfoPo;
import com.tydic.dyc.authority.repository.po.SysOrgTagRelPo;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseContactMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgTagRelPo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcDistributeQryListService"})
public class UmcDistributeQryListServiceImpl
implements UmcDistributeQryListService {
    private static final Logger log = LoggerFactory.getLogger(UmcDistributeQryListServiceImpl.class);
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcEnterpriseInfoMapper umcEnterpriseInfoMapper;
    @Autowired
    private UmcEnterpriseContactMapper umcEnterpriseContactMapper;
    @Autowired
    private UmcOrgTagRelMapper umcOrgTagRelMapper;
    @Autowired
    private SysOrgInfoMapper sysOrgInfoMapper;
    @Autowired
    private SysOrgTagRelMapper sysOrgTagRelMapper;
    @Autowired
    private UmcOrgQryCompensateListService umcOrgQryCompensateListService;

    @PostMapping(value={"qryDistributeOrgList"})
    public String qryDistributeOrgList(@RequestBody String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        JSONObject envelope = jsonObject.getJSONObject("envelope");
        JSONObject mdm_data = jsonObject.getJSONObject("mdm_data");
        JSONObject esb = mdm_data.getJSONObject("esb");
        JSONObject data = esb.getJSONObject("data");
        JSONObject datainfos = data.getJSONObject("datainfos");
        JSONArray datainfoArray = (JSONArray)datainfos.get((Object)"datainfo");
        List umcDistributeQryListBos = datainfoArray.toJavaList(UmcDistributeQryListBo.class);
        JSONArray array = new JSONArray();
        ArrayList<Long> list = new ArrayList<Long>();
        for (UmcDistributeQryListBo umcDistributeQryListBo : umcDistributeQryListBos) {
            this.validate(umcDistributeQryListBo);
            JSONObject object = new JSONObject();
            object.put("code", (Object)umcDistributeQryListBo.getPerson_code());
            object.put("uuid", (Object)umcDistributeQryListBo.getUuid());
            object.put("synstatus", (Object)"0");
            object.put("synresult", (Object)"\u66f4\u65b0\u6210\u529f");
            try {
                UmcOrgInfoPo umcOrgInfoPo = this.saveOrUpdateUmcOrgInfo(umcDistributeQryListBo, list);
                this.saveOrUpdateUmcEnterpriseInfo(umcDistributeQryListBo, umcOrgInfoPo);
                UmcOrgTagRelPo umcOrgTagRelPo = this.saveOrUpdateUmcOrgTagRel(umcOrgInfoPo);
                this.saveOrUpdateSysOrgInfo(umcOrgInfoPo);
                this.saveOrUpdateSysRel(umcOrgInfoPo, umcOrgTagRelPo);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u6216\u63d2\u5165\u5931\u8d25,\u56e0\u4e3a:{}", (Throwable)e);
                object.put("synstatus", (Object)"1");
                object.put("synresult", (Object)"\u66f4\u65b0\u5931\u8d25");
                array.add((Object)object);
                esb.put("result", (Object)"E");
                esb.put("desc", (Object)"\u8ba2\u9605\u66f4\u65b0\u4e3b\u6570\u636e\u5931\u8d25");
                throw new ZTBusinessException("\u6279\u91cf\u66f4\u65b0\u6216\u63d2\u5165\u5931\u8d25");
            }
            array.add((Object)object);
        }
        UmcOrgQryCompensateListReqBo reqBo = new UmcOrgQryCompensateListReqBo();
        reqBo.setList(list);
        UmcOrgQryCompensateListRspBo umcOrgQryCompensateListRspBo = this.umcOrgQryCompensateListService.compensateOrg(reqBo);
        if (!Objects.equals(umcOrgQryCompensateListRspBo.getRespCode(), "0000")) {
            throw new ZTBusinessException("\u589e\u91cf\u66f4\u65b0\u4e2d\u8c03\u7528\u8865\u507f\u63a5\u53e3\u5904\u7406\u6570\u636e\u5931\u8d25");
        }
        datainfos.put("datainfo1", (Object)array);
        esb.put("result", (Object)"S");
        esb.put("desc", (Object)"\u6210\u529f");
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("envelope", (Object)envelope);
        jsonObject1.put("mdm_data", (Object)mdm_data);
        return this.buildRsp(jsonObject1);
    }

    private String buildRsp(JSONObject jsonObject) {
        JSONObject datainfos = new JSONObject();
        JSONObject mdmData1 = jsonObject.getJSONObject("mdm_data");
        JSONObject esb1 = mdmData1.getJSONObject("esb");
        JSONObject data1 = esb1.getJSONObject("data");
        JSONObject datainfos1 = data1.getJSONObject("datainfos");
        datainfos.put("puuid", (Object)datainfos1.getJSONObject("datainfos").getString("puuid"));
        datainfos.put("datainfo", (Object)datainfos1.getJSONArray("datainfo1"));
        JSONObject data = new JSONObject();
        data.put("datainfos", (Object)datainfos);
        JSONObject esb = new JSONObject();
        esb.put("result", (Object)esb1.getString("result"));
        esb.put("desc", (Object)esb1.getString("desc"));
        esb.put("data", (Object)data);
        JSONObject mdm_data = new JSONObject();
        mdm_data.put("esb", (Object)esb);
        JSONObject json = new JSONObject();
        json.put("envelope", (Object)jsonObject.getJSONObject("envelope"));
        json.put("mdm_data", (Object)mdm_data);
        return json.toJSONString();
    }

    private void validate(UmcDistributeQryListBo umcDistributeQryListBo) {
        String fullName = umcDistributeQryListBo.getFull_name();
        if (StringUtils.isEmpty((Object)fullName)) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String org_type = umcDistributeQryListBo.getOrg_type();
        if (StringUtils.isEmpty((Object)org_type)) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String hr_org_status = umcDistributeQryListBo.getHr_org_status();
        if (StringUtils.isEmpty((Object)hr_org_status)) {
            throw new ZTBusinessException("\u4eba\u4e8b\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String org_code = umcDistributeQryListBo.getOrg_code();
        if (StringUtils.isEmpty((Object)org_code)) {
            throw new ZTBusinessException("\u4e3b\u6a21\u578b\u4e3b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveOrUpdateSysRel(UmcOrgInfoPo umcOrgInfoPo, UmcOrgTagRelPo umcOrgTagRelPo) {
        SysOrgTagRelPo sysOrgTagRelPo = (SysOrgTagRelPo)JSON.parseObject((String)JSON.toJSONString((Object)umcOrgTagRelPo), SysOrgTagRelPo.class);
        SysOrgTagRelPo where = new SysOrgTagRelPo();
        where.setOrgId(umcOrgInfoPo.getOrgId());
        where.setDelFlag("0");
        SysOrgTagRelPo sysOrgTagRelMapperModelBy = this.sysOrgTagRelMapper.getModelBy(where);
        if (sysOrgTagRelMapperModelBy == null) {
            this.sysOrgTagRelMapper.insert(sysOrgTagRelPo);
        } else {
            this.sysOrgTagRelMapper.updateBy(sysOrgTagRelPo, where);
        }
    }

    private void saveOrUpdateSysOrgInfo(UmcOrgInfoPo umcOrgInfoPo) {
        SysOrgInfoPo sysOrgInfoPo = (SysOrgInfoPo)JSON.parseObject((String)JSON.toJSONString((Object)umcOrgInfoPo), SysOrgInfoPo.class);
        SysOrgInfoPo where = new SysOrgInfoPo();
        where.setOrgId(sysOrgInfoPo.getOrgId());
        SysOrgInfoPo sysOrgInfoMapperModelBy = this.sysOrgInfoMapper.getModelBy(where);
        if (sysOrgInfoMapperModelBy == null) {
            this.sysOrgInfoMapper.insert(sysOrgInfoPo);
        } else {
            this.sysOrgInfoMapper.updateBy(sysOrgInfoPo, where);
        }
    }

    @NotNull
    private UmcOrgTagRelPo saveOrUpdateUmcOrgTagRel(UmcOrgInfoPo umcOrgInfoPo) {
        UmcOrgTagRelPo umcOrgTagRelPo = new UmcOrgTagRelPo();
        umcOrgTagRelPo.setOrgId(umcOrgInfoPo.getOrgId());
        umcOrgTagRelPo.setDelFlag("0");
        UmcOrgTagRelPo umcOrgTagRelMapperModelBy = this.umcOrgTagRelMapper.getModelBy(umcOrgTagRelPo);
        umcOrgTagRelPo.setTagId("1");
        umcOrgTagRelPo.setUpdateTime(new Date());
        umcOrgTagRelPo.setEffTime(umcOrgInfoPo.getEffTime());
        if (umcOrgTagRelMapperModelBy == null) {
            umcOrgTagRelPo.setTagStatus("1");
            umcOrgTagRelPo.setTenantId(Long.valueOf(10000L));
            umcOrgTagRelPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
            umcOrgTagRelPo.setCreateTime(new Date());
            this.umcOrgTagRelMapper.insert(umcOrgTagRelPo);
        } else {
            UmcOrgTagRelPo where = new UmcOrgTagRelPo();
            where.setDelFlag("0");
            where.setOrgId(umcOrgTagRelPo.getOrgId());
            this.umcOrgTagRelMapper.updateBy(umcOrgTagRelPo, where);
        }
        return umcOrgTagRelPo;
    }

    private void saveOrUpdateUmcEnterpriseInfo(UmcDistributeQryListBo umcDistributeQryListBo, UmcOrgInfoPo umcOrgInfoPo) {
        UmcEnterpriseInfoPo umcEnterpriseInfoPo = new UmcEnterpriseInfoPo();
        umcEnterpriseInfoPo.setOrgId(umcOrgInfoPo.getOrgId());
        UmcEnterpriseInfoPo umcOrgInfoMapperModelBy = this.umcEnterpriseInfoMapper.getModelBy(umcEnterpriseInfoPo);
        umcEnterpriseInfoPo.setOrgName(umcDistributeQryListBo.getFull_name());
        umcEnterpriseInfoPo.setOrgEnName(umcOrgInfoMapperModelBy.getOrgEnName());
        umcEnterpriseInfoPo.setOrgShortName(umcOrgInfoMapperModelBy.getOrgShortName());
        umcEnterpriseInfoPo.setEffDate(umcOrgInfoMapperModelBy.getEffDate());
        umcEnterpriseInfoPo.setOrgNature(umcOrgInfoMapperModelBy.getOrgNature());
        umcEnterpriseInfoPo.setUpdateTime(new Date());
        if (umcOrgInfoMapperModelBy == null) {
            umcEnterpriseInfoPo.setOrgClass("4");
            umcEnterpriseInfoPo.setIsMerchant("0");
            umcEnterpriseInfoPo.setIsShopOrg("1");
            umcEnterpriseInfoPo.setTenantId(Long.valueOf(10000L));
            umcEnterpriseInfoPo.setCreateTime(new Date());
            this.umcEnterpriseInfoMapper.insert(umcEnterpriseInfoPo);
        } else {
            UmcEnterpriseInfoPo where = new UmcEnterpriseInfoPo();
            where.setOrgId(umcEnterpriseInfoPo.getOrgId());
            where.setDelFlag("0");
            this.umcEnterpriseInfoMapper.updateBy(umcEnterpriseInfoPo, where);
        }
    }

    @NotNull
    private UmcOrgInfoPo saveOrUpdateUmcOrgInfo(UmcDistributeQryListBo umcDistributeQryListBo, List<Long> list) {
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        long org_Id = Sequence.getInstance().nextId();
        umcOrgInfoPo.setExtOrgCode(umcDistributeQryListBo.getOrg_code());
        UmcOrgInfoPo modelBy = this.umcOrgInfoMapper.getModelBy(umcOrgInfoPo);
        umcOrgInfoPo.setOrgName(umcDistributeQryListBo.getFull_name());
        umcOrgInfoPo.setOrgAlias(umcDistributeQryListBo.getShort_name());
        umcOrgInfoPo.setParentId(umcDistributeQryListBo.getBuss_parent_id());
        umcOrgInfoPo.setExtField1(umcDistributeQryListBo.getCmp_level());
        umcOrgInfoPo.setExtField2(umcDistributeQryListBo.getDept_level());
        umcOrgInfoPo.setUpdateTime(new Date());
        UmcOrgInfoPo umcOrgInfoPoPar = this.umcOrgInfoMapper.qryParNode(umcOrgInfoPo);
        if (umcDistributeQryListBo.getHr_org_status() == "A") {
            umcOrgInfoPo.setOrgStatus("1");
        } else {
            umcOrgInfoPo.setOrgStatus("0");
        }
        if (umcDistributeQryListBo.getOrg_type() == "10" || umcDistributeQryListBo.getOrg_type() == "11") {
            umcOrgInfoPo.setOrgType(Long.valueOf(2L));
        } else if (umcDistributeQryListBo.getOrg_type() == "20" || umcDistributeQryListBo.getOrg_type() == "21") {
            umcOrgInfoPo.setOrgType(Long.valueOf(3L));
        }
        if (modelBy == null) {
            umcOrgInfoPo.setOrgId(Long.valueOf(org_Id));
            umcOrgInfoPo.setOrgCode(String.valueOf(org_Id));
            umcOrgInfoPo.setDelFlag("0");
            umcOrgInfoPo.setTenantId(Long.valueOf(10000L));
            umcOrgInfoPo.setIsVirtual("0");
            umcOrgInfoPo.setCreateTime(new Date());
            if (umcOrgInfoPoPar != null) {
                umcOrgInfoPo.setOrgTreePath(umcOrgInfoPoPar.getOrgTreePath() + org_Id + "-");
            } else {
                list.add(umcOrgInfoPo.getOrgId());
            }
            this.umcOrgInfoMapper.insert(umcOrgInfoPo);
        } else {
            umcOrgInfoPo.setOrgId(modelBy.getOrgId());
            if (umcOrgInfoPoPar != null) {
                umcOrgInfoPo.setOrgTreePath(umcOrgInfoPoPar.getOrgTreePath() + modelBy.getOrgId() + "-");
            } else {
                list.add(umcOrgInfoPo.getOrgId());
            }
            UmcOrgInfoPo where = new UmcOrgInfoPo();
            where.setOrgId(umcOrgInfoPo.getOrgId());
            this.umcOrgInfoMapper.updateBy(umcOrgInfoPo, where);
        }
        return umcOrgInfoPo;
    }
}

