/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import com.tydic.dyc.atom.base.utils.IdUtil;
import com.tydic.dyc.atom.transaction.api.UmcEnableFregjtRuleAddService;
import com.tydic.dyc.atom.transaction.bo.UmcEnableFregjtRuleAddReqBO;
import com.tydic.dyc.atom.transaction.bo.UmcEnableFregjtRuleAddRspBO;
import com.tydic.dyc.umc.repository.dao.UmcEnableFreightRuleMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnableFreightRuleScopeMapper;
import com.tydic.dyc.umc.repository.po.UmcEnableFreightRulePO;
import com.tydic.dyc.umc.repository.po.UmcEnableFreightRuleScopePO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcEnableFregjtRuleAddService"})
public class UmcEnableFregjtRuleAddServiceImpl
implements UmcEnableFregjtRuleAddService {
    private static final Logger log = LoggerFactory.getLogger(UmcEnableFregjtRuleAddServiceImpl.class);
    @Autowired
    private UmcEnableFreightRuleMapper umcEnableFreightRuleMapper;
    @Autowired
    private UmcEnableFreightRuleScopeMapper umcEnableFreightRuleScopeMapper;

    @PostMapping(value={"addEnableFregjtRule"})
    public UmcEnableFregjtRuleAddRspBO addEnableFregjtRule(@RequestBody UmcEnableFregjtRuleAddReqBO reqBO) {
        UmcEnableFregjtRuleAddRspBO rspBO = new UmcEnableFregjtRuleAddRspBO();
        rspBO.setRespCode("0000");
        this.check(reqBO, rspBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        UmcEnableFreightRulePO rulePO = new UmcEnableFreightRulePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)rulePO);
        rulePO.setCreateOperId(reqBO.getUserId());
        rulePO.setCreateOperName(reqBO.getUserName());
        rulePO.setCreateTime(new Date());
        rulePO.setId(Long.valueOf(IdUtil.nextId()));
        rulePO.setDefaultValue(Integer.valueOf(0));
        this.umcEnableFreightRuleMapper.insert(rulePO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getScope())) {
            ArrayList scopePOList = new ArrayList();
            reqBO.getScope().forEach(a -> {
                UmcEnableFreightRuleScopePO scopePO = new UmcEnableFreightRuleScopePO();
                scopePO.setId(Long.valueOf(IdUtil.nextId()));
                scopePO.setRuleId(rulePO.getId());
                scopePO.setScopeType(Integer.valueOf(1));
                if (!StringUtils.isEmpty((Object)a.getAddrProvinceCode())) {
                    scopePO.setScopeCode(a.getAddrProvinceCode());
                }
                if (!StringUtils.isEmpty((Object)a.getAddrCityCode())) {
                    scopePO.setScopeCode(a.getAddrCityCode());
                }
                if (!StringUtils.isEmpty((Object)a.getAddrProvinceName())) {
                    scopePO.setScopeName(a.getAddrProvinceName());
                }
                if (!StringUtils.isEmpty((Object)a.getAddrCityName())) {
                    scopePO.setScopeName(a.getAddrCityName());
                }
                scopePOList.add(scopePO);
            });
            this.umcEnableFreightRuleScopeMapper.insertBatch(scopePOList);
        }
        rspBO.setRuleId(rulePO.getId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UmcEnableFregjtRuleAddRspBO check(UmcEnableFregjtRuleAddReqBO reqBO, UmcEnableFregjtRuleAddRspBO rspBO) {
        if (reqBO.getSupId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u4f9b\u5e94\u5546ID");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)reqBO.getSaleChannel()) && CollectionUtils.isEmpty((Collection)reqBO.getScope())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u201c\u6307\u5b9a\u5546\u57ce\u201d\u548c\u201c\u6307\u5b9a\u5730\u533a\u201d\u4e8c\u8005\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getPost() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u662f\u5426\u5305\u90ae\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getFreightInsurance() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u662f\u5426\u542b\u8fd0\u8d39\u9669\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getFreight() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9ed8\u8ba4\u8fd0\u8d39\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getFreight().compareTo(new BigDecimal(0)) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9ed8\u8ba4\u8fd0\u8d39\u91cd\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
            return rspBO;
        }
        if (reqBO.getFreightTolalFee() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8fd0\u8d39\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getFreightTolalFee().compareTo(new BigDecimal(0)) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8fd0\u8d39\u4e0d\u80fd\u5c0f\u4e8e0");
            return rspBO;
        }
        if (reqBO.getFreight().remainder(new BigDecimal("0.5")).compareTo(new BigDecimal(0)) != 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9ed8\u8ba4\u8fd0\u8d39\u91cd\u91cf\u5fc5\u987b0.5\u7684\u500d\u6570");
            return rspBO;
        }
        if (reqBO.getIncrement() != null && reqBO.getIncrement().compareTo(new BigDecimal(0)) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9ed8\u8ba4\u8fd0\u8d39\u589e\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
            return rspBO;
        }
        if (reqBO.getIncrement() != null && reqBO.getIncrement().remainder(new BigDecimal("0.5")).compareTo(new BigDecimal(0)) != 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9ed8\u8ba4\u8fd0\u8d39\u589e\u91cf\u5fc5\u987b0.5\u7684\u500d\u6570");
            return rspBO;
        }
        return rspBO;
    }
}

