/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.atom.transaction.api.UmcImportSupplierObjectiveIndicatorsService;
import com.tydic.dyc.umc.repository.dao.ScoringIndicatorsMapper;
import com.tydic.dyc.umc.repository.dao.SupObjectiveIndicatorsImportItemMapper;
import com.tydic.dyc.umc.repository.dao.SupObjectiveIndicatorsImportMainMapper;
import com.tydic.dyc.umc.repository.dao.SupObjectiveIndicatorsItemMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEnableInfoMapper;
import com.tydic.dyc.umc.repository.po.ScoringIndicatorsPO;
import com.tydic.dyc.umc.repository.po.SupObjectiveIndicatorsImportItemPO;
import com.tydic.dyc.umc.repository.po.SupObjectiveIndicatorsImportMainPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierEnableInfoPO;
import com.tydic.dyc.umc.service.objectiveindicators.bo.UmcImportSupplierObjectiveIndicatorsReqBO;
import com.tydic.dyc.umc.service.objectiveindicators.bo.UmcImportSupplierObjectiveIndicatorsRspBO;
import com.tydic.dyc.umc.utils.SupExcelUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcImportSupplierObjectiveIndicatorsService"})
public class UmcImportSupplierObjectiveIndicatorsServiceImpl
implements UmcImportSupplierObjectiveIndicatorsService {
    private static final Logger log = LoggerFactory.getLogger(UmcImportSupplierObjectiveIndicatorsServiceImpl.class);
    @Autowired
    private UmcSupplierEnableInfoMapper umcSupplierEnableInfoMapper;
    @Autowired
    private ScoringIndicatorsMapper scoringIndicatorsMapper;
    @Autowired
    private SupObjectiveIndicatorsImportMainMapper supObjectiveIndicatorsImportMainMapper;
    @Autowired
    private SupObjectiveIndicatorsImportItemMapper supObjectiveIndicatorsImportItemMapper;
    @Autowired
    private SupObjectiveIndicatorsItemMapper supObjectiveIndicatorsItemMapper;

    @PostMapping(value={"importSupplierObjectiveIndicators"})
    public UmcImportSupplierObjectiveIndicatorsRspBO importSupplierObjectiveIndicators(@RequestBody UmcImportSupplierObjectiveIndicatorsReqBO reqBO) {
        UmcImportSupplierObjectiveIndicatorsRspBO rspBO = new UmcImportSupplierObjectiveIndicatorsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        File file = UmcImportSupplierObjectiveIndicatorsServiceImpl.getExcelFileByUrl(reqBO.getFileUrl());
        List excelData = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = SupExcelUtils.getExcelData((MultipartFile)multipartFile, (Integer)2);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("\u8bfb\u53d6\u7684excel\u7684\u6570\u636e:{}", (Object)JSON.toJSONString(excelData));
        if (ObjectUtil.isEmpty(excelData)) {
            throw new ZTBusinessException("\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        int size = excelData.size();
        SupObjectiveIndicatorsImportMainPO supObjectiveIndicatorsImportMainPO = new SupObjectiveIndicatorsImportMainPO();
        Long mainId = reqBO.getMainId();
        supObjectiveIndicatorsImportMainPO.setId(mainId);
        supObjectiveIndicatorsImportMainPO.setObjectiveIndicatorsId(reqBO.getObjectiveIndicatorsId());
        supObjectiveIndicatorsImportMainPO.setFileUrl(reqBO.getFileUrl());
        supObjectiveIndicatorsImportMainPO.setFileUrl(reqBO.getFileUrl());
        supObjectiveIndicatorsImportMainPO.setImportTime(new Date());
        supObjectiveIndicatorsImportMainPO.setCreateTime(new Date());
        supObjectiveIndicatorsImportMainPO.setCreateUserId(reqBO.getUserId());
        supObjectiveIndicatorsImportMainPO.setCreateUserName(reqBO.getUserName());
        supObjectiveIndicatorsImportMainPO.setCreateOrgId(reqBO.getOrgId());
        supObjectiveIndicatorsImportMainPO.setCreateOrgName(reqBO.getOrgName());
        this.supObjectiveIndicatorsImportMainMapper.insert(supObjectiveIndicatorsImportMainPO);
        ArrayList<SupObjectiveIndicatorsImportItemPO> supObjectiveIndicatorsItemPOList = new ArrayList<SupObjectiveIndicatorsImportItemPO>();
        UmcSupplierEnableInfoPO umcSupplierEnableInfoPO = new UmcSupplierEnableInfoPO();
        umcSupplierEnableInfoPO.setTenantCode(String.valueOf(reqBO.getManageBusinessUnit()));
        umcSupplierEnableInfoPO.setSupplierStatus("HE_GE");
        List umcSupplierEnableInfoPOList = this.umcSupplierEnableInfoMapper.getList(umcSupplierEnableInfoPO);
        Map<Object, Object> supInfoMap = new HashMap();
        if (!ObjectUtil.isEmpty((Object)umcSupplierEnableInfoPOList)) {
            supInfoMap = umcSupplierEnableInfoPOList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getSupName())).collect(Collectors.toMap(UmcSupplierEnableInfoPO::getSupName, UmcSupplierEnableInfoPO::getSupId, (existing, replacement) -> existing));
        }
        ScoringIndicatorsPO scoringIndicatorsPO = new ScoringIndicatorsPO();
        scoringIndicatorsPO.setIndicatorsCategory(Integer.valueOf(2));
        scoringIndicatorsPO.setBusinessCompanyId(reqBO.getManageBusinessUnit());
        List scoringIndicatorsPOList = this.scoringIndicatorsMapper.selectListForObjectiveIndicators(scoringIndicatorsPO);
        Map<Object, Object> indicatorsInfoMap = new HashMap();
        if (!ObjectUtil.isEmpty((Object)scoringIndicatorsPOList)) {
            indicatorsInfoMap = scoringIndicatorsPOList.stream().filter(o -> !ObjectUtil.isEmpty((Object)o.getIndicatorsName()) && !ObjectUtil.isEmpty((Object)o.getRatingIndexName()) && !ObjectUtil.isEmpty((Object)o.getScoringDetailName())).collect(Collectors.toMap(o -> o.getIndicatorsName() + "-" + o.getRatingIndexName() + "-" + o.getScoringDetailName(), o -> o.getIndicatorsId() + "-" + o.getRatingIndexId() + "-" + o.getScoringDetailId(), (existing, replacement) -> existing));
        }
        boolean indexNum = true;
        for (int i = 0; i < size; ++i) {
            List excelDatum = (List)excelData.get(i);
            int maxSize = excelDatum.size();
            String failReason = "";
            failReason = this.valItem(excelDatum);
            SupObjectiveIndicatorsImportItemPO tempBO = new SupObjectiveIndicatorsImportItemPO();
            if (ObjectUtil.isEmpty((Object)supInfoMap.get(excelDatum.get(3)))) {
                failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728";
            }
            String[] keySplitList = ((String)excelDatum.get(4)).split("/", 3);
            String key = keySplitList[0] + "-" + keySplitList[1] + "-" + keySplitList[2];
            Long indicatorsId = 0L;
            Long ratingIndexId = 0L;
            Long scoringDetailId = 0L;
            log.info("indicatorsInfoMap ===  {}", (Object)JSON.toJSONString(indicatorsInfoMap));
            log.info("key ===  {}", (Object)key);
            if (ObjectUtil.isEmpty((Object)indicatorsInfoMap.get(key))) {
                failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u5ba2\u89c2\u6307\u6807\u4e0d\u5339\u914d";
            } else {
                String value = (String)indicatorsInfoMap.get(key);
                String[] strList = value.split("-");
                indicatorsId = Long.parseLong(strList[0]);
                ratingIndexId = Long.parseLong(strList[1]);
                scoringDetailId = Long.parseLong(strList[2]);
            }
            Long id = Sequence.getInstance().nextId();
            tempBO.setId(id);
            log.info("supInfoMap ===  {}", (Object)JSON.toJSONString(supInfoMap));
            log.info("supkey ===  {}", excelDatum.get(3));
            tempBO.setSupplierId((Long)supInfoMap.get(excelDatum.get(3)));
            tempBO.setSupplierName((String)excelDatum.get(3));
            tempBO.setIndicatorsId(indicatorsId);
            tempBO.setIndicatorsName(keySplitList[0]);
            tempBO.setRatingIndexId(ratingIndexId);
            tempBO.setRatingIndexName(keySplitList[1]);
            tempBO.setScoringDetailId(scoringDetailId);
            tempBO.setScoringDetailName(keySplitList[2]);
            tempBO.setScoreValue((String)excelDatum.get(5));
            tempBO.setObjectiveIndicatorsId(reqBO.getObjectiveIndicatorsId());
            tempBO.setInsertType(Integer.valueOf(1));
            tempBO.setImportStatus(Integer.valueOf(ObjectUtil.isEmpty((Object)failReason) ? 0 : 1));
            tempBO.setFailReason(failReason);
            tempBO.setCreateUserId(reqBO.getUserId());
            tempBO.setCreateUserName(reqBO.getName());
            tempBO.setCreateTime(new Date());
            tempBO.setCreateOrgId(reqBO.getOrgId());
            tempBO.setCreateOrgName(reqBO.getOrgName());
            tempBO.setImportFileId(mainId);
            supObjectiveIndicatorsItemPOList.add(tempBO);
        }
        log.info("\u4fdd\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString(supObjectiveIndicatorsItemPOList));
        if (!ObjectUtil.isEmpty(supObjectiveIndicatorsItemPOList)) {
            SupObjectiveIndicatorsImportItemPO deletePO = new SupObjectiveIndicatorsImportItemPO();
            deletePO.setObjectiveIndicatorsId(reqBO.getObjectiveIndicatorsId());
            deletePO.setInsertType(Integer.valueOf(1));
            this.supObjectiveIndicatorsImportItemMapper.deleteBy(deletePO);
            this.supObjectiveIndicatorsImportItemMapper.insertBatch(supObjectiveIndicatorsItemPOList);
        }
        return rspBO;
    }

    public static File getExcelFileByUrl(String fileUrl) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FilterOutputStream stream = null;
        InputStream inputStream = null;
        File file = null;
        try {
            URL imageUrl = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            file = File.createTempFile("file", ".xlsx");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fileOutputStream);
            stream.write(outStream.toByteArray());
        }
        catch (Exception e) {
            log.error("url\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new ZTBusinessException("url\u8f6c\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                outStream.close();
            }
            catch (Exception exception) {}
        }
        return file;
    }

    private String valItem(List<String> excelDatum) {
        String value;
        BigDecimal finalValue;
        String failReason = "";
        if (ObjectUtil.isEmpty((Object)excelDatum.get(3)) || StringUtils.isEmpty((Object)excelDatum.get(3)) || excelDatum.get(3).equals("null")) {
            failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)excelDatum.get(4)) || StringUtils.isEmpty((Object)excelDatum.get(4)) || excelDatum.get(4).equals("null")) {
            failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (ObjectUtil.isEmpty((Object)excelDatum.get(5)) || StringUtils.isEmpty((Object)excelDatum.get(5)) || excelDatum.get(5).equals("null")) {
            failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u5ba2\u89c2\u6307\u6807\u5f97\u5206/\u503c\u4e0d\u80fd\u4e3a\u7a7a";
        } else if (!excelDatum.get(5).matches("^[0-9.]+%?$")) {
            failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u5ba2\u89c2\u6307\u6807\u5f97\u5206/\u503c\u8bf7\u8f93\u5165\u6574\u6570,\u5c0f\u6570\u6216\u8005\u767e\u5206\u503c";
        } else if (excelDatum.get(5).indexOf("%") != -1 && (finalValue = new BigDecimal(value = excelDatum.get(5).replaceAll("%", ""))).compareTo(new BigDecimal("100")) > 0) {
            failReason = (ObjectUtil.isEmpty((Object)failReason) ? "" : failReason + ",") + "\u767e\u5206\u6570\u5fc5\u987b\u2264100%";
        }
        return failReason;
    }
}

