/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.atom.mdm.api.MdmPersonelAtomService;
import com.tydic.dyc.atom.transaction.api.UmcMdmSavePersonFromTmpService;
import com.tydic.dyc.atom.transaction.bo.UmcMdmSavePersonFromTmpReqBO;
import com.tydic.dyc.atom.transaction.bo.UmcMdmSavePersonFromTmpRspBO;
import com.tydic.dyc.atom.transaction.bo.UmcPersonelQryListBo;
import com.tydic.dyc.atom.transaction.bo.UmcPersonelQryPosBo;
import com.tydic.dyc.authority.repository.dao.SysAuthDistributeMapper;
import com.tydic.dyc.authority.repository.dao.SysCustInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysUserTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysAuthDistributePo;
import com.tydic.dyc.authority.repository.po.SysCustInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserInfoPo;
import com.tydic.dyc.authority.repository.po.SysUserTagRelPo;
import com.tydic.dyc.umc.repository.dao.UmcCustInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcMdmPersonMapper;
import com.tydic.dyc.umc.repository.dao.UmcMdmPersonPositionsMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserRoleRelMapper;
import com.tydic.dyc.umc.repository.dao.UmcUserTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcCustInfoPo;
import com.tydic.dyc.umc.repository.po.UmcMdmPersonPO;
import com.tydic.dyc.umc.repository.po.UmcMdmPersonPositionsPO;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserInfoPo;
import com.tydic.dyc.umc.repository.po.UmcUserRoleRelPo;
import com.tydic.dyc.umc.repository.po.UmcUserTagRelPo;
import com.tydic.dyc.umc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcMdmSavePersonFromTmpService"})
public class UmcMdmSavePersonFromTmpServiceImpl
implements UmcMdmSavePersonFromTmpService {
    @Autowired
    private UmcCustInfoMapper umcCustInfoMapper;
    @Autowired
    private UmcUserInfoMapper umcUserInfoMapper;
    @Autowired
    private UmcUserRoleRelMapper umcUserRoleRelMapper;
    @Autowired
    private UmcUserTagRelMapper umcUserTagRelMapper;
    @Autowired
    private SysUserInfoMapper sysUserInfoMapper;
    @Autowired
    private SysCustInfoMapper sysCustInfoMapper;
    @Autowired
    private SysUserTagRelMapper sysUserTagRelMapper;
    @Autowired
    private SysAuthDistributeMapper sysAuthDistributeMapper;
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private MdmPersonelAtomService mdmPersonelAtomService;
    @Value(value="${mdm.initPassword:9edc79aedf29e978fde659858a2631f2cd439bc10af968232588901a51cf2945}")
    private String mdmInitPassword;
    @Value(value="${mdm.initPasswordSalt:Li4KNn6N}")
    private String mdmInitPasswordSalt;
    @Value(value="${caigoufangDefaultOrgId:632623961709236224}")
    private Long caigoufangDefaultOrgId;
    @Autowired
    private UmcMdmPersonMapper umcMdmPersonMapper;
    @Autowired
    private UmcMdmPersonPositionsMapper umcMdmPersonPositionsMapper;

    @PostMapping(value={"savePersonFromTmp"})
    public UmcMdmSavePersonFromTmpRspBO savePersonFromTmp(@RequestBody UmcMdmSavePersonFromTmpReqBO reqBO) {
        UmcMdmPersonPositionsPO umcMdmPersonPositionsPO = new UmcMdmPersonPositionsPO();
        Page page = new Page(1, 1000);
        List mdmPersonPositionsPOList = this.umcMdmPersonPositionsMapper.getListPage(umcMdmPersonPositionsPO, page);
        List personCodeList = mdmPersonPositionsPOList.stream().distinct().map(UmcMdmPersonPositionsPO::getPersonCode).collect(Collectors.toList());
        UmcMdmPersonPO mdmPersonPo = new UmcMdmPersonPO();
        mdmPersonPo.setPersonCodeList(personCodeList);
        List mdmPersonPOList = this.umcMdmPersonMapper.getList(mdmPersonPo);
        Map mdmPersonMap = mdmPersonPOList.stream().collect(Collectors.toMap(UmcMdmPersonPO::getPersonCode, Function.identity()));
        Map<String, List<UmcMdmPersonPositionsPO>> mdmPersonPositionsGroupMap = mdmPersonPositionsPOList.stream().collect(Collectors.groupingBy(UmcMdmPersonPositionsPO::getPersonCode));
        ArrayList<UmcPersonelQryListBo> umcPersoneQryListBoList = new ArrayList<UmcPersonelQryListBo>();
        for (String personCode : mdmPersonPositionsGroupMap.keySet()) {
            UmcMdmPersonPO personPo = (UmcMdmPersonPO)mdmPersonMap.get(personCode);
            UmcPersonelQryListBo umcPersonelQryListBo = this.buildPerson(personPo);
            List<UmcMdmPersonPositionsPO> personPositionsPOList = mdmPersonPositionsGroupMap.get(personCode);
            List<UmcPersonelQryPosBo> positions = this.buildPersonPositions(personPositionsPOList);
            umcPersonelQryListBo.setPositions(positions);
            umcPersoneQryListBoList.add(umcPersonelQryListBo);
        }
        for (UmcPersonelQryListBo umcPersonelQryListBo : umcPersoneQryListBoList) {
            this.validate1(umcPersonelQryListBo);
            UmcCustInfoPo umcCustInfoPo = this.saveOrUpdateCustInfo(umcPersonelQryListBo);
            this.saveOrUpdateSysCustInfo(umcCustInfoPo);
            for (UmcPersonelQryPosBo umcPersonelQryPosBo : umcPersonelQryListBo.getPositions()) {
                this.validate2(umcPersonelQryPosBo);
                UmcUserInfoPo umcUserInfoPo = this.saveOrUpdateUserInfo(umcCustInfoPo, umcPersonelQryPosBo);
                if (null == umcUserInfoPo) continue;
                UmcUserRoleRelPo umcUserRoleRelPo = this.saveOrUpdateUserRoleRel(umcUserInfoPo);
                this.saveOrUdateUserRel(umcUserInfoPo, umcUserRoleRelPo);
                this.saveOrUpdateSysUserInfo(umcUserInfoPo);
                this.saveOrUpdateSysUserRel(umcUserInfoPo, umcUserRoleRelPo);
                this.saveOrUpdateSysAuth(umcUserInfoPo, umcUserRoleRelPo);
            }
        }
        UmcMdmSavePersonFromTmpRspBO rspBO = new UmcMdmSavePersonFromTmpRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UmcPersonelQryPosBo> buildPersonPositions(List<UmcMdmPersonPositionsPO> personPositionsPOList) {
        ArrayList<UmcPersonelQryPosBo> personPositions = new ArrayList<UmcPersonelQryPosBo>(personPositionsPOList.size());
        for (UmcMdmPersonPositionsPO personPositionPO : personPositionsPOList) {
            UmcPersonelQryPosBo umcPersonelQryPosBo = new UmcPersonelQryPosBo();
            umcPersonelQryPosBo.setOrganization_code(personPositionPO.getOrganizationCode());
            umcPersonelQryPosBo.setIf_main_post(personPositionPO.getIfMainPost());
            umcPersonelQryPosBo.setPost_id(personPositionPO.getPostId());
            umcPersonelQryPosBo.setSource_system_personnel_status(personPositionPO.getSourceSystemPersonnelStatus());
            umcPersonelQryPosBo.setEffective_date(personPositionPO.getEffectiveDate());
            umcPersonelQryPosBo.setOrganization_view(personPositionPO.getOrganizationView());
            umcPersonelQryPosBo.setPost_seq(personPositionPO.getPostSeq());
            umcPersonelQryPosBo.setPost_name(personPositionPO.getPostName());
            umcPersonelQryPosBo.setPosition_id(personPositionPO.getPositionId());
            umcPersonelQryPosBo.setPosition_name(personPositionPO.getPositionName());
            personPositions.add(umcPersonelQryPosBo);
        }
        return personPositions;
    }

    private UmcPersonelQryListBo buildPerson(UmcMdmPersonPO personPo) {
        UmcPersonelQryListBo umcPersonelQryListBo = new UmcPersonelQryListBo();
        umcPersonelQryListBo.setTel1(personPo.getTel1());
        umcPersonelQryListBo.setTel2(personPo.getTel2());
        if (!StringUtils.isEmpty((Object)personPo.getGender())) {
            umcPersonelQryListBo.setGender(Integer.valueOf(personPo.getGender()));
        }
        umcPersonelQryListBo.setExpiration_date(personPo.getExpirationDate());
        umcPersonelQryListBo.setPerson_code(personPo.getPersonCode());
        umcPersonelQryListBo.setPerson_type(personPo.getPersonType());
        umcPersonelQryListBo.setBusiness_phone(personPo.getBusinessPhone());
        umcPersonelQryListBo.setE_mail(personPo.getEMail());
        umcPersonelQryListBo.setData_status(personPo.getDataStatus());
        umcPersonelQryListBo.setName(personPo.getName());
        umcPersonelQryListBo.setMain_cert_type(personPo.getMainCertType());
        umcPersonelQryListBo.setMain_cert_num(personPo.getMainCertNum());
        return umcPersonelQryListBo;
    }

    private void validate2(UmcPersonelQryPosBo umcPersonelQryPosBo) {
        String source_system_personnel_status = umcPersonelQryPosBo.getSource_system_personnel_status();
        if (StringUtils.isEmpty((Object)source_system_personnel_status)) {
            throw new ZTBusinessException("\u6e90\u7cfb\u7edf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String effectiveDate = umcPersonelQryPosBo.getEffective_date();
        if (StringUtils.isEmpty((Object)effectiveDate)) {
            throw new ZTBusinessException("\u4eba\u5458\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String organizationView = umcPersonelQryPosBo.getOrganization_view();
        if (StringUtils.isEmpty((Object)organizationView)) {
            throw new ZTBusinessException("\u96b6\u5c5e\u7ec4\u7ec7\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String organization_code = umcPersonelQryPosBo.getOrganization_code().toString();
        if (StringUtils.isEmpty((Object)organization_code)) {
            throw new ZTBusinessException("\u96b6\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String if_main_post = umcPersonelQryPosBo.getIf_main_post();
        if (StringUtils.isEmpty((Object)if_main_post)) {
            throw new ZTBusinessException("\u662f\u5426\u4e3b\u5c97\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validate1(UmcPersonelQryListBo umcPersonelQryListBo) {
        String person_code = umcPersonelQryListBo.getPerson_code();
        if (StringUtils.isEmpty((Object)person_code)) {
            throw new ZTBusinessException("\u4eba\u5458\u8d26\u53f7\u4e3b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String person_type = umcPersonelQryListBo.getPerson_type();
        if (StringUtils.isEmpty((Object)person_type)) {
            throw new ZTBusinessException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String name = umcPersonelQryListBo.getName();
        if (StringUtils.isEmpty((Object)name)) {
            throw new ZTBusinessException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String data_status = umcPersonelQryListBo.getData_status();
        if (StringUtils.isEmpty((Object)data_status)) {
            throw new ZTBusinessException("\u6570\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void saveOrUpdateSysUserInfo(UmcUserInfoPo umcUserInfoPo) {
        SysUserInfoPo sysUserInfoPo = (SysUserInfoPo)JSON.parseObject((String)JSON.toJSONString((Object)umcUserInfoPo), SysUserInfoPo.class);
        sysUserInfoPo.setUserStatus(umcUserInfoPo.getStopStatus().equals("01") ? "1" : "0");
        SysUserInfoPo checkPo = new SysUserInfoPo();
        checkPo.setCustId(sysUserInfoPo.getUserId());
        SysUserInfoPo modelBy = this.sysUserInfoMapper.getModelBy(checkPo);
        if (modelBy == null) {
            this.sysUserInfoMapper.insert(sysUserInfoPo);
        } else {
            SysUserInfoPo where = new SysUserInfoPo();
            where.setUserId(sysUserInfoPo.getUserId());
            this.sysUserInfoMapper.updateBy(sysUserInfoPo, where);
        }
    }

    @NotNull
    private UmcUserRoleRelPo saveOrUpdateUserRoleRel(UmcUserInfoPo umcUserInfoPo) {
        UmcUserRoleRelPo umcUserRoleRelPo = new UmcUserRoleRelPo();
        umcUserRoleRelPo.setUserId(umcUserInfoPo.getUserId());
        umcUserRoleRelPo.setRoleId(this.caigoufangDefaultOrgId);
        UmcUserRoleRelPo userRoleRelMapperModelBy = this.umcUserRoleRelMapper.getModelBy(umcUserRoleRelPo);
        long relId = Sequence.getInstance().nextId();
        umcUserRoleRelPo.setUpdateTime(new Date());
        if (userRoleRelMapperModelBy == null) {
            umcUserRoleRelPo.setRelId(Long.valueOf(relId));
            umcUserRoleRelPo.setCreateTime(new Date());
            umcUserRoleRelPo.setTenantId(Long.valueOf(10000L));
            umcUserRoleRelPo.setDelFlag("0");
            umcUserRoleRelPo.setTagId("1");
            umcUserRoleRelPo.setRoleName("\u91c7\u8d2d\u65b9\u9ed8\u8ba4\u89d2\u8272");
            umcUserRoleRelPo.setRoleId(this.caigoufangDefaultOrgId);
            this.umcUserRoleRelMapper.insert(umcUserRoleRelPo);
        }
        return umcUserRoleRelPo;
    }

    private void saveOrUpdateSysAuth(UmcUserInfoPo umcUserInfoPo, UmcUserRoleRelPo umcUserRoleRelPo) {
        SysAuthDistributePo sysAuthDistributePo = new SysAuthDistributePo();
        sysAuthDistributePo.setUserId(umcUserInfoPo.getUserId());
        sysAuthDistributePo.setRoleId(this.caigoufangDefaultOrgId);
        SysAuthDistributePo modelBy1 = this.sysAuthDistributeMapper.getModelBy(sysAuthDistributePo);
        if (modelBy1 == null) {
            sysAuthDistributePo.setRoleId(this.caigoufangDefaultOrgId);
            sysAuthDistributePo.setAuthId(Long.valueOf(Sequence.getInstance().nextId()));
            sysAuthDistributePo.setCreateTime(new Date());
            sysAuthDistributePo.setDisAgFlag(Integer.valueOf(1));
            sysAuthDistributePo.setDisFlag(Integer.valueOf(1));
            sysAuthDistributePo.setManageLevel(Integer.valueOf(100));
            this.sysAuthDistributeMapper.insert(sysAuthDistributePo);
        }
    }

    private void saveOrUpdateSysUserRel(UmcUserInfoPo umcUserInfoPo, UmcUserRoleRelPo umcUserRoleRelPo) {
        SysUserTagRelPo sysUserTagRelPo = new SysUserTagRelPo();
        sysUserTagRelPo.setUserId(umcUserInfoPo.getUserId());
        sysUserTagRelPo.setTagId(Long.valueOf(1L));
        SysUserTagRelPo sysUserTagRelMapperModelBy = this.sysUserTagRelMapper.getModelBy(sysUserTagRelPo);
        if (sysUserTagRelMapperModelBy == null) {
            sysUserTagRelPo.setRelId(Long.valueOf(IdUtil.nextId()));
            sysUserTagRelPo.setCreateTime(new Date());
            sysUserTagRelPo.setIsDefalt("1");
            sysUserTagRelPo.setTagId(Long.valueOf(1L));
            this.sysUserTagRelMapper.insert(sysUserTagRelPo);
        }
    }

    private void saveOrUdateUserRel(UmcUserInfoPo umcUserInfoPo, UmcUserRoleRelPo umcUserRoleRelPo) {
        UmcUserTagRelPo umcUserTagRelPo = new UmcUserTagRelPo();
        umcUserTagRelPo.setUserId(umcUserInfoPo.getUserId());
        umcUserTagRelPo.setTagId("1");
        UmcUserTagRelPo userTagRelMapperModelBy = this.umcUserTagRelMapper.getModelBy(umcUserTagRelPo);
        if (userTagRelMapperModelBy == null) {
            umcUserTagRelPo.setRelId(Long.valueOf(IdUtil.nextId()));
            umcUserTagRelPo.setCreateTime(new Date());
            umcUserTagRelPo.setIsDefalt("1");
            umcUserTagRelPo.setTagId("1");
            umcUserTagRelPo.setTenantId(Long.valueOf(10000L));
            this.umcUserTagRelMapper.insert(umcUserTagRelPo);
        }
    }

    private UmcUserInfoPo saveOrUpdateUserInfo(UmcCustInfoPo umcCustInfoPo, UmcPersonelQryPosBo umcPersonelQryPosBo) {
        UmcUserInfoPo checkUserInfo = new UmcUserInfoPo();
        checkUserInfo.setCustId(umcCustInfoPo.getCustId());
        checkUserInfo.setExtField3(umcPersonelQryPosBo.getOrganization_code());
        checkUserInfo = this.umcUserInfoMapper.getModelBy(checkUserInfo);
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        umcOrgInfoPo.setExtField3(String.valueOf(umcPersonelQryPosBo.getOrganization_code()));
        UmcOrgInfoPo umcOrgInfoMapperModelBy = this.umcOrgInfoMapper.getModelBy(umcOrgInfoPo);
        if (umcOrgInfoMapperModelBy == null) {
            return null;
        }
        UmcUserInfoPo umcUserInfoPo = new UmcUserInfoPo();
        umcUserInfoPo.setCustId(umcCustInfoPo.getCustId());
        umcUserInfoPo.setExtField3(umcPersonelQryPosBo.getOrganization_code());
        if ("P".equals(umcPersonelQryPosBo.getIf_main_post())) {
            umcUserInfoPo.setIsMain("1");
            umcUserInfoPo.setMainCustId(umcCustInfoPo.getCustId());
        } else {
            umcUserInfoPo.setIsMain("0");
            umcUserInfoPo.setMainCustId(umcCustInfoPo.getCustId());
        }
        umcUserInfoPo.setTenantId(Long.valueOf(10000L));
        umcUserInfoPo.setCompanyId(umcOrgInfoMapperModelBy.getCompanyId());
        umcUserInfoPo.setOrgId(umcOrgInfoMapperModelBy.getOrgId());
        umcUserInfoPo.setOrgTreePath(umcOrgInfoMapperModelBy.getOrgTreePath());
        umcUserInfoPo.setUserType("4");
        umcUserInfoPo.setAuthorityType("auth:default:manage");
        if ("A".equals(umcPersonelQryPosBo.getSource_system_personnel_status())) {
            umcUserInfoPo.setStopStatus("01");
        } else {
            umcUserInfoPo.setStopStatus("00");
        }
        umcUserInfoPo.setDelFlag("0");
        umcUserInfoPo.setExtField3(umcPersonelQryPosBo.getPost_id());
        umcUserInfoPo.setExtField4(umcPersonelQryPosBo.getPost_name());
        umcUserInfoPo.setExtField5(umcPersonelQryPosBo.getPosition_id());
        umcUserInfoPo.setExtField6(umcPersonelQryPosBo.getSource_system_personnel_status());
        if (checkUserInfo == null) {
            long user_Id = Sequence.getInstance().nextId();
            umcUserInfoPo.setUserId(Long.valueOf(user_Id));
            umcUserInfoPo.setTenantId(Long.valueOf(10000L));
            umcUserInfoPo.setCreateTime(new Date());
            this.umcUserInfoMapper.insert(umcUserInfoPo);
        } else {
            umcUserInfoPo.setUpdateTime(new Date());
            UmcUserInfoPo where = new UmcUserInfoPo();
            where.setUserId(checkUserInfo.getUserId());
            this.umcUserInfoMapper.updateBy(umcUserInfoPo, where);
        }
        return umcUserInfoPo;
    }

    private UmcCustInfoPo saveOrUpdateCustInfo(UmcPersonelQryListBo umcPersonelQryListBo) {
        UmcCustInfoPo checkPo = new UmcCustInfoPo();
        checkPo.setExtCustId(umcPersonelQryListBo.getPerson_code());
        UmcCustInfoPo modelBy = this.umcCustInfoMapper.getModelBy(checkPo);
        UmcCustInfoPo umcCustInfoPo = new UmcCustInfoPo();
        umcCustInfoPo.setExtCustId(umcPersonelQryListBo.getPerson_code());
        umcCustInfoPo.setWorkNo(umcPersonelQryListBo.getPerson_code());
        umcCustInfoPo.setDelFlag("0");
        umcCustInfoPo.setCustName(umcPersonelQryListBo.getName());
        umcCustInfoPo.setRegAccount(umcPersonelQryListBo.getPerson_code());
        umcCustInfoPo.setPasswd(this.mdmInitPassword);
        umcCustInfoPo.setIsPasswdValid("1");
        umcCustInfoPo.setCustSurname(umcPersonelQryListBo.getName().substring(0, 1));
        umcCustInfoPo.setCustNickname(umcPersonelQryListBo.getName());
        umcCustInfoPo.setOfficePhone(!StringUtils.isEmpty((Object)umcPersonelQryListBo.getTel1()) ? umcPersonelQryListBo.getTel1() : umcPersonelQryListBo.getTel2());
        umcCustInfoPo.setRegMobile(umcPersonelQryListBo.getBusiness_phone());
        umcCustInfoPo.setRegEmail(umcPersonelQryListBo.getE_mail());
        umcCustInfoPo.setSex(umcPersonelQryListBo.getGender());
        if ("A".equals(umcPersonelQryListBo.getData_status())) {
            umcCustInfoPo.setStopStatus("01");
            umcCustInfoPo.setCustStatus("1");
        } else {
            umcCustInfoPo.setStopStatus("00");
            umcCustInfoPo.setCustStatus("0");
        }
        umcCustInfoPo.setCustAffiliation("01");
        umcCustInfoPo.setCustType("4");
        umcCustInfoPo.setCustClassify("2");
        umcCustInfoPo.setIsOnline("1");
        umcCustInfoPo.setCertType(Integer.valueOf(umcPersonelQryListBo.getMain_cert_type() != null ? Integer.parseInt(umcPersonelQryListBo.getMain_cert_type()) : 0));
        umcCustInfoPo.setCertNo(umcPersonelQryListBo.getMain_cert_num());
        umcCustInfoPo.setIsBlacklist("0");
        umcCustInfoPo.setUpdateTime(new Date());
        if (modelBy == null) {
            umcCustInfoPo.setCustId(Long.valueOf(IdUtil.nextId()));
            this.umcCustInfoMapper.insert(umcCustInfoPo);
        } else {
            umcCustInfoPo.setCustId(modelBy.getCustId());
            this.umcCustInfoMapper.updateById(umcCustInfoPo);
        }
        return umcCustInfoPo;
    }

    private void saveOrUpdateSysCustInfo(UmcCustInfoPo umcCustInfoPo) {
        SysCustInfoPo sysCustInfoPo = new SysCustInfoPo();
        sysCustInfoPo.setCustId(umcCustInfoPo.getCustId());
        sysCustInfoPo.setLoginName(umcCustInfoPo.getRegAccount());
        sysCustInfoPo.setTenantId(Long.valueOf(10000L));
        sysCustInfoPo.setCustPassword(this.mdmInitPassword);
        sysCustInfoPo.setPasswordSalt(this.mdmInitPasswordSalt);
        sysCustInfoPo.setCustName(umcCustInfoPo.getCustName());
        sysCustInfoPo.setCellPhone(umcCustInfoPo.getRegMobile());
        sysCustInfoPo.setCustEmail(umcCustInfoPo.getRegEmail());
        sysCustInfoPo.setCustStatus(umcCustInfoPo.getCustStatus());
        sysCustInfoPo.setCustSource("0");
        sysCustInfoPo.setPasswordEffDate(new Date());
        SysCustInfoPo where = new SysCustInfoPo();
        where.setCustId(umcCustInfoPo.getCustId());
        where.setDelFlag("0");
        SysCustInfoPo modelBy = this.sysCustInfoMapper.getModelBy(where);
        if (modelBy == null) {
            sysCustInfoPo.setCreateTime(new Date());
            this.sysCustInfoMapper.insert(sysCustInfoPo);
        } else {
            sysCustInfoPo.setUpdateTime(new Date());
            this.sysCustInfoMapper.updateBy(sysCustInfoPo, where);
        }
    }
}

