/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.atom.mdm.api.MdmOrganizationAtomService;
import com.tydic.dyc.atom.mdm.bo.MdmOrganizationAtomReqBo;
import com.tydic.dyc.atom.mdm.bo.MdmOrganizationAtomRspBo;
import com.tydic.dyc.atom.transaction.api.UmcOrgQryListService;
import com.tydic.dyc.atom.transaction.bo.UmcOrgQryListBo;
import com.tydic.dyc.atom.transaction.bo.UmcOrgQryListReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcOrgQryListRspBo;
import com.tydic.dyc.authority.repository.dao.SysOrgInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysOrgTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysOrgInfoPo;
import com.tydic.dyc.authority.repository.po.SysOrgTagRelPo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgInfoMapper;
import com.tydic.dyc.umc.repository.dao.UmcOrgTagRelMapper;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgInfoPo;
import com.tydic.dyc.umc.repository.po.UmcOrgTagRelPo;
import com.tydic.dyc.umc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcOrgQryListService"})
public class UmcOrgQryListServiceImpl
implements UmcOrgQryListService {
    private static final Logger log = LoggerFactory.getLogger(UmcOrgQryListServiceImpl.class);
    @Autowired
    private UmcOrgInfoMapper umcOrgInfoMapper;
    @Autowired
    private UmcEnterpriseInfoMapper umcEnterpriseInfoMapper;
    @Autowired
    private UmcOrgTagRelMapper umcOrgTagRelMapper;
    @Autowired
    private SysOrgInfoMapper sysOrgInfoMapper;
    @Autowired
    private SysOrgTagRelMapper sysOrgTagRelMapper;
    @Autowired
    private MdmOrganizationAtomService mdmOrganizationAtomService;
    private static final int maxDepth = 10;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"saveMdmOrgList"})
    public UmcOrgQryListRspBo saveMdmOrgList(@RequestBody UmcOrgQryListReqBo reqBO) {
        MdmOrganizationAtomRspBo response = this.mdmOrganizationAtomService.getMdmOrganizationAtom((MdmOrganizationAtomReqBo)JUtil.js((Object)reqBO, MdmOrganizationAtomReqBo.class));
        JSONObject data = response.getData();
        JSONArray dataInfoArray = data.getJSONObject("datainfos").getJSONArray("datainfo");
        List umcOrgQryListBos = dataInfoArray.toJavaList(UmcOrgQryListBo.class);
        log.info("\u8fd4\u56dedata\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)umcOrgQryListBos));
        ArrayList<String> mdmOrgInfoRedisKeys = new ArrayList<String>();
        try {
            for (UmcOrgQryListBo umcOrgQryListBo : umcOrgQryListBos) {
                this.validate(umcOrgQryListBo);
                if (!StringUtils.isEmpty((Object)umcOrgQryListBo.getBuss_parent_id())) {
                    UmcOrgInfoPo parentOrgInfoPo = null;
                    Object object = this.cacheClient.get("mdm_org_" + umcOrgQryListBo.getBuss_parent_id());
                    if (object != null) {
                        String jsonString = JSONObject.toJSONString((Object)object);
                        parentOrgInfoPo = (UmcOrgInfoPo)JSONObject.parseObject((String)jsonString, UmcOrgInfoPo.class);
                    } else {
                        UmcOrgInfoPo checkPo = new UmcOrgInfoPo();
                        checkPo.setExtField3(umcOrgQryListBo.getBuss_parent_id());
                        parentOrgInfoPo = this.umcOrgInfoMapper.getModelBy(checkPo);
                    }
                    if (null != parentOrgInfoPo) {
                        UmcOrgInfoPo buildUmcOrgInfo = this.buildUmcOrgInfo(parentOrgInfoPo, umcOrgQryListBo);
                        SysOrgInfoPo buildSysOrgInfo = this.buildSysOrgInfo(buildUmcOrgInfo);
                        UmcEnterpriseInfoPo buildEnterpriseInfo = this.buildEnterpriseInfo(buildUmcOrgInfo, umcOrgQryListBo);
                        this.saveOrgInfo(buildUmcOrgInfo, buildSysOrgInfo, buildEnterpriseInfo, mdmOrgInfoRedisKeys);
                        continue;
                    }
                    UmcOrgInfoPo insertParentOrgInfo = this.reverseInsert(umcOrgQryListBo.getBuss_parent_id(), 1, 10, mdmOrgInfoRedisKeys);
                    UmcOrgInfoPo buildUmcOrgInfo = this.buildUmcOrgInfo(insertParentOrgInfo, umcOrgQryListBo);
                    SysOrgInfoPo buildSysOrgInfo = this.buildSysOrgInfo(buildUmcOrgInfo);
                    UmcEnterpriseInfoPo buildEnterpriseInfo = this.buildEnterpriseInfo(buildUmcOrgInfo, umcOrgQryListBo);
                    this.saveOrgInfo(buildUmcOrgInfo, buildSysOrgInfo, buildEnterpriseInfo, mdmOrgInfoRedisKeys);
                    continue;
                }
                UmcOrgInfoPo genOrgInfoPo = this.umcOrgInfoMapper.getModelById(Long.valueOf(1L));
                UmcOrgInfoPo buildUmcOrgInfo = this.buildUmcOrgInfo(genOrgInfoPo, umcOrgQryListBo);
                SysOrgInfoPo buildSysOrgInfo = this.buildSysOrgInfo(buildUmcOrgInfo);
                UmcEnterpriseInfoPo buildEnterpriseInfo = this.buildEnterpriseInfo(buildUmcOrgInfo, umcOrgQryListBo);
                this.saveOrgInfo(buildUmcOrgInfo, buildSysOrgInfo, buildEnterpriseInfo, mdmOrgInfoRedisKeys);
            }
        }
        catch (Exception e) {
            for (String mdmOrgInfoRedisKey : mdmOrgInfoRedisKeys) {
                this.cacheClient.delete(mdmOrgInfoRedisKey);
            }
            throw new ZTBusinessException("\u5168\u91cf\u62c9\u53d6\u7ec4\u7ec7\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
        return this.getRspBo();
    }

    private UmcEnterpriseInfoPo buildEnterpriseInfo(UmcOrgInfoPo umcOrgInfoPo, UmcOrgQryListBo umcOrgQryBo) {
        UmcEnterpriseInfoPo umcEnterpriseInfoPo = new UmcEnterpriseInfoPo();
        umcEnterpriseInfoPo.setOrgId(umcOrgInfoPo.getOrgId());
        umcEnterpriseInfoPo.setDelFlag("0");
        umcEnterpriseInfoPo.setOrgName(umcOrgQryBo.getFull_name());
        umcEnterpriseInfoPo.setOrgEnName(umcOrgQryBo.getEng_name());
        umcEnterpriseInfoPo.setOrgShortName(umcOrgQryBo.getShort_name());
        umcEnterpriseInfoPo.setEffDate(umcOrgQryBo.getEff_date());
        umcEnterpriseInfoPo.setUpdateTime(new Date());
        umcEnterpriseInfoPo.setOrgClass("4");
        umcEnterpriseInfoPo.setIsMerchant("0");
        umcEnterpriseInfoPo.setIsShopOrg("1");
        umcEnterpriseInfoPo.setTenantId(Long.valueOf(10000L));
        umcEnterpriseInfoPo.setCreateTime(new Date());
        return umcEnterpriseInfoPo;
    }

    private SysOrgInfoPo buildSysOrgInfo(UmcOrgInfoPo umcOrgInfoPo) {
        SysOrgInfoPo sysOrgInfoPo = (SysOrgInfoPo)JUtil.js((Object)umcOrgInfoPo, SysOrgInfoPo.class);
        return sysOrgInfoPo;
    }

    private UmcOrgInfoPo buildUmcOrgInfo(UmcOrgInfoPo parentOrgInfoPo, UmcOrgQryListBo umcOrgQryBo) {
        UmcOrgInfoPo umcOrgInfoPo = new UmcOrgInfoPo();
        UmcOrgInfoPo checkOrgInfoPo = new UmcOrgInfoPo();
        checkOrgInfoPo.setExtField3(umcOrgQryBo.getBuss_sys_id());
        checkOrgInfoPo = this.umcOrgInfoMapper.getModelBy(checkOrgInfoPo);
        if (null != checkOrgInfoPo) {
            umcOrgInfoPo.setOrgId(checkOrgInfoPo.getOrgId());
        } else {
            umcOrgInfoPo.setOrgId(Long.valueOf(IdUtil.nextId()));
        }
        umcOrgInfoPo.setExtOrgCode(umcOrgQryBo.getOrg_code());
        umcOrgInfoPo.setExtField3(umcOrgQryBo.getBuss_sys_id());
        umcOrgInfoPo.setExtField4(umcOrgQryBo.getBuss_parent_id());
        umcOrgInfoPo.setOrgName(umcOrgQryBo.getFull_name());
        umcOrgInfoPo.setOrgAlias(umcOrgQryBo.getShort_name());
        umcOrgInfoPo.setExtField1(umcOrgQryBo.getCmp_level());
        umcOrgInfoPo.setExtField2(umcOrgQryBo.getDept_level());
        if (umcOrgQryBo.getHr_org_status().equals("A")) {
            umcOrgInfoPo.setOrgStatus("1");
        } else {
            umcOrgInfoPo.setOrgStatus("0");
        }
        if (umcOrgQryBo.getOrg_type().equals("10") || umcOrgQryBo.getOrg_type().equals("11")) {
            umcOrgInfoPo.setOrgType(Long.valueOf(2L));
        } else if (umcOrgQryBo.getOrg_type().equals("20") || umcOrgQryBo.getOrg_type().equals("21")) {
            umcOrgInfoPo.setOrgType(Long.valueOf(3L));
        }
        umcOrgInfoPo.setUpdateTime(new Date());
        umcOrgInfoPo.setOrgCode(umcOrgInfoPo.getOrgId().toString());
        umcOrgInfoPo.setDelFlag("0");
        umcOrgInfoPo.setTenantId(Long.valueOf(10000L));
        umcOrgInfoPo.setIsVirtual("0");
        umcOrgInfoPo.setCreateTime(new Date());
        umcOrgInfoPo.setOrgTreePath(parentOrgInfoPo.getOrgTreePath() + umcOrgInfoPo.getOrgId() + "-");
        umcOrgInfoPo.setParentId(parentOrgInfoPo.getOrgId());
        umcOrgInfoPo.setDeep(Integer.valueOf(umcOrgInfoPo.getOrgTreePath().split("-").length));
        umcOrgInfoPo.setCompanyId(umcOrgInfoPo.getOrgType().equals(2L) ? umcOrgInfoPo.getOrgId() : parentOrgInfoPo.getCompanyId());
        return umcOrgInfoPo;
    }

    private void saveOrgInfo(UmcOrgInfoPo umcOrgInfoPo, SysOrgInfoPo sysOrgInfoPo, UmcEnterpriseInfoPo umcEnterpriseInfoPo, List<String> mdmOrgInfoRedisKeys) {
        this.saveOrUpdateOrgInfo(umcOrgInfoPo);
        this.saveOrUpdateSysOrgInfo(sysOrgInfoPo);
        this.saveOrUpdateOrgEnterpriseInfo(umcEnterpriseInfoPo);
        this.cacheClient.set("mdm_org_" + umcOrgInfoPo.getExtField3(), (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)umcOrgInfoPo)));
        mdmOrgInfoRedisKeys.add("mdm_org_" + umcOrgInfoPo.getExtField3());
    }

    private void validate(UmcOrgQryListBo umcOrgQryListBo) {
        String fullName = umcOrgQryListBo.getFull_name();
        if (StringUtils.isEmpty((Object)fullName)) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a" + umcOrgQryListBo.getBuss_sys_id());
        }
        String org_type = umcOrgQryListBo.getOrg_type();
        if (StringUtils.isEmpty((Object)org_type)) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String hr_org_status = umcOrgQryListBo.getHr_org_status();
        if (StringUtils.isEmpty((Object)hr_org_status)) {
            throw new ZTBusinessException("\u4eba\u4e8b\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcOrgQryListRspBo getRspBo() {
        UmcOrgQryListRspBo rspBo = new UmcOrgQryListRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void saveSysOrgTagRel(SysOrgInfoPo sysOrgInfoPo) {
        SysOrgTagRelPo sysOrgTagRelPo = new SysOrgTagRelPo();
        sysOrgTagRelPo.setOrgId(sysOrgInfoPo.getOrgId());
        sysOrgTagRelPo.setDelFlag("0");
        sysOrgTagRelPo.setTagId(Long.valueOf(1L));
        sysOrgTagRelPo.setUpdateTime(new Date());
        sysOrgTagRelPo.setTagStatus("1");
        sysOrgTagRelPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
        sysOrgTagRelPo.setCreateTime(new Date());
        this.sysOrgTagRelMapper.insert(sysOrgTagRelPo);
    }

    private void saveUmcOrgTagRel(UmcOrgInfoPo umcOrgInfoPo) {
        UmcOrgTagRelPo umcOrgTagRelPo = new UmcOrgTagRelPo();
        umcOrgTagRelPo.setOrgId(umcOrgInfoPo.getOrgId());
        umcOrgTagRelPo.setDelFlag("0");
        umcOrgTagRelPo.setTagId("1");
        umcOrgTagRelPo.setUpdateTime(new Date());
        umcOrgTagRelPo.setEffTime(umcOrgInfoPo.getEffTime());
        umcOrgTagRelPo.setTagStatus("1");
        umcOrgTagRelPo.setTenantId(Long.valueOf(10000L));
        umcOrgTagRelPo.setRelId(Long.valueOf(Sequence.getInstance().nextId()));
        umcOrgTagRelPo.setCreateTime(new Date());
        this.umcOrgTagRelMapper.insert(umcOrgTagRelPo);
    }

    private void saveOrUpdateOrgEnterpriseInfo(UmcEnterpriseInfoPo enterpriseInfoPo) {
        UmcEnterpriseInfoPo checkPo = new UmcEnterpriseInfoPo();
        checkPo.setOrgId(enterpriseInfoPo.getOrgId());
        checkPo = this.umcEnterpriseInfoMapper.getModelBy(checkPo);
        if (checkPo != null) {
            this.umcEnterpriseInfoMapper.updateById(enterpriseInfoPo);
        } else {
            this.umcEnterpriseInfoMapper.insert(enterpriseInfoPo);
        }
    }

    private void saveOrUpdateSysOrgInfo(SysOrgInfoPo sysOrgInfoPo) {
        SysOrgInfoPo checkPo = new SysOrgInfoPo();
        checkPo.setOrgId(sysOrgInfoPo.getOrgId());
        checkPo = this.sysOrgInfoMapper.getModelBy(checkPo);
        if (checkPo == null) {
            this.sysOrgInfoMapper.insert(sysOrgInfoPo);
            this.saveSysOrgTagRel(sysOrgInfoPo);
        } else {
            this.sysOrgInfoMapper.updateById(sysOrgInfoPo);
        }
    }

    private void saveOrUpdateOrgInfo(UmcOrgInfoPo umcOrgInfoPo) {
        UmcOrgInfoPo checkPo = new UmcOrgInfoPo();
        checkPo.setOrgId(umcOrgInfoPo.getOrgId());
        checkPo = this.umcOrgInfoMapper.getModelBy(checkPo);
        if (checkPo == null) {
            this.umcOrgInfoMapper.insert(umcOrgInfoPo);
            this.saveUmcOrgTagRel(umcOrgInfoPo);
        } else {
            this.umcOrgInfoMapper.updateById(umcOrgInfoPo);
        }
    }

    private UmcOrgInfoPo reverseInsert(String extOrgId, int depth, int maxDepth, List<String> mdmOrgInfoRedisKeys) {
        if (depth > maxDepth) {
            throw new ZTBusinessException("MDM\u4e3b\u6570\u636e\u673a\u6784\u67e5\u8be2\u6570\u636e\u6df1\u5ea6\u8d85\u8fc7\u6700\u5927\u6df1\u5ea6");
        }
        UmcOrgQryListReqBo reqBo = new UmcOrgQryListReqBo();
        reqBo.setBuss_sys_id(extOrgId);
        reqBo.setCountperpage(Integer.valueOf(200));
        reqBo.setCurrentpage(Integer.valueOf(1));
        MdmOrganizationAtomReqBo atomReqBo = (MdmOrganizationAtomReqBo)JUtil.js((Object)reqBo, MdmOrganizationAtomReqBo.class);
        MdmOrganizationAtomRspBo response = this.mdmOrganizationAtomService.getMdmOrganizationAtom(atomReqBo);
        JSONObject data = response.getData();
        JSONArray dataInfoArray = data.getJSONObject("datainfos").getJSONArray("datainfo");
        log.info("\u8fd4\u56dedata\u6570\u636e\uff1a{}", (Object)data);
        UmcOrgQryListBo umcOrgQryExPar = (UmcOrgQryListBo)dataInfoArray.toJavaList(UmcOrgQryListBo.class).get(0);
        if (umcOrgQryExPar == null) {
            throw new ZTBusinessException("MDM\u4e3b\u6570\u636e\u673a\u6784\u67e5\u8be2\u65e0\u6570\u636e");
        }
        if (StringUtils.isEmpty((Object)umcOrgQryExPar.getBuss_parent_id())) {
            UmcOrgInfoPo genOrgInfoPo = this.umcOrgInfoMapper.getModelById(Long.valueOf(1L));
            UmcOrgInfoPo buildUmcOrgInfo = this.buildUmcOrgInfo(genOrgInfoPo, umcOrgQryExPar);
            SysOrgInfoPo buildSysOrgInfo = this.buildSysOrgInfo(buildUmcOrgInfo);
            UmcEnterpriseInfoPo buildEnterpriseInfo = this.buildEnterpriseInfo(buildUmcOrgInfo, umcOrgQryExPar);
            this.saveOrgInfo(buildUmcOrgInfo, buildSysOrgInfo, buildEnterpriseInfo, mdmOrgInfoRedisKeys);
            return buildUmcOrgInfo;
        }
        UmcOrgInfoPo modelByPar = null;
        Object object = this.cacheClient.get("mdm_org_" + umcOrgQryExPar.getBuss_parent_id());
        if (object != null) {
            String jsonString = JSONArray.toJSONString((Object)object);
            modelByPar = (UmcOrgInfoPo)JSONObject.parseObject((String)jsonString, UmcOrgInfoPo.class);
        } else {
            UmcOrgInfoPo checkPo = new UmcOrgInfoPo();
            checkPo.setExtField3(umcOrgQryExPar.getBuss_parent_id());
            modelByPar = this.umcOrgInfoMapper.getModelBy(checkPo);
        }
        if (modelByPar == null) {
            UmcOrgInfoPo parentOrgInfoPo = this.reverseInsert(umcOrgQryExPar.getBuss_parent_id(), depth + 1, maxDepth, mdmOrgInfoRedisKeys);
            UmcOrgInfoPo buildUmcOrgInfo = this.buildUmcOrgInfo(parentOrgInfoPo, umcOrgQryExPar);
            SysOrgInfoPo buildSysOrgInfo = this.buildSysOrgInfo(buildUmcOrgInfo);
            UmcEnterpriseInfoPo buildEnterpriseInfo = this.buildEnterpriseInfo(buildUmcOrgInfo, umcOrgQryExPar);
            this.saveOrgInfo(buildUmcOrgInfo, buildSysOrgInfo, buildEnterpriseInfo, mdmOrgInfoRedisKeys);
            return buildUmcOrgInfo;
        }
        UmcOrgInfoPo buildUmcOrgInfo = this.buildUmcOrgInfo(modelByPar, umcOrgQryExPar);
        SysOrgInfoPo buildSysOrgInfo = this.buildSysOrgInfo(buildUmcOrgInfo);
        UmcEnterpriseInfoPo buildEnterpriseInfo = this.buildEnterpriseInfo(buildUmcOrgInfo, umcOrgQryExPar);
        this.saveOrgInfo(buildUmcOrgInfo, buildSysOrgInfo, buildEnterpriseInfo, mdmOrgInfoRedisKeys);
        return buildUmcOrgInfo;
    }
}

