/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.atom.common.api.DycUocOrderAuditOrderCreateFunction;
import com.tydic.dyc.atom.common.bo.DycUocOrderAuditOrderCreateFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUocOrderAuditOrderCreateFuncRspBO;
import com.tydic.dyc.atom.common.member.task.api.DycUmcAuditProcessCreateFunction;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionReqBo;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionRspBo;
import com.tydic.dyc.atom.transaction.api.UmcSupCorrectionAddService;
import com.tydic.dyc.atom.transaction.bo.UmcSupCorrectionAddReqBO;
import com.tydic.dyc.atom.transaction.bo.UmcSupCorrectionAddRspBO;
import com.tydic.dyc.atom.transaction.bo.UmcSupCorrectionDataSourceBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcConstant;
import com.tydic.dyc.umc.repository.dao.SupCorrectionDataSourceMapper;
import com.tydic.dyc.umc.repository.dao.SupCorrectionMapper;
import com.tydic.dyc.umc.repository.po.SupCorrectionDataSourcePO;
import com.tydic.dyc.umc.repository.po.SupCorrectionPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcSupCorrectionAddService"})
public class UmcSupCorrectionAddServiceImpl
implements UmcSupCorrectionAddService {
    @Autowired
    private SupCorrectionMapper supCorrectionMapper;
    @Autowired
    private SupCorrectionDataSourceMapper supCorrectionDataSourceMapper;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;
    @Autowired
    private DycUocOrderAuditOrderCreateFunction dycUocOrderAuditOrderCreateFunction;
    @Value(value="${correction_order_approval:correction_order_approval}")
    private String correctionOrderApproval;
    @Value(value="${SYS_CODE:DYC}")
    private String sys_code;
    @Autowired
    private DycUmcAuditProcessCreateFunction dycUmcAuditProcessCreateFunction;

    @PostMapping(value={"addSupCorrection"})
    public UmcSupCorrectionAddRspBO addSupCorrection(@RequestBody UmcSupCorrectionAddReqBO reqBO) {
        this.val(reqBO);
        UmcSupCorrectionAddRspBO rspBO = new UmcSupCorrectionAddRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Long correctionId = 0L;
        if (ObjectUtil.isEmpty((Object)reqBO.getCorrectionId())) {
            SupCorrectionPO savePO = new SupCorrectionPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)savePO);
            correctionId = Sequence.getInstance().nextId();
            savePO.setCorrectionId(correctionId);
            savePO.setCorrectionNo(this.getCorrectionNo());
            savePO.setCreateUserId(reqBO.getUserId());
            savePO.setCreateUserName(reqBO.getUsername());
            savePO.setCreateOrgId(reqBO.getOrgId());
            savePO.setCreateOrgName(reqBO.getOrgName());
            savePO.setCreateDate(new Date());
            savePO.setOperationStatus(reqBO.getSubmitType().equals(0) ? "0" : "1");
            this.supCorrectionMapper.insert(savePO);
        } else {
            correctionId = reqBO.getCorrectionId();
            SupCorrectionPO updatePO = new SupCorrectionPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)updatePO);
            updatePO.setUpdateUserId(reqBO.getUserId());
            updatePO.setUpdateUserName(reqBO.getUsername());
            updatePO.setUpdateOrgId(reqBO.getOrgId());
            updatePO.setUpdateOrgName(reqBO.getOrgName());
            updatePO.setUpdateDate(new Date());
            updatePO.setOperationStatus(reqBO.getSubmitType().equals(0) ? "0" : "1");
            this.supCorrectionMapper.updateById(updatePO);
        }
        SupCorrectionDataSourcePO deletePO = new SupCorrectionDataSourcePO();
        deletePO.setCorrectionId(correctionId);
        this.supCorrectionDataSourceMapper.deleteBy(deletePO);
        if (!"3".equals(reqBO.getCorrectionType())) {
            ArrayList<SupCorrectionDataSourcePO> list = new ArrayList<SupCorrectionDataSourcePO>();
            for (UmcSupCorrectionDataSourceBO item : reqBO.getDataSourceBOList()) {
                SupCorrectionDataSourcePO po = new SupCorrectionDataSourcePO();
                BeanUtils.copyProperties((Object)po, (Object)item);
                po.setCorrectionDataSourceId(Long.valueOf(Sequence.getInstance().nextId()));
                po.setCorrectionId(correctionId);
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateUserName(reqBO.getUsername());
                po.setCreateOrgId(reqBO.getOrgId());
                po.setCreateOrgName(reqBO.getOrgName());
                po.setCreateDate(new Date());
                list.add(po);
            }
            this.supCorrectionDataSourceMapper.insertBatch(list);
        }
        if (reqBO.getSubmitType().equals(1)) {
            reqBO.setCorrectionId(correctionId);
            this.starApproval(reqBO);
        }
        return rspBO;
    }

    private String getCorrectionNo() {
        CfcEncodedSerialGetServiceReqBO cfcEncodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        cfcEncodedSerialGetServiceReqBO.setCenter("UMC");
        cfcEncodedSerialGetServiceReqBO.setEncodedRuleCode("SUP_CORRECTION_ORDER_NO");
        cfcEncodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        cfcEncodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO = this.cfcEncodedSerialGetService.getSerialSimper(cfcEncodedSerialGetServiceReqBO);
        String correctionNo = (String)cfcEncodedSerialServiceRspBO.getSerialNoList().get(0);
        return correctionNo;
    }

    private void val(UmcSupCorrectionAddReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getDataSourceBOList()) && !"3".equals(reqBO.getCorrectionType())) {
            throw new ZTBusinessException("\u88ab\u5173\u8054\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void starApproval(UmcSupCorrectionAddReqBO reqBO) {
        DycUocOrderAuditOrderCreateFuncReqBO dycUocOrderAuditOrderCreateFuncReqBO = (DycUocOrderAuditOrderCreateFuncReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), DycUocOrderAuditOrderCreateFuncReqBO.class);
        dycUocOrderAuditOrderCreateFuncReqBO.setUserName(reqBO.getUsername());
        dycUocOrderAuditOrderCreateFuncReqBO.setOrderId(reqBO.getCorrectionId());
        dycUocOrderAuditOrderCreateFuncReqBO.setAuditObjId(reqBO.getCorrectionId());
        dycUocOrderAuditOrderCreateFuncReqBO.setAuditObjType(UmcConstant.ObjBusiType.CORRECTION_AUDIT);
        dycUocOrderAuditOrderCreateFuncReqBO.setObjBusiType(UmcConstant.ObjBusiType.CORRECTION_AUDIT);
        dycUocOrderAuditOrderCreateFuncReqBO.setUserId(reqBO.getUserIdIn());
        dycUocOrderAuditOrderCreateFuncReqBO.setCenter("UMC");
        DycUocOrderAuditOrderCreateFuncRspBO funcRspBO = this.dycUocOrderAuditOrderCreateFunction.dealOrderAuditOrderCreate(dycUocOrderAuditOrderCreateFuncReqBO);
        if (!"0000".equals(funcRspBO.getRespCode())) {
            throw new BaseBusinessException("161004", "\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5931\u8d25:\u751f\u6210\u6574\u5355\u5ba1\u6279\u5931\u8d25");
        }
        this.startAuditProcess(reqBO, funcRspBO.getAuditOrderId());
    }

    private void startAuditProcess(UmcSupCorrectionAddReqBO reqBO, Long auditOrderId) {
        DycUmcAuditProcessCreateFunctionReqBo abilityReqBO = new DycUmcAuditProcessCreateFunctionReqBo();
        abilityReqBO.setOrgId(Convert.toStr((Object)reqBO.getOrgId()));
        ArrayList<String> busiList = new ArrayList<String>();
        busiList.add(reqBO.getCorrectionId().toString());
        abilityReqBO.setBusinessIdList(busiList);
        abilityReqBO.setProcDefKey(this.correctionOrderApproval);
        abilityReqBO.setSysCode(this.sys_code);
        abilityReqBO.setUserId(reqBO.getUserIdIn().toString());
        abilityReqBO.setUserName(reqBO.getUsername());
        abilityReqBO.setOrgName(reqBO.getOrgName());
        abilityReqBO.setBusinessType(String.valueOf(UmcConstant.ObjBusiType.CORRECTION_AUDIT));
        abilityReqBO.setPartitionKey(reqBO.getCorrectionId().toString());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("auditObjId", auditOrderId);
        map.put("applyId", reqBO.getCorrectionId());
        abilityReqBO.setVariables(map);
        DycUmcAuditProcessCreateFunctionRspBo abilityRspBO = this.dycUmcAuditProcessCreateFunction.createProcess(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
    }
}

