/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.DycUocOrderAuditOrderCreateFunction;
import com.tydic.dyc.atom.common.bo.DycUocOrderAuditOrderCreateFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUocOrderAuditOrderCreateFuncRspBO;
import com.tydic.dyc.atom.common.member.task.api.DycUmcAuditProcessCreateFunction;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionReqBo;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionRspBo;
import com.tydic.dyc.atom.transaction.api.UmcSupEnableConfirmService;
import com.tydic.dyc.atom.transaction.bo.UmcSupEnableConfirmServiceReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcSupEnableConfirmServiceRspBo;
import com.tydic.dyc.umc.constants.UmcConstant;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEnableInfoMapper;
import com.tydic.dyc.umc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.umc.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.umc.repository.po.UmcSupplierEnableInfoPO;
import com.tydic.dyc.umc.repository.po.UocAuditOrderPo;
import com.tydic.dyc.umc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcSupEnableConfirmService"})
public class UmcSupEnableConfirmServiceImpl
implements UmcSupEnableConfirmService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupEnableConfirmServiceImpl.class);
    @Autowired
    private UmcSupplierEnableInfoMapper umcSupplierEnableInfoMapper;
    @Autowired
    private DycUmcAuditProcessCreateFunction dycUmcAuditProcessCreateFunction;
    @Autowired
    private DycUocOrderAuditOrderCreateFunction dycUocOrderAuditOrderCreateFunction;
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Value(value="${sup_enable_order_audit_key:sup_enable_order_audit}")
    private String enableOrderAuditKey;
    @Value(value="${SYS_CODE:DYC}")
    private String sys_code;

    @PostMapping(value={"confirm"})
    public UmcSupEnableConfirmServiceRspBo confirm(@RequestBody UmcSupEnableConfirmServiceReqBo reqBo) {
        log.info("confirm reqBo:{}", (Object)reqBo);
        UmcSupEnableConfirmServiceImpl.validateParams(reqBo);
        this.updateEnableStatus(reqBo);
        this.dealOldTaskData(reqBo);
        Long auditOrderId = this.createAuditOrder(reqBo);
        this.startAuditProcess(reqBo, auditOrderId);
        return (UmcSupEnableConfirmServiceRspBo)UmcRu.success(UmcSupEnableConfirmServiceRspBo.class);
    }

    private void dealOldTaskData(UmcSupEnableConfirmServiceReqBo reqBo) {
        UocOrderProcInstPo uocOrderProcInstPo = new UocOrderProcInstPo();
        uocOrderProcInstPo.setObjId(reqBo.getEnableOrderId());
        uocOrderProcInstPo = this.uocOrderProcInstMapper.getModelBy(uocOrderProcInstPo);
        if (ObjectUtil.isNotEmpty((Object)uocOrderProcInstPo)) {
            uocOrderProcInstPo.setDelTag(Integer.valueOf(1));
            this.uocOrderProcInstMapper.updateById(uocOrderProcInstPo);
        }
        UocAuditOrderPo uocAuditOrderPo = new UocAuditOrderPo();
        uocAuditOrderPo.setOrderId(reqBo.getEnableOrderId());
        uocAuditOrderPo = this.uocAuditOrderMapper.getModelBy(uocAuditOrderPo);
        if (ObjectUtil.isNotEmpty((Object)uocAuditOrderPo)) {
            uocAuditOrderPo.setDelTag(Integer.valueOf(1));
            this.uocAuditOrderMapper.updateById(uocAuditOrderPo);
        }
    }

    private void startAuditProcess(UmcSupEnableConfirmServiceReqBo reqBo, Long auditOrderId) {
        DycUmcAuditProcessCreateFunctionReqBo abilityReqBO = new DycUmcAuditProcessCreateFunctionReqBo();
        abilityReqBO.setOrgId(Convert.toStr((Object)reqBo.getOrgId()));
        ArrayList<String> busiList = new ArrayList<String>();
        busiList.add(reqBo.getEnableOrderId().toString());
        abilityReqBO.setBusinessIdList(busiList);
        abilityReqBO.setProcDefKey(this.enableOrderAuditKey);
        abilityReqBO.setSysCode(this.sys_code);
        abilityReqBO.setUserId(reqBo.getUserIdIn().toString());
        abilityReqBO.setUserName(reqBo.getUsername());
        abilityReqBO.setOrgName(reqBo.getOrgName());
        abilityReqBO.setBusinessType(UmcConstant.ObjBusiType.ENABLE_ORDER_AUDIT.toString());
        abilityReqBO.setPartitionKey(reqBo.getEnableOrderId().toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auditObjId", auditOrderId);
        map.put("applyId", reqBo.getEnableOrderId());
        UmcSupplierEnableInfoPO umcSupplierEnableInfoPO = new UmcSupplierEnableInfoPO();
        umcSupplierEnableInfoPO.setId(reqBo.getEnableOrderId());
        UmcSupplierEnableInfoPO umcSupplierEnableInfoMapperModelBy = this.umcSupplierEnableInfoMapper.getModelBy(umcSupplierEnableInfoPO);
        map.put("presenterId", umcSupplierEnableInfoMapperModelBy.getPresenterId());
        map.put("tenantCode", umcSupplierEnableInfoMapperModelBy.getTenantCode());
        abilityReqBO.setVariables(map);
        DycUmcAuditProcessCreateFunctionRspBo abilityRspBO = this.dycUmcAuditProcessCreateFunction.createProcess(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25" + abilityRspBO.getRespDesc());
        }
    }

    private Long createAuditOrder(UmcSupEnableConfirmServiceReqBo reqBo) {
        DycUocOrderAuditOrderCreateFuncReqBO dycUocOrderAuditOrderCreateFuncReqBO = new DycUocOrderAuditOrderCreateFuncReqBO();
        dycUocOrderAuditOrderCreateFuncReqBO.setOrderId(reqBo.getEnableOrderId());
        dycUocOrderAuditOrderCreateFuncReqBO.setAuditObjId(reqBo.getEnableOrderId());
        dycUocOrderAuditOrderCreateFuncReqBO.setAuditObjType(UmcConstant.ObjBusiType.ENABLE_ORDER_AUDIT);
        dycUocOrderAuditOrderCreateFuncReqBO.setObjBusiType(UmcConstant.ObjBusiType.ENABLE_ORDER_AUDIT);
        dycUocOrderAuditOrderCreateFuncReqBO.setUserId(reqBo.getUserIdIn());
        dycUocOrderAuditOrderCreateFuncReqBO.setUserName(reqBo.getCustNameIn());
        dycUocOrderAuditOrderCreateFuncReqBO.setCenter("UMC");
        DycUocOrderAuditOrderCreateFuncRspBO dycUocOrderAuditOrderCreateFuncRspBO = this.dycUocOrderAuditOrderCreateFunction.dealOrderAuditOrderCreate(dycUocOrderAuditOrderCreateFuncReqBO);
        return dycUocOrderAuditOrderCreateFuncRspBO.getAuditOrderId();
    }

    private void updateEnableStatus(UmcSupEnableConfirmServiceReqBo reqBo) {
        UmcSupplierEnableInfoPO where = new UmcSupplierEnableInfoPO();
        where.setId(reqBo.getEnableOrderId());
        where.setSupEnableNo(reqBo.getEnableOrderNo());
        UmcSupplierEnableInfoPO set = new UmcSupplierEnableInfoPO();
        set.setEnableStatus("DAI_SHEN_PI");
        set.setSupplierStatus("DAI_RU_KU");
        set.setSubmitTime(new Date());
        this.umcSupplierEnableInfoMapper.updateBy(set, where);
    }

    private static void validateParams(UmcSupEnableConfirmServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getEnableOrderId() == null) {
            throw new ZTBusinessException("enableOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getEnableOrderNo() == null) {
            throw new ZTBusinessException("enableOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

