/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.supplier.api.UmcSyncSupplierDetailsService;
import com.tydic.dyc.atom.busicommon.supplier.bo.UmcSyncSupplierDetailsServiceReqBo;
import com.tydic.dyc.atom.transaction.api.UmcSupplierAccessSaveService;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierAccessSaveReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierAccessSaveRspBo;
import com.tydic.dyc.authority.service.organization.AuthModifyOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgInfoRspBo;
import com.tydic.dyc.umc.model.common.IUmcCommonModel;
import com.tydic.dyc.umc.model.common.sub.UmcAccessory;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseBankQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseContactQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcEnterpriseInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoRspBo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.repository.dao.EnterpriseBusinessScopeMapper;
import com.tydic.dyc.umc.repository.dao.UmcAccessoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcCategoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierCategoryMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierIndustryMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseBusinessScopePO;
import com.tydic.dyc.umc.repository.po.UmcAccessoryPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierCategoryPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierIndustryPO;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoUpdateService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseBankBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseContactBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoUpdateRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.supplieraccess.bo.AnnoxBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcEnterpriseBankInfoAccessBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcEnterpriseInfoAccessBO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcSupplierAccessSaveService"})
public class UmcSupplierAccessSaveServiceImpl
implements UmcSupplierAccessSaveService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;
    @Autowired
    private UmcEnterpriseInfoUpdateService umcEnterpriseInfoUpdateService;
    @Autowired
    private AuthModifyOrgInfoService authModifyOrgInfoService;
    @Autowired
    private UmcSupplierIndustryMapper umcSupplierIndustryMapper;
    @Autowired
    private UmcSupplierCategoryMapper umcSupplierCategoryMapper;
    @Autowired
    private UmcAccessoryMapper umcAccessoryMapper;
    @Autowired
    private IUmcCommonModel iUmcCommonModel;
    @Autowired
    private UmcSyncSupplierDetailsService umcSyncSupplierDetailsService;
    @Autowired
    private EnterpriseBusinessScopeMapper enterpriseBusinessScopeMapper;
    @Autowired
    private UmcCategoryMapper umcCategoryMapper;
    private static final String ENTERPRISE_OBJ_TYPE = "12";

    @PostMapping(value={"saveAccess"})
    public UmcSupplierAccessSaveRspBo saveAccess(@RequestBody UmcSupplierAccessSaveReqBo reqBO) {
        List insertPo;
        UmcOrgInfoRspBo orgInfoList;
        Boolean isValid = true;
        try {
            this.validateParams(reqBO);
        }
        catch (Exception e) {
            if ("2".equals(reqBO.getSaveType())) {
                throw new ZTBusinessException(e.getMessage());
            }
            isValid = false;
        }
        UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO = reqBO.getUmcEnterpriseInfoBO();
        UmcEnterpriseBankInfoAccessBO umcEnterpriseBankInfoBO = reqBO.getUmcEnterpriseBankInfoBO();
        List industryList = reqBO.getIndustryList();
        List categoryList = reqBO.getCategoryList();
        if (!StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getEnterpriseName())) {
            UmcOrgInfoQryBo orgNameQryBo = new UmcOrgInfoQryBo();
            orgNameQryBo.setOrgName(umcEnterpriseInfoBO.getEnterpriseName());
            orgInfoList = this.iUmcEnterpriseInfoModel.getOrgInfoList(orgNameQryBo);
            if (!CollectionUtils.isEmpty((Collection)orgInfoList.getRows())) {
                for (UmcOrgInfo info : orgInfoList.getRows()) {
                    if (umcEnterpriseInfoBO.getOrgId().equals(info.getOrgId())) continue;
                    throw new ZTBusinessException("\u4f9b\u5e94\u5546\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u4f9b\u5e94\u5546\u540d\u79f0");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getOrgCertificateCode())) {
            UmcEnterpriseInfoQryBo orgCertificateCodeQryBo = new UmcEnterpriseInfoQryBo();
            orgCertificateCodeQryBo.setCreditNo(umcEnterpriseInfoBO.getOrgCertificateCode());
            orgInfoList = this.iUmcEnterpriseInfoModel.getEnterpriseInfoList(orgCertificateCodeQryBo);
            if (!CollectionUtils.isEmpty((Collection)orgInfoList.getRows())) {
                for (UmcOrgInfo info : orgInfoList.getRows()) {
                    if (umcEnterpriseInfoBO.getOrgId().equals(info.getOrgId())) continue;
                    throw new ZTBusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801");
                }
            }
        }
        UmcEnterpriseInfoUpdateReqBo umcEnterpriseInfoUpdateReqBo = this.buildEnterpriseInfoUpdateReqBo(umcEnterpriseInfoBO, umcEnterpriseBankInfoBO);
        if (isValid.booleanValue()) {
            umcEnterpriseInfoUpdateReqBo.setSupplierStatus("QIAN_ZAI");
        }
        UmcEnterpriseInfoUpdateRspBo enterpriseInfoUpdateRspBo = this.umcEnterpriseInfoUpdateService.updateEnterpriseInfo(umcEnterpriseInfoUpdateReqBo);
        AuthModifyOrgInfoReqBo authModifyOrgInfoReqBo = this.buildAuthModifyOrgInfoReqBo(umcEnterpriseInfoBO);
        AuthModifyOrgInfoRspBo authModifyOrgInfoRspBo = this.authModifyOrgInfoService.modifyOrgInfo(authModifyOrgInfoReqBo);
        if (!CollectionUtils.isEmpty((Collection)industryList)) {
            UmcSupplierIndustryPO deleteIndustry = new UmcSupplierIndustryPO();
            deleteIndustry.setOrgId(umcEnterpriseInfoBO.getOrgId());
            this.umcSupplierIndustryMapper.deleteBy(deleteIndustry);
            insertPo = UmcRu.jsl((List)industryList, UmcSupplierIndustryPO.class);
            for (UmcSupplierIndustryPO po : insertPo) {
                po.setOrgId(umcEnterpriseInfoBO.getOrgId());
                po.setSupplierIndustryId(Long.valueOf(IdUtil.nextId()));
                po.setCreateTime(new Date());
            }
            this.umcSupplierIndustryMapper.insertBatch(insertPo);
        }
        if (!CollectionUtils.isEmpty((Collection)categoryList)) {
            UmcSupplierCategoryPO deleteCategory = new UmcSupplierCategoryPO();
            deleteCategory.setOrgId(umcEnterpriseInfoBO.getOrgId());
            this.umcSupplierCategoryMapper.deleteBy(deleteCategory);
            insertPo = UmcRu.jsl((List)categoryList, UmcSupplierCategoryPO.class);
            for (UmcSupplierIndustryPO po : insertPo) {
                po.setOrgId(umcEnterpriseInfoBO.getOrgId());
                po.setSupplierCategoryId(Long.valueOf(IdUtil.nextId()));
                po.setCreateTime(new Date());
            }
            this.umcSupplierCategoryMapper.insertBatch(insertPo);
        }
        EnterpriseBusinessScopePO enterpriseBusinessScopePO = new EnterpriseBusinessScopePO();
        enterpriseBusinessScopePO.setOrgId(umcEnterpriseInfoBO.getOrgId());
        enterpriseBusinessScopePO.setBusinessScope(umcEnterpriseInfoBO.getBusinessScope());
        EnterpriseBusinessScopePO checkPo = new EnterpriseBusinessScopePO();
        checkPo.setOrgId(umcEnterpriseInfoBO.getOrgId());
        int checkScope = this.enterpriseBusinessScopeMapper.getCheckBy(checkPo);
        if (checkScope == 0) {
            this.enterpriseBusinessScopeMapper.insert(enterpriseBusinessScopePO);
        } else {
            this.enterpriseBusinessScopeMapper.updateById(enterpriseBusinessScopePO);
        }
        this.updateAccessort(reqBO);
        CompletableFuture.runAsync(() -> {
            UmcSyncSupplierDetailsServiceReqBo syncSupplierDetailsServiceReqBo = new UmcSyncSupplierDetailsServiceReqBo();
            syncSupplierDetailsServiceReqBo.setOrgIdWeb(umcEnterpriseInfoBO.getOrgId());
            this.umcSyncSupplierDetailsService.syncSupInfo(syncSupplierDetailsServiceReqBo);
        });
        return (UmcSupplierAccessSaveRspBo)UmcRu.success(UmcSupplierAccessSaveRspBo.class);
    }

    private void updateAccessort(UmcSupplierAccessSaveReqBo reqBO) {
        UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO = reqBO.getUmcEnterpriseInfoBO();
        ArrayList<UmcAccessory> delAccessoryList = new ArrayList<UmcAccessory>();
        ArrayList<UmcAccessory> insertUmcAccessories = new ArrayList<UmcAccessory>();
        if (umcEnterpriseInfoBO.getPlantPhotos() != null && umcEnterpriseInfoBO.getPlantPhotos().size() > 0) {
            this.buildAccessory(umcEnterpriseInfoBO.getPlantPhotos(), insertUmcAccessories, reqBO, "PLANT_PHOTO", delAccessoryList);
        }
        if (umcEnterpriseInfoBO.getOfficePhotos() != null && umcEnterpriseInfoBO.getOfficePhotos().size() > 0) {
            this.buildAccessory(umcEnterpriseInfoBO.getOfficePhotos(), insertUmcAccessories, reqBO, "OFFICE_PHOTOS", delAccessoryList);
        }
        if (umcEnterpriseInfoBO.getPlantLeaseContractAccessory() != null && umcEnterpriseInfoBO.getPlantLeaseContractAccessory().size() > 0) {
            this.buildAccessory(umcEnterpriseInfoBO.getPlantLeaseContractAccessory(), insertUmcAccessories, reqBO, "PLANT_LEASE_CONTRACT", delAccessoryList);
        }
        if (umcEnterpriseInfoBO.getLeaseContractAccessory() != null && umcEnterpriseInfoBO.getLeaseContractAccessory().size() > 0) {
            this.buildAccessory(umcEnterpriseInfoBO.getLeaseContractAccessory(), insertUmcAccessories, reqBO, "LEASE_CONTRACT", delAccessoryList);
        }
        for (UmcAccessory umcAccessory : delAccessoryList) {
            this.umcAccessoryMapper.deleteBy((UmcAccessoryPO)UmcRu.js((Object)umcAccessory, UmcAccessoryPO.class));
        }
        this.umcAccessoryMapper.insertBatch(UmcRu.jsl(insertUmcAccessories, UmcAccessoryPO.class));
    }

    private void buildAccessory(List<AnnoxBO> annoxBOS, List<UmcAccessory> umcAccessories, UmcSupplierAccessSaveReqBo reqBO, String accessoryType, List<UmcAccessory> delAccessoryList) {
        UmcAccessory accessory = new UmcAccessory();
        accessory.setObjId(reqBO.getOrgId());
        accessory.setAttachmentType(accessoryType);
        delAccessoryList.add(accessory);
        for (AnnoxBO plantPhoto : annoxBOS) {
            UmcAccessory umcAccessory = new UmcAccessory();
            umcAccessory.setId(Long.valueOf(IdUtil.nextId()));
            umcAccessory.setObjId(reqBO.getOrgId());
            umcAccessory.setObjType(ENTERPRISE_OBJ_TYPE);
            umcAccessory.setAttachmentType(accessoryType);
            umcAccessory.setTenantId(reqBO.getTenantIdIn());
            umcAccessory.setAccessoryName(plantPhoto.getName());
            umcAccessory.setAccessoryUrl(plantPhoto.getPath());
            umcAccessory.setCreateTime(new Date());
            umcAccessory.setCreateOperId(reqBO.getUserId().toString());
            umcAccessories.add(umcAccessory);
        }
    }

    private AuthModifyOrgInfoReqBo buildAuthModifyOrgInfoReqBo(UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO) {
        AuthModifyOrgInfoReqBo authModifyOrgInfoReqBo = new AuthModifyOrgInfoReqBo();
        authModifyOrgInfoReqBo.setOrgId(umcEnterpriseInfoBO.getOrgId());
        authModifyOrgInfoReqBo.setOrgName(umcEnterpriseInfoBO.getEnterpriseName());
        authModifyOrgInfoReqBo.setOrgAlias(umcEnterpriseInfoBO.getSupplierShortName());
        authModifyOrgInfoReqBo.setChngTagFlag("0");
        return authModifyOrgInfoReqBo;
    }

    private UmcEnterpriseInfoUpdateReqBo buildEnterpriseInfoUpdateReqBo(UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO, UmcEnterpriseBankInfoAccessBO umcEnterpriseBankInfoBO) {
        UmcEnterpriseInfoUpdateReqBo updateReqBo = (UmcEnterpriseInfoUpdateReqBo)UmcRu.js((Object)umcEnterpriseInfoBO, UmcEnterpriseInfoUpdateReqBo.class);
        updateReqBo.setOrgEnName(umcEnterpriseInfoBO.getSupplierEnName());
        updateReqBo.setOrgShortName(umcEnterpriseInfoBO.getSupplierShortName());
        updateReqBo.setOrgNature(umcEnterpriseInfoBO.getEnterpriseNature());
        updateReqBo.setLegalCertificateType(umcEnterpriseInfoBO.getLegalPersonIdcardType());
        updateReqBo.setLegalCertificateNum(umcEnterpriseInfoBO.getLegalPersonIdcardNum());
        updateReqBo.setCreditNo(umcEnterpriseInfoBO.getOrgCertificateCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (umcEnterpriseInfoBO.getEffDate() != null) {
            updateReqBo.setEffDate(sdf.format(umcEnterpriseInfoBO.getEffDate()));
        }
        if (!"6".equals(umcEnterpriseInfoBO.getSupplierType())) {
            updateReqBo.setSupplierTypeOther("");
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoBO.getLegalPersonCardPro())) {
            updateReqBo.setLegalCertificateFront(JSONObject.toJSONString((Object)umcEnterpriseInfoBO.getLegalPersonCardPro()));
        }
        if (!CollectionUtils.isEmpty((Collection)umcEnterpriseInfoBO.getLegalPersonCardCan())) {
            updateReqBo.setLegalCertificateBack(JSONObject.toJSONString((Object)umcEnterpriseInfoBO.getLegalPersonCardCan()));
        }
        if (!(StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getProvinceId()) || StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getCityId()) || StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getCountyId()))) {
            String registerAddress = this.buildRegisterAddress(umcEnterpriseInfoBO);
            updateReqBo.setProvince(registerAddress);
        }
        if (StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getSupplierShortName())) {
            updateReqBo.setOrgShortNameSetNull(Integer.valueOf(1));
        }
        if (StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getSupplierEnName())) {
            updateReqBo.setOrgEnNameSetNull(Integer.valueOf(1));
        }
        if (StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getBrand())) {
            updateReqBo.setBrandSetNull(Integer.valueOf(1));
        }
        UmcOrgInfoBo orgInfoBo = new UmcOrgInfoBo();
        orgInfoBo.setOrgId(umcEnterpriseInfoBO.getOrgId());
        orgInfoBo.setOrgName(umcEnterpriseInfoBO.getEnterpriseName());
        if (StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getSupplierShortName())) {
            orgInfoBo.setOrgAliasSetNull(Integer.valueOf(1));
        } else {
            orgInfoBo.setOrgAlias(umcEnterpriseInfoBO.getSupplierShortName());
        }
        updateReqBo.setOrgInfoBo(orgInfoBo);
        updateReqBo.setIsUpdateTagFlag(Boolean.valueOf(false));
        if (umcEnterpriseBankInfoBO.getBankId() == null) {
            UmcEnterpriseBankQryBo enterpriseBankQryBo = new UmcEnterpriseBankQryBo();
            enterpriseBankQryBo.setOrgId(umcEnterpriseInfoBO.getOrgId());
            UmcEnterpriseBank umcEnterpriseBank = this.iUmcEnterpriseInfoModel.getEnterpriseBank(enterpriseBankQryBo);
            if (umcEnterpriseBank != null) {
                umcEnterpriseBankInfoBO.setBankId(umcEnterpriseBank.getBankId());
            }
        }
        ArrayList<UmcEnterpriseBankBo> enterpriseBankBoList = new ArrayList<UmcEnterpriseBankBo>();
        UmcEnterpriseBankBo enterpriseBankBo = new UmcEnterpriseBankBo();
        enterpriseBankBo.setBankId(umcEnterpriseBankInfoBO.getBankId());
        enterpriseBankBo.setOrgId(umcEnterpriseInfoBO.getOrgId());
        enterpriseBankBo.setBankName(umcEnterpriseBankInfoBO.getBankName());
        enterpriseBankBo.setBankCode(umcEnterpriseBankInfoBO.getBankCode());
        enterpriseBankBo.setBankAccountName(umcEnterpriseBankInfoBO.getBankAccountName());
        enterpriseBankBo.setBankAccount(umcEnterpriseBankInfoBO.getBankAccount());
        enterpriseBankBo.setBankLinkNo(umcEnterpriseBankInfoBO.getBankLinkNo());
        enterpriseBankBo.setBankAddr(umcEnterpriseBankInfoBO.getBankAddr());
        enterpriseBankBo.setExtField1(umcEnterpriseBankInfoBO.getInvoiceType());
        enterpriseBankBo.setExtField2(umcEnterpriseBankInfoBO.getInvoiceTaxRate());
        enterpriseBankBoList.add(enterpriseBankBo);
        updateReqBo.setEnterpriseBankBoList(enterpriseBankBoList);
        UmcEnterpriseContactQryBo enterpriseContactQryBo = new UmcEnterpriseContactQryBo();
        enterpriseContactQryBo.setOrgId(umcEnterpriseInfoBO.getOrgId());
        UmcEnterpriseContact enterpriseContact = this.iUmcEnterpriseInfoModel.getEnterpriseContact(enterpriseContactQryBo);
        ArrayList<UmcEnterpriseContactBo> enterpriseContactBoList = new ArrayList<UmcEnterpriseContactBo>();
        UmcEnterpriseContactBo enterpriseContactBo = new UmcEnterpriseContactBo();
        if (enterpriseContact == null) {
            enterpriseContactBo.setContactId(null);
        } else {
            enterpriseContactBo.setContactId(enterpriseContact.getContactId());
        }
        enterpriseContactBo.setOrgId(umcEnterpriseInfoBO.getOrgId());
        enterpriseContactBo.setContactName(umcEnterpriseInfoBO.getConsignerName());
        enterpriseContactBo.setPhoneNumber(umcEnterpriseInfoBO.getPhoneNumber());
        enterpriseContactBo.setTel(umcEnterpriseInfoBO.getTel());
        enterpriseContactBo.setEmail(umcEnterpriseInfoBO.getEmail());
        enterpriseContactBo.setCardType(umcEnterpriseInfoBO.getConsignerIdcardType());
        enterpriseContactBo.setCardNum(umcEnterpriseInfoBO.getConsignerIdcardNum());
        enterpriseContactBo.setCardPicPeople(JSONObject.toJSONString((Object)umcEnterpriseInfoBO.getConsignerCardPro()));
        enterpriseContactBo.setCardPicNational(JSONObject.toJSONString((Object)umcEnterpriseInfoBO.getConsignerCardCon()));
        enterpriseContactBoList.add(enterpriseContactBo);
        updateReqBo.setEnterpriseContactBoList(enterpriseContactBoList);
        return updateReqBo;
    }

    private String buildRegisterAddress(UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO) {
        JSONObject registerAddress = new JSONObject();
        registerAddress.put("provinceId", (Object)umcEnterpriseInfoBO.getProvinceId());
        registerAddress.put("provinceName", (Object)umcEnterpriseInfoBO.getProvinceName());
        registerAddress.put("cityId", (Object)umcEnterpriseInfoBO.getCityId());
        registerAddress.put("cityName", (Object)umcEnterpriseInfoBO.getCityName());
        registerAddress.put("countyId", (Object)umcEnterpriseInfoBO.getCountyId());
        registerAddress.put("countyName", (Object)umcEnterpriseInfoBO.getCountyName());
        if (!StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getTownId())) {
            registerAddress.put("townId", (Object)umcEnterpriseInfoBO.getTownId());
        }
        if (!StringUtils.isEmpty((Object)umcEnterpriseInfoBO.getTownName())) {
            registerAddress.put("townName", (Object)umcEnterpriseInfoBO.getTownName());
        }
        return registerAddress.toJSONString();
    }

    private void validateParams(UmcSupplierAccessSaveReqBo reqBO) {
        UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO = reqBO.getUmcEnterpriseInfoBO();
        UmcEnterpriseBankInfoAccessBO umcEnterpriseBankInfoBO = reqBO.getUmcEnterpriseBankInfoBO();
        List industryList = reqBO.getIndustryList();
        List categoryList = reqBO.getCategoryList();
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4f01\u4e1a\u4fe1\u606f\u3010umcEnterpriseInfoBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (umcEnterpriseInfoBO.getOrgId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784ID\u3010orgId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getSupplierType())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u7c7b\u578b\u3010supplierType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getSupplierName())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u540d\u79f0\u3010supplierName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getConsignerName())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u3010consignerName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getPhoneNumber())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u7801\u3010phoneNumber\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getEmail())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u90ae\u7bb1\u3010email\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getConsignerIdcardNum())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u8bc1\u4ef6\u53f7\u7801\u3010consignerIdcardNum\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getCapaPicture())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u6388\u6743\u59d4\u6258\u4e66\u626b\u63cf\u4ef6\u3010capaPicture\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getContactDirectLeader())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u76f4\u5c5e\u9886\u5bfc\u3010contactDirectLeader\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getContactDirectLeaderMobile())) {
            throw new ZTBusinessException("\u76f4\u5c5e\u9886\u5bfc\u624b\u673a\u53f7\u7801\u3010contactDirectLeaderMobile\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getContactDirectLeaderEmail())) {
            throw new ZTBusinessException("\u76f4\u5c5e\u9886\u5bfc\u90ae\u7bb1\u3010contactDirectLeaderEmail\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getOrgCertificateCode())) {
            throw new ZTBusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u3010orgCertificateCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getCapital())) {
            throw new ZTBusinessException("\u6ce8\u518c\u8d44\u91d1\u3010capital\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getLegalPerson())) {
            throw new ZTBusinessException("\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3010legalPerson\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getLegalPersonIdcardNum())) {
            throw new ZTBusinessException("\u6cd5\u4eba\u8bc1\u4ef6\u53f7\u7801\u3010legalPersonIdcardNum\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getPersonnelSize())) {
            throw new ZTBusinessException("\u516c\u53f8\u4eba\u5458\u89c4\u6a21\u3010personnelSize\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getLandProperties())) {
            throw new ZTBusinessException("\u529e\u516c\u5360\u5730\u6027\u8d28\u3010landProperties\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getOfficePhotos())) {
            throw new ZTBusinessException("\u529e\u516c\u7167\u7247\u3010officePhotos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseInfoBO.getPlantLandProperties())) {
            throw new ZTBusinessException("\u5382\u623f\u5360\u5730\u6027\u8d28\u3010plantLandProperties\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseBankInfoBO)) {
            throw new ZTBusinessException("\u94f6\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseBankInfoBO.getBankName())) {
            throw new ZTBusinessException("\u5f00\u6237\u94f6\u884c\u3010bankName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseBankInfoBO.getBankAccountName())) {
            throw new ZTBusinessException("\u5f00\u6237\u540d\u79f0\u3010bankAccountName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!umcEnterpriseBankInfoBO.getBankAccountName().equals(umcEnterpriseInfoBO.getSupplierName())) {
            throw new ZTBusinessException("\u5f00\u6237\u540d\u79f0\u4e0e\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u4e00\u81f4");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseBankInfoBO.getBankAccount())) {
            throw new ZTBusinessException("\u5f00\u6237\u94f6\u884c\u8d26\u53f7\u3010bankAccount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseBankInfoBO.getBankLinkNo())) {
            throw new ZTBusinessException("\u5f00\u6237\u94f6\u884c\u8054\u884c\u53f7\u3010bankLinkNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)umcEnterpriseBankInfoBO.getBankAddr())) {
            throw new ZTBusinessException("\u5f00\u6237\u884c\u5730\u5740\u3010bankAddr\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)industryList)) {
            throw new ZTBusinessException("\u671f\u671b\u5408\u4f5c\u884c\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)categoryList)) {
            throw new ZTBusinessException("\u671f\u671b\u5408\u4f5c\u54c1\u7c7b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

