/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.atom.common.api.DycUocOrderAuditOrderCreateFunction;
import com.tydic.dyc.atom.common.bo.DycUocOrderAuditOrderCreateFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUocOrderAuditOrderCreateFuncRspBO;
import com.tydic.dyc.atom.common.member.task.api.DycUmcAuditProcessCreateFunction;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionReqBo;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionRspBo;
import com.tydic.dyc.atom.transaction.api.UmcSupplierCreateRatingLevelApprovalService;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierCreateRatingLevelApprovalReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierCreateRatingLevelApprovalRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.SupCommConstants;
import com.tydic.dyc.umc.constants.UmcConstant;
import com.tydic.dyc.umc.repository.dao.SupInspectionMapper;
import com.tydic.dyc.umc.repository.dao.SupRatingApprovalMapper;
import com.tydic.dyc.umc.repository.po.SupInspectionPO;
import com.tydic.dyc.umc.repository.po.SupRatingApprovalPO;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcSupplierCreateRatingLevelApprovalService"})
public class UmcSupplierCreateRatingLevelApprovalServiceImpl
implements UmcSupplierCreateRatingLevelApprovalService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupplierCreateRatingLevelApprovalServiceImpl.class);
    @Autowired
    private SupInspectionMapper supInspectionMapper;
    @Autowired
    private SupRatingApprovalMapper supRatingApprovalMapper;
    @Autowired
    private DycUocOrderAuditOrderCreateFunction dycUocOrderAuditOrderCreateFunction;
    @Value(value="${sup_rating_level_approval:supplier_rating_level}")
    private String supRatingLevelApproval;
    @Value(value="${SYS_CODE:DYC}")
    private String sys_code;
    @Autowired
    private DycUmcAuditProcessCreateFunction dycUmcAuditProcessCreateFunction;

    @PostMapping(value={"createRatingLevelApproval"})
    public UmcSupplierCreateRatingLevelApprovalRspBo createRatingLevelApproval(@RequestBody UmcSupplierCreateRatingLevelApprovalReqBo reqBo) {
        SupInspectionPO supInspectionPO = new SupInspectionPO();
        supInspectionPO.setInspectionId(reqBo.getInspectionId());
        supInspectionPO = this.supInspectionMapper.getModelBy(supInspectionPO);
        SupRatingApprovalPO supRatingApprovalPO = new SupRatingApprovalPO();
        BeanUtils.copyProperties((Object)supInspectionPO, (Object)supRatingApprovalPO);
        supRatingApprovalPO.setRatingApprovalId(Long.valueOf(Sequence.getInstance().nextId()));
        supRatingApprovalPO.setRatingCompanyId(supInspectionPO.getInspectionCompanyId());
        supRatingApprovalPO.setRatingCompanyName(supInspectionPO.getInspectionCompanyName());
        supRatingApprovalPO.setRatingType(supInspectionPO.getScoringType());
        supRatingApprovalPO.setRatingCycleType(supInspectionPO.getInspectionCycleType());
        supRatingApprovalPO.setApprovalType(SupCommConstants.RatingBusinessType.LEVEL);
        DycUocOrderAuditOrderCreateFuncReqBO dycUocOrderAuditOrderCreateFuncReqBO = (DycUocOrderAuditOrderCreateFuncReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), DycUocOrderAuditOrderCreateFuncReqBO.class);
        dycUocOrderAuditOrderCreateFuncReqBO.setUserName(reqBo.getUsername());
        dycUocOrderAuditOrderCreateFuncReqBO.setOrderId(supInspectionPO.getInspectionId());
        dycUocOrderAuditOrderCreateFuncReqBO.setAuditObjId(supInspectionPO.getInspectionId());
        dycUocOrderAuditOrderCreateFuncReqBO.setAuditObjType(UmcConstant.ObjBusiType.RATING_LEVEL_AUDIT);
        dycUocOrderAuditOrderCreateFuncReqBO.setObjBusiType(UmcConstant.ObjBusiType.RATING_LEVEL_AUDIT);
        dycUocOrderAuditOrderCreateFuncReqBO.setUserId(reqBo.getUserIdIn());
        dycUocOrderAuditOrderCreateFuncReqBO.setCenter("UMC");
        DycUocOrderAuditOrderCreateFuncRspBO funcRspBO = this.dycUocOrderAuditOrderCreateFunction.dealOrderAuditOrderCreate(dycUocOrderAuditOrderCreateFuncReqBO);
        if (!"0000".equals(funcRspBO.getRespCode())) {
            throw new BaseBusinessException("161004", "\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5931\u8d25:\u751f\u6210\u8bc4\u7ea7\u5ba1\u6279\u5931\u8d25");
        }
        this.startAuditProcess(reqBo, funcRspBO.getAuditOrderId());
        supRatingApprovalPO.setStatus("1001");
        supRatingApprovalPO.setTaskId(funcRspBO.getAuditOrderId());
        String name = "";
        if (supInspectionPO.getInspectionCycleType().equals(SupCommConstants.InspectionCycleType.YEAR)) {
            name = supInspectionPO.getInspectionYear() + "\u5e74";
        }
        if (supInspectionPO.getInspectionCycleType().equals(SupCommConstants.InspectionCycleType.QUARTER)) {
            name = supInspectionPO.getInspectionYear() + "\u5e74" + supInspectionPO.getInspectionQuarter() + "\u5b63\u5ea6";
        }
        if (supInspectionPO.getInspectionCycleType().equals(SupCommConstants.InspectionCycleType.MONTH)) {
            name = supInspectionPO.getInspectionYear() + "\u5e74" + supInspectionPO.getInspectionMonth() + "\u6708";
        }
        supRatingApprovalPO.setRatingCycle(name);
        log.info("\u4fdd\u5b58\u5ba1\u6279\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)supRatingApprovalPO));
        int count = this.supRatingApprovalMapper.insert(supRatingApprovalPO);
        if (count <= 0) {
            throw new BaseBusinessException("161004", "\u751f\u6210\u8bc4\u7ea7\u5ba1\u6279\u5931\u8d25");
        }
        UmcSupplierCreateRatingLevelApprovalRspBo rspBo = new UmcSupplierCreateRatingLevelApprovalRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void startAuditProcess(UmcSupplierCreateRatingLevelApprovalReqBo reqBO, Long auditOrderId) {
        DycUmcAuditProcessCreateFunctionReqBo abilityReqBO = new DycUmcAuditProcessCreateFunctionReqBo();
        abilityReqBO.setOrgId(Convert.toStr((Object)reqBO.getOrgId()));
        ArrayList<String> busiList = new ArrayList<String>();
        busiList.add(reqBO.getInspectionId().toString());
        abilityReqBO.setBusinessIdList(busiList);
        abilityReqBO.setProcDefKey(this.supRatingLevelApproval);
        abilityReqBO.setSysCode(this.sys_code);
        abilityReqBO.setUserId(reqBO.getUserIdIn().toString());
        abilityReqBO.setUserName(reqBO.getUsername());
        abilityReqBO.setOrgName(reqBO.getOrgName());
        abilityReqBO.setBusinessType(UmcConstant.ObjBusiType.RATING_LEVEL_AUDIT.toString());
        abilityReqBO.setPartitionKey(reqBO.getInspectionId().toString());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("auditObjId", auditOrderId);
        map.put("applyId", reqBO.getInspectionId());
        abilityReqBO.setVariables(map);
        DycUmcAuditProcessCreateFunctionRspBo abilityRspBO = this.dycUmcAuditProcessCreateFunction.createProcess(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
    }
}

