/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.transaction.api.UmcSupplierEventCriteriaOperService;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierEventCriteriaOperReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierEventCriteriaOperRspBo;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEventCriteriaMapper;
import com.tydic.dyc.umc.repository.po.UmcSupplierEventCriteriaPO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcSupplierEventCriteriaOperService"})
public class UmcSupplierEventCriteriaOperServiceImpl
implements UmcSupplierEventCriteriaOperService {
    @Autowired
    private UmcSupplierEventCriteriaMapper umcSupplierEventCriteriaMapper;
    private final Integer OPER_TYPE_ADD = 1;
    private final Integer OPER_TYPE_UPDATE = 2;
    private final Integer OPER_TYPE_DELETE = 3;

    @PostMapping(value={"addEventCriteria"})
    public UmcSupplierEventCriteriaOperRspBo addEventCriteria(@RequestBody UmcSupplierEventCriteriaOperReqBo reqBo) {
        this.check(reqBo, this.OPER_TYPE_ADD);
        UmcSupplierEventCriteriaPO eventCriteriaPO = (UmcSupplierEventCriteriaPO)UmcRu.js((Object)reqBo, UmcSupplierEventCriteriaPO.class);
        eventCriteriaPO.setEventCriteriaId(Long.valueOf(IdUtil.nextId()));
        eventCriteriaPO.setCreateNo(reqBo.getUserIdIn());
        eventCriteriaPO.setCreateTime(new Date());
        this.umcSupplierEventCriteriaMapper.insert(eventCriteriaPO);
        UmcSupplierEventCriteriaOperRspBo rspBo = new UmcSupplierEventCriteriaOperRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"updateEventCriteria"})
    public UmcSupplierEventCriteriaOperRspBo updateEventCriteria(@RequestBody UmcSupplierEventCriteriaOperReqBo reqBo) {
        this.check(reqBo, this.OPER_TYPE_UPDATE);
        UmcSupplierEventCriteriaPO eventCriteriaPO = (UmcSupplierEventCriteriaPO)UmcRu.js((Object)reqBo, UmcSupplierEventCriteriaPO.class);
        this.umcSupplierEventCriteriaMapper.updateById(eventCriteriaPO);
        UmcSupplierEventCriteriaOperRspBo rspBo = new UmcSupplierEventCriteriaOperRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"deleteEventCriteria"})
    public UmcSupplierEventCriteriaOperRspBo deleteEventCriteria(@RequestBody UmcSupplierEventCriteriaOperReqBo reqBo) {
        this.check(reqBo, this.OPER_TYPE_DELETE);
        UmcSupplierEventCriteriaPO eventCriteriaPO = new UmcSupplierEventCriteriaPO();
        eventCriteriaPO.setEventCriteriaId(reqBo.getEventCriteriaId());
        this.umcSupplierEventCriteriaMapper.deleteBy(eventCriteriaPO);
        UmcSupplierEventCriteriaOperRspBo rspBo = new UmcSupplierEventCriteriaOperRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void check(UmcSupplierEventCriteriaOperReqBo reqBo, Integer operType) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((this.OPER_TYPE_UPDATE.equals(operType) || this.OPER_TYPE_DELETE.equals(operType)) && reqBo.getEventCriteriaId() == null) {
            throw new ZTBusinessException("\u4eae\u706f\u4f9d\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.OPER_TYPE_ADD.equals(operType) || this.OPER_TYPE_UPDATE.equals(operType)) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getEventCriteriaDesc())) {
                throw new ZTBusinessException("\u4eae\u706f\u4f9d\u636e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getEventIndicatorsId() == null) {
                throw new ZTBusinessException("\u4e8b\u4ef6\u6307\u6807ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getRectify() == null) {
                throw new ZTBusinessException("\u662f\u5426\u6574\u6539\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

