/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.transaction.api.UmcSupplierEventIndicatorsOperService;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierEventIndicatorsOperReqBo;
import com.tydic.dyc.atom.transaction.bo.UmcSupplierEventIndicatorsOperRspBo;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEventCriteriaMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierEventIndicatorsMapper;
import com.tydic.dyc.umc.repository.po.UmcSupplierEventCriteriaPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierEventIndicatorsPO;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.UmcSupplierEventIndicatorsOperService"})
public class UmcSupplierEventIndicatorsOperServiceImpl
implements UmcSupplierEventIndicatorsOperService {
    @Autowired
    private UmcSupplierEventIndicatorsMapper umcSupplierEventIndicatorsMapper;
    @Autowired
    private UmcSupplierEventCriteriaMapper umcSupplierEventCriteriaMapper;
    private final Integer OPER_TYPE_ADD = 1;
    private final Integer OPER_TYPE_UPDATE = 2;
    private final Integer OPER_TYPE_DELETE = 3;

    @PostMapping(value={"addEventIndicators"})
    public UmcSupplierEventIndicatorsOperRspBo addEventIndicators(@RequestBody UmcSupplierEventIndicatorsOperReqBo reqBo) {
        this.check(reqBo, this.OPER_TYPE_ADD);
        UmcSupplierEventIndicatorsPO checkPO = new UmcSupplierEventIndicatorsPO();
        checkPO.setEventIndicatorsCode(reqBo.getEventIndicatorsCode());
        checkPO.setBusinessCompanyId(reqBo.getBusinessCompanyId());
        if (this.umcSupplierEventIndicatorsMapper.getCheckBy(checkPO) > 0) {
            throw new ZTBusinessException("\u4e8b\u4ef6\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
        }
        UmcSupplierEventIndicatorsPO eventIndicatorsPO = new UmcSupplierEventIndicatorsPO();
        eventIndicatorsPO.setEventIndicatorsId(Long.valueOf(IdUtil.nextId()));
        eventIndicatorsPO.setBusinessCompanyId(reqBo.getBusinessCompanyId());
        eventIndicatorsPO.setBusinessCompanyName(reqBo.getBusinessCompanyName());
        if ("0".equals(reqBo.getApplicableScope())) {
            eventIndicatorsPO.setBusinessCompanyName("\u5168\u5c40");
        }
        eventIndicatorsPO.setEventIndicatorsCode(reqBo.getEventIndicatorsCode());
        eventIndicatorsPO.setRectify(reqBo.getRectify());
        eventIndicatorsPO.setApplicableScope(reqBo.getApplicableScope());
        eventIndicatorsPO.setCreateNo(reqBo.getUserIdIn());
        eventIndicatorsPO.setCreateTime(new Date());
        this.umcSupplierEventIndicatorsMapper.insert(eventIndicatorsPO);
        UmcSupplierEventIndicatorsOperRspBo rspBo = (UmcSupplierEventIndicatorsOperRspBo)UmcRu.js((Object)eventIndicatorsPO, UmcSupplierEventIndicatorsOperRspBo.class);
        return rspBo;
    }

    @PostMapping(value={"updateEventIndicators"})
    public UmcSupplierEventIndicatorsOperRspBo updateEventIndicators(@RequestBody UmcSupplierEventIndicatorsOperReqBo reqBo) {
        this.check(reqBo, this.OPER_TYPE_UPDATE);
        UmcSupplierEventIndicatorsPO eventIndicatorsPO = new UmcSupplierEventIndicatorsPO();
        eventIndicatorsPO.setEventIndicatorsId(reqBo.getEventIndicatorsId());
        eventIndicatorsPO.setRectify(reqBo.getRectify());
        int i = this.umcSupplierEventIndicatorsMapper.updateById(eventIndicatorsPO);
        if (i != 1) {
            throw new ZTBusinessException("\u4fee\u6539\u5931\u8d25");
        }
        UmcSupplierEventIndicatorsOperRspBo rspBo = new UmcSupplierEventIndicatorsOperRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @PostMapping(value={"deleteEventIndicators"})
    public UmcSupplierEventIndicatorsOperRspBo deleteEventIndicators(@RequestBody UmcSupplierEventIndicatorsOperReqBo reqBo) {
        this.check(reqBo, this.OPER_TYPE_DELETE);
        UmcSupplierEventCriteriaPO eventCriteriaPO = new UmcSupplierEventCriteriaPO();
        eventCriteriaPO.setEventIndicatorsId(reqBo.getEventIndicatorsId());
        this.umcSupplierEventCriteriaMapper.deleteBy(eventCriteriaPO);
        UmcSupplierEventIndicatorsPO eventIndicatorsPO = new UmcSupplierEventIndicatorsPO();
        eventIndicatorsPO.setEventIndicatorsId(reqBo.getEventIndicatorsId());
        this.umcSupplierEventIndicatorsMapper.deleteBy(eventIndicatorsPO);
        UmcSupplierEventIndicatorsOperRspBo rspBo = new UmcSupplierEventIndicatorsOperRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void check(UmcSupplierEventIndicatorsOperReqBo reqBo, Integer operType) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((this.OPER_TYPE_UPDATE.equals(operType) || this.OPER_TYPE_DELETE.equals(operType)) && reqBo.getEventIndicatorsId() == null) {
            throw new ZTBusinessException("\u4e8b\u4ef6\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.OPER_TYPE_UPDATE.equals(operType) && reqBo.getRectify() == null) {
            throw new ZTBusinessException("\u662f\u5426\u9700\u8981\u6574\u6539\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.OPER_TYPE_ADD.equals(operType)) {
            if (reqBo.getBusinessCompanyId() == null) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getEventIndicatorsCode())) {
                throw new ZTBusinessException("\u4e8b\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBo.getRectify() == null) {
                throw new ZTBusinessException("\u662f\u5426\u9700\u8981\u6574\u6539\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getApplicableScope())) {
                throw new ZTBusinessException("\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

