/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.transaction;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.transaction.api.ZsMdmCustomerMessageDealService;
import com.tydic.dyc.atom.transaction.bo.ZsMdmCustomerMessageBo;
import com.tydic.dyc.atom.transaction.bo.ZsMdmCustomerMessageDealReqBo;
import com.tydic.dyc.atom.transaction.bo.ZsMdmCustomerMessageDealRspBo;
import com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseRegisterBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.repository.dao.UmcSupplierIndustryMapper;
import com.tydic.dyc.umc.repository.po.UmcSupplierIndustryPO;
import com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.0.0/com.tydic.dyc.atom.transaction.api.ZsMdmCustomerMessageDealService"})
public class ZsMdmCustomerMessageDealServiceImpl
implements ZsMdmCustomerMessageDealService {
    @Autowired
    private AuthEnterpriseUserRegisterService authEnterpriseUserRegisterService;
    private final Long TENANT_ID = 10000L;
    private final Long MDM_CUSTOMER_PARENT_ID = 1184876571073191936L;
    @Autowired
    private UmcEnterpriseUserRegisterService umcEnterpriseUserRegisterService;
    private static final Integer ORG_DEEP = 4;
    @Autowired
    private UmcSupplierIndustryMapper umcSupplierIndustryMapper;

    @PostMapping(value={"dealMdmCustomerMessage"})
    public ZsMdmCustomerMessageDealRspBo dealMdmCustomerMessage(@RequestBody ZsMdmCustomerMessageDealReqBo reqBo) {
        AuthEnterpriseUserRegisterRspBo authEnterpriseUserRegisterRspBo = this.createOrgAuth(reqBo);
        this.createEnterpriseInfo(reqBo, authEnterpriseUserRegisterRspBo.getOrgInfoBo());
        this.createIndustryInfo(reqBo.getZsMdmCustomerMessageBo(), authEnterpriseUserRegisterRspBo.getOrgInfoBo());
        ZsMdmCustomerMessageDealRspBo rspBo = new ZsMdmCustomerMessageDealRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public void createEnterpriseInfo(ZsMdmCustomerMessageDealReqBo reqBo, AuthOrgInfoBo orgInfoBo) {
        Date now = new Date();
        UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo = this.buildEnterpriseInfo(reqBo.getZsMdmCustomerMessageBo(), orgInfoBo, now);
        this.createEnterprise(umcEnterpriseRegisterInfoBo);
    }

    private void createIndustryInfo(ZsMdmCustomerMessageBo reqBo, AuthOrgInfoBo orgInfoBo) {
        List supplierIndustryPOList = UmcRu.jsl((Object)reqBo.getCustomer_classification_code(), UmcSupplierIndustryPO.class);
        for (UmcSupplierIndustryPO supplierIndustryPO : supplierIndustryPOList) {
            supplierIndustryPO.setSupplierIndustryId(Long.valueOf(IdUtil.nextId()));
            supplierIndustryPO.setOrgId(orgInfoBo.getOrgId());
            supplierIndustryPO.setCreateTime(new Date());
        }
        this.umcSupplierIndustryMapper.insertBatch(supplierIndustryPOList);
    }

    private UmcEnterpriseRegisterInfoBo buildEnterpriseInfo(ZsMdmCustomerMessageBo reqBo, AuthOrgInfoBo orgInfoBo, Date now) {
        UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo = new UmcEnterpriseRegisterInfoBo();
        UmcOrgInfoBo umcOrgInfoBo = new UmcOrgInfoBo();
        umcOrgInfoBo.setOrgId(orgInfoBo.getOrgId());
        umcOrgInfoBo.setTenantId(this.TENANT_ID);
        umcOrgInfoBo.setOrgTreePath(orgInfoBo.getOrgTreePath());
        umcOrgInfoBo.setParentId(orgInfoBo.getParentId());
        umcEnterpriseRegisterInfoBo.setOrgClass("4");
        umcOrgInfoBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        umcOrgInfoBo.setCompanyId(orgInfoBo.getOrgId());
        umcOrgInfoBo.setExtOrgId(reqBo.getCustomer_code());
        umcOrgInfoBo.setExtOrgCode(reqBo.getCustomer_code());
        umcOrgInfoBo.setDeep(ORG_DEEP);
        umcOrgInfoBo.setOrgName(reqBo.getCustomer_name());
        umcOrgInfoBo.setIsVirtual("1");
        umcOrgInfoBo.setOrgStatus("1");
        umcOrgInfoBo.setCreateTime(now);
        ArrayList<UmcOrgTagRelBo> orgTagRelList = new ArrayList<UmcOrgTagRelBo>();
        UmcOrgTagRelBo umcOrgTagRelBo = new UmcOrgTagRelBo();
        umcOrgTagRelBo.setTagStatus("1");
        umcOrgTagRelBo.setOrgId(orgInfoBo.getOrgId());
        umcOrgTagRelBo.setTenantId(this.TENANT_ID);
        umcOrgTagRelBo.setTagId("1");
        umcOrgTagRelBo.setCreateTime(now);
        umcOrgTagRelBo.setEffTime(new Date());
        orgTagRelList.add(umcOrgTagRelBo);
        umcOrgInfoBo.setOrgTagRelList(orgTagRelList);
        umcEnterpriseRegisterInfoBo.setOrgId(orgInfoBo.getOrgId());
        umcEnterpriseRegisterInfoBo.setTenantId(this.TENANT_ID);
        umcEnterpriseRegisterInfoBo.setIsAbroad("0");
        umcEnterpriseRegisterInfoBo.setIsMerchant("1");
        umcEnterpriseRegisterInfoBo.setTelephone(reqBo.getCustomer_phone_number());
        umcEnterpriseRegisterInfoBo.setLegalPerson(reqBo.getCustomer_legal_person());
        umcEnterpriseRegisterInfoBo.setOrgCertificateCode(reqBo.getCustomer_unique_code());
        umcEnterpriseRegisterInfoBo.setCreditNo(reqBo.getCustomer_unique_code());
        umcEnterpriseRegisterInfoBo.setOrgInfoBo(umcOrgInfoBo);
        umcEnterpriseRegisterInfoBo.setCreateTime(now);
        return umcEnterpriseRegisterInfoBo;
    }

    private void createEnterprise(UmcEnterpriseRegisterInfoBo umcEnterpriseRegisterInfoBo) {
        UmcEnterpriseUserRegisterReqBo umcEnterpriseUserRegisterReqBo = new UmcEnterpriseUserRegisterReqBo();
        umcEnterpriseUserRegisterReqBo.setUmcEnterpriseRegisterInfoBo(umcEnterpriseRegisterInfoBo);
        UmcEnterpriseUserRegisterRspBo umcEnterpriseUserRegisterRspBo = this.umcEnterpriseUserRegisterService.dealEnterpriseCreate(umcEnterpriseUserRegisterReqBo);
        if (!"0000".equals(umcEnterpriseUserRegisterRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u4f1a\u5458\u4f01\u4e1a\u5931\u8d25\uff1a" + umcEnterpriseUserRegisterRspBo.getRespDesc());
        }
    }

    public AuthEnterpriseUserRegisterRspBo createOrgAuth(ZsMdmCustomerMessageDealReqBo reqBo) {
        AuthEnterpriseRegisterBo authEnterpriseRegisterBo = this.buildAuthOrgBo(reqBo.getZsMdmCustomerMessageBo());
        AuthEnterpriseUserRegisterReqBo authEnterpriseUserRegisterReqBo = new AuthEnterpriseUserRegisterReqBo();
        authEnterpriseUserRegisterReqBo.setAuthEnterpriseRegisterBo(authEnterpriseRegisterBo);
        AuthEnterpriseUserRegisterRspBo authEnterpriseUserRegisterRspBo = this.authEnterpriseUserRegisterService.dealEnterpriseCreate(authEnterpriseUserRegisterReqBo);
        if (!"0000".equals(authEnterpriseUserRegisterRspBo.getRespCode())) {
            throw new ZTBusinessException(authEnterpriseUserRegisterRspBo.getRespDesc());
        }
        return authEnterpriseUserRegisterRspBo;
    }

    private AuthEnterpriseRegisterBo buildAuthOrgBo(ZsMdmCustomerMessageBo reqBo) {
        AuthEnterpriseRegisterBo authEnterpriseRegisterBo = new AuthEnterpriseRegisterBo();
        authEnterpriseRegisterBo.setTenantId(this.TENANT_ID);
        authEnterpriseRegisterBo.setParentId(this.MDM_CUSTOMER_PARENT_ID);
        authEnterpriseRegisterBo.setExtOrgId(reqBo.getCustomer_code());
        authEnterpriseRegisterBo.setOrgName(reqBo.getCustomer_name());
        authEnterpriseRegisterBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        authEnterpriseRegisterBo.setIsVirtual("1");
        authEnterpriseRegisterBo.setOrgStatus("1");
        authEnterpriseRegisterBo.setCreateTime(new Date());
        ArrayList<AuthOrgTagRelBo> orgTagRelList = new ArrayList<AuthOrgTagRelBo>();
        AuthOrgTagRelBo authOrgTagRelBo = new AuthOrgTagRelBo();
        authOrgTagRelBo.setTagStatus("1");
        authOrgTagRelBo.setTagId(Convert.toLong((Object)"1"));
        authOrgTagRelBo.setCreateTime(new Date());
        orgTagRelList.add(authOrgTagRelBo);
        authEnterpriseRegisterBo.setOrgTagList(orgTagRelList);
        return authEnterpriseRegisterBo;
    }
}

