/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ANDJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "and";
    public static final String FIELD_AND_FILTERS = "andFilters";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("andFilters")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.emptySet();
    private static final long serialVersionUID = 6616759665873968672L;
    private volatile List<JSONObjectFilter> andFilters;

    public ANDJSONObjectFilter(JSONObjectFilter ... andFilters) {
        this(StaticUtils.toList(andFilters));
    }

    public ANDJSONObjectFilter(Collection<JSONObjectFilter> andFilters) {
        this.setANDFilters(andFilters);
    }

    public List<JSONObjectFilter> getANDFilters() {
        return this.andFilters;
    }

    public void setANDFilters(JSONObjectFilter ... andFilters) {
        this.setANDFilters(StaticUtils.toList(andFilters));
    }

    public void setANDFilters(Collection<JSONObjectFilter> andFilters) {
        this.andFilters = andFilters == null || andFilters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<JSONObjectFilter>(andFilters));
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        for (JSONObjectFilter f : this.andFilters) {
            if (f.matchesJSONObject(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(2));
        fields.put("filterType", new JSONString(FILTER_TYPE));
        ArrayList<JSONObject> filterValues = new ArrayList<JSONObject>(this.andFilters.size());
        for (JSONObjectFilter f : this.andFilters) {
            filterValues.add(f.toJSONObject());
        }
        fields.put(FIELD_AND_FILTERS, new JSONArray(filterValues));
        return new JSONObject(fields);
    }

    @Override
    protected ANDJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        return new ANDJSONObjectFilter(this.getFilters(filterObject, FIELD_AND_FILTERS));
    }
}

