/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1ObjectIdentifier;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.asn1.ASN1UTF8String;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CRLDistributionPointRevocationReason;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.GeneralNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CRLDistributionPoint
implements Serializable {
    private static final byte TYPE_DISTRIBUTION_POINT = -96;
    private static final byte TYPE_REASONS = -127;
    private static final byte TYPE_CRL_ISSUER = -94;
    private static final byte TYPE_FULL_NAME = -96;
    private static final byte TYPE_NAME_RELATIVE_TO_CRL_ISSUER = -95;
    private static final long serialVersionUID = -8461308509960278714L;
    private final GeneralNames crlIssuer;
    private final GeneralNames fullName;
    private final RDN nameRelativeToCRLIssuer;
    private final Set<CRLDistributionPointRevocationReason> revocationReasons;

    CRLDistributionPoint(GeneralNames fullName, Set<CRLDistributionPointRevocationReason> revocationReasons, GeneralNames crlIssuer) {
        this.fullName = fullName;
        this.crlIssuer = crlIssuer;
        this.nameRelativeToCRLIssuer = null;
        this.revocationReasons = revocationReasons == null ? Collections.unmodifiableSet(EnumSet.allOf(CRLDistributionPointRevocationReason.class)) : Collections.unmodifiableSet(revocationReasons);
    }

    CRLDistributionPoint(RDN nameRelativeToCRLIssuer, Set<CRLDistributionPointRevocationReason> revocationReasons, GeneralNames crlIssuer) {
        this.nameRelativeToCRLIssuer = nameRelativeToCRLIssuer;
        this.crlIssuer = crlIssuer;
        this.fullName = null;
        this.revocationReasons = revocationReasons == null ? Collections.unmodifiableSet(EnumSet.allOf(CRLDistributionPointRevocationReason.class)) : Collections.unmodifiableSet(revocationReasons);
    }

    CRLDistributionPoint(ASN1Element element) throws CertException {
        try {
            GeneralNames dpFullName = null;
            GeneralNames issuer = null;
            RDN dpRDN = null;
            Set<CRLDistributionPointRevocationReason> reasons = EnumSet.allOf(CRLDistributionPointRevocationReason.class);
            block12: for (ASN1Element e : element.decodeAsSequence().elements()) {
                switch (e.getType()) {
                    case -96: {
                        ASN1Element innerElement = ASN1Element.decode(e.getValue());
                        switch (innerElement.getType()) {
                            case -96: {
                                dpFullName = new GeneralNames(innerElement);
                                continue block12;
                            }
                            case -95: {
                                Schema schema = Schema.getDefaultStandardSchema();
                                ASN1Element[] attributeSetElements = innerElement.decodeAsSet().elements();
                                String[] attributeNames = new String[attributeSetElements.length];
                                byte[][] attributeValues = new byte[attributeSetElements.length][];
                                for (int j = 0; j < attributeSetElements.length; ++j) {
                                    ASN1Element[] attributeTypeAndValueElements = attributeSetElements[j].decodeAsSequence().elements();
                                    OID attributeTypeOID = attributeTypeAndValueElements[0].decodeAsObjectIdentifier().getOID();
                                    AttributeTypeDefinition attributeType = schema.getAttributeType(attributeTypeOID.toString());
                                    attributeNames[j] = attributeType == null ? attributeTypeOID.toString() : attributeType.getNameOrOID().toUpperCase();
                                    attributeValues[j] = attributeTypeAndValueElements[1].decodeAsOctetString().getValue();
                                }
                                dpRDN = new RDN(attributeNames, attributeValues, schema);
                                continue block12;
                            }
                        }
                        throw new CertException(CertMessages.ERR_CRL_DP_UNRECOGNIZED_NAME_ELEMENT_TYPE.get(StaticUtils.toHex(innerElement.getType())));
                    }
                    case -127: {
                        reasons = CRLDistributionPointRevocationReason.getReasonSet(e.decodeAsBitString());
                        continue block12;
                    }
                    case -94: {
                        issuer = new GeneralNames(e);
                    }
                }
            }
            this.fullName = dpFullName;
            this.nameRelativeToCRLIssuer = dpRDN;
            this.revocationReasons = Collections.unmodifiableSet(reasons);
            this.crlIssuer = issuer;
        }
        catch (CertException e) {
            Debug.debugException(e);
            throw e;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertException(CertMessages.ERR_CRL_DP_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    ASN1Element encode() throws CertException {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        ASN1Element distributionPointElement = null;
        if (this.fullName != null) {
            distributionPointElement = new ASN1Element(-96, this.fullName.encode().getValue());
        } else if (this.nameRelativeToCRLIssuer != null) {
            Schema schema;
            try {
                schema = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new CertException(CertMessages.ERR_CRL_DP_ENCODE_CANNOT_GET_SCHEMA.get(this.toString(), String.valueOf(this.nameRelativeToCRLIssuer), StaticUtils.getExceptionMessage(e)), e);
            }
            String[] names = this.nameRelativeToCRLIssuer.getAttributeNames();
            String[] values = this.nameRelativeToCRLIssuer.getAttributeValues();
            ArrayList<ASN1Sequence> rdnElements = new ArrayList<ASN1Sequence>(names.length);
            for (int i = 0; i < names.length; ++i) {
                AttributeTypeDefinition at = schema.getAttributeType(names[i]);
                if (at == null) {
                    throw new CertException(CertMessages.ERR_CRL_DP_ENCODE_UNKNOWN_ATTR_TYPE.get(this.toString(), String.valueOf(this.nameRelativeToCRLIssuer), names[i]));
                }
                try {
                    rdnElements.add(new ASN1Sequence(new ASN1ObjectIdentifier(at.getOID()), new ASN1UTF8String(values[i])));
                    continue;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new CertException(CertMessages.ERR_CRL_DP_ENCODE_ERROR.get(this.toString(), String.valueOf(this.nameRelativeToCRLIssuer), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            distributionPointElement = new ASN1Set(-95, rdnElements);
        }
        if (distributionPointElement != null) {
            elements.add(new ASN1Element(-96, distributionPointElement.encode()));
        }
        if (!this.revocationReasons.equals(EnumSet.allOf(CRLDistributionPointRevocationReason.class))) {
            elements.add(CRLDistributionPointRevocationReason.toBitString((byte)-127, this.revocationReasons));
        }
        if (this.crlIssuer != null) {
            elements.add(new ASN1Element(-94, this.crlIssuer.encode().getValue()));
        }
        return new ASN1Sequence(elements);
    }

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getNameRelativeToCRLIssuer() {
        return this.nameRelativeToCRLIssuer;
    }

    public Set<CRLDistributionPointRevocationReason> getPotentialRevocationReasons() {
        return this.revocationReasons;
    }

    public GeneralNames getCRLIssuer() {
        return this.crlIssuer;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("CRLDistributionPoint(");
        if (this.fullName != null) {
            buffer.append("fullName=");
            this.fullName.toString(buffer);
            buffer.append(", ");
        } else if (this.nameRelativeToCRLIssuer != null) {
            buffer.append("nameRelativeToCRLIssuer='");
            this.nameRelativeToCRLIssuer.toString(buffer);
            buffer.append("', ");
        }
        buffer.append("potentialRevocationReasons={");
        Iterator<CRLDistributionPointRevocationReason> reasonIterator = this.revocationReasons.iterator();
        while (reasonIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(reasonIterator.next().getName());
            buffer.append('\'');
            if (!reasonIterator.hasNext()) continue;
            buffer.append(',');
        }
        if (this.crlIssuer != null) {
            buffer.append(", crlIssuer=");
            this.crlIssuer.toString(buffer);
        }
        buffer.append('}');
    }
}

