/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.AbstractException;
import com.univocity.parsers.common.ParsingContext;

public class TextParsingException
extends AbstractException {
    private static final long serialVersionUID = 1410975527141918214L;
    private long lineIndex;
    private long charIndex;
    private long recordNumber;
    private int columnIndex;
    private String content;
    private String[] headers;
    protected int[] extractedIndexes;

    public TextParsingException(ParsingContext context, String message, Throwable cause) {
        super(message, cause);
        this.setContext(context);
    }

    protected void setContext(ParsingContext context) {
        this.lineIndex = context == null ? -1L : context.currentLine();
        this.charIndex = context == null ? 0L : context.currentChar();
        this.columnIndex = context == null ? -1 : context.currentColumn();
        this.recordNumber = context == null ? -1L : context.currentRecord();
        String string = this.content = context == null ? null : context.currentParsedContent();
        if (this.headers == null) {
            this.headers = context == null ? null : context.headers();
        }
        this.extractedIndexes = context == null ? null : context.extractedFieldIndexes();
    }

    public TextParsingException(ParsingContext context, String message) {
        this(context, message, null);
    }

    public TextParsingException(ParsingContext context, Throwable cause) {
        this(context, cause != null ? cause.getMessage() : null, cause);
    }

    public TextParsingException(ParsingContext context) {
        this(context, null, null);
    }

    @Override
    protected String getErrorDescription() {
        return "Error parsing input";
    }

    @Override
    protected String getDetails() {
        String details = "";
        details = TextParsingException.printIfNotEmpty(details, "line", this.lineIndex);
        details = TextParsingException.printIfNotEmpty(details, "column", this.columnIndex);
        details = TextParsingException.printIfNotEmpty(details, "record", this.recordNumber);
        details = TextParsingException.printIfNotEmpty(details, "charIndex", this.charIndex);
        details = TextParsingException.printIfNotEmpty(details, "headers", this.headers);
        details = TextParsingException.printIfNotEmpty(details, "content parsed", this.content);
        return details;
    }

    public long getRecordNumber() {
        return this.lineIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public long getLineIndex() {
        return this.lineIndex;
    }

    public long getCharIndex() {
        return this.charIndex;
    }

    public final String getParsedContent() {
        return this.content;
    }

    public final String[] getHeaders() {
        return this.headers;
    }
}

