/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.fields.FieldEnumSelector;
import com.univocity.parsers.common.fields.FieldNameSelector;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class AbstractConversionMapping<T> {
    private Map<FieldSelector, Conversion<String, ?>[]> conversionsMap;
    private final List<FieldSelector> conversionSequence;

    AbstractConversionMapping(List<FieldSelector> conversionSequence) {
        this.conversionSequence = conversionSequence;
    }

    public FieldSet<T> registerConversions(Conversion<String, ?> ... conversions) {
        ArgumentUtils.noNulls("Conversions", conversions);
        FieldSelector selector = this.newFieldSelector();
        if (this.conversionsMap == null) {
            this.conversionsMap = new LinkedHashMap<FieldSelector, Conversion<String, ?>[]>();
        }
        this.conversionsMap.put(selector, conversions);
        this.conversionSequence.add(selector);
        if (selector instanceof FieldSet) {
            return (FieldSet)((Object)selector);
        }
        return null;
    }

    protected abstract FieldSelector newFieldSelector();

    public void prepareExecution(boolean writing, FieldSelector selector, Map<Integer, List<Conversion<?, ?>>> conversionsByIndex, String[] values) {
        int[] fieldIndexes;
        if (this.conversionsMap == null) {
            return;
        }
        Conversion<String, ?>[] conversions = this.conversionsMap.get(selector);
        if (conversions == null) {
            return;
        }
        if (!(writing || values != null && this.conversionsMap.size() <= values.length)) {
            boolean isSelectionOfNames = true;
            for (FieldSelector expectedSelection : this.conversionsMap.keySet()) {
                if (expectedSelection instanceof FieldNameSelector || expectedSelection instanceof FieldEnumSelector) continue;
                isSelectionOfNames = false;
                break;
            }
            if (isSelectionOfNames && values != null) {
                int i = values.length;
                values = Arrays.copyOf(values, this.conversionsMap.size() + 1);
                for (FieldSelector expectedSelection : this.conversionsMap.keySet()) {
                    String selected;
                    List selection = ((FieldSet)((Object)expectedSelection)).get();
                    if (selection.size() != 1 || ArgumentUtils.indexOf(values, selected = ArgumentUtils.normalize(selection.get(0).toString())) != -1) continue;
                    values[i++] = selected;
                    if (i != values.length) continue;
                    break;
                }
            }
        }
        if ((fieldIndexes = selector.getFieldIndexes(values)) == null) {
            fieldIndexes = ArgumentUtils.toIntArray(conversionsByIndex.keySet());
        }
        for (int fieldIndex : fieldIndexes) {
            List<Conversion<?, ?>> conversionsAtIndex = conversionsByIndex.get(fieldIndex);
            if (conversionsAtIndex == null) {
                conversionsAtIndex = new ArrayList();
                conversionsByIndex.put(fieldIndex, conversionsAtIndex);
            }
            AbstractConversionMapping.validateDuplicates(selector, conversionsAtIndex, conversions);
            conversionsAtIndex.addAll(Arrays.asList(conversions));
        }
    }

    private static void validateDuplicates(FieldSelector selector, List<Conversion<?, ?>> conversionsAtIndex, Conversion<?, ?>[] conversionsToAdd) {
        for (Conversion<?, ?> toAdd : conversionsToAdd) {
            for (Conversion<?, ?> existing : conversionsAtIndex) {
                if (toAdd != existing) continue;
                throw new DataProcessingException("Duplicate conversion " + toAdd.getClass().getName() + " being applied to " + selector.describe());
            }
        }
    }

    public boolean isEmpty() {
        return this.conversionsMap == null || this.conversionsMap.isEmpty();
    }
}

