/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ConversionProcessor;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.common.processor.BeanProcessor;
import com.univocity.parsers.common.processor.RowProcessor;
import com.univocity.parsers.conversions.Conversion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class MultiBeanProcessor
implements RowProcessor,
ConversionProcessor {
    private final BeanProcessor[] beanProcessors;
    private final Map<Class, BeanProcessor> processorMap = new HashMap<Class, BeanProcessor>();

    public MultiBeanProcessor(Class ... beanTypes) {
        ArgumentUtils.noNulls("Bean types", beanTypes);
        this.beanProcessors = new BeanProcessor[beanTypes.length];
        for (int i = 0; i < beanTypes.length; ++i) {
            final Class type = beanTypes[i];
            this.beanProcessors[i] = new BeanProcessor(type){

                public void beanProcessed(Object bean, ParsingContext context) {
                    MultiBeanProcessor.this.beanProcessed(type, bean, context);
                }
            };
            this.processorMap.put(type, this.beanProcessors[i]);
        }
    }

    public <T> BeanProcessor<T> getProcessorOfType(Class<T> type) {
        BeanProcessor processor = this.processorMap.get(type);
        if (processor == null) {
            throw new IllegalArgumentException("No processor of type '" + type.getName() + "' is available. Supported types are: " + this.processorMap.keySet());
        }
        return processor;
    }

    public abstract void beanProcessed(Class<?> var1, Object var2, ParsingContext var3);

    @Override
    public void processStarted(ParsingContext context) {
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            this.beanProcessors[i].processStarted(context);
        }
    }

    @Override
    public final void rowProcessed(String[] row, ParsingContext context) {
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            this.beanProcessors[i].rowProcessed(row, context);
        }
    }

    @Override
    public void processEnded(ParsingContext context) {
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            this.beanProcessors[i].processEnded(context);
        }
    }

    @Override
    public FieldSet<Integer> convertIndexes(Conversion ... conversions) {
        ArrayList sets = new ArrayList(this.beanProcessors.length);
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            sets.add(this.beanProcessors[i].convertIndexes(conversions));
        }
        return new FieldSet<Integer>(sets);
    }

    @Override
    public void convertAll(Conversion ... conversions) {
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            this.beanProcessors[i].convertAll(conversions);
        }
    }

    @Override
    public FieldSet<String> convertFields(Conversion ... conversions) {
        ArrayList sets = new ArrayList(this.beanProcessors.length);
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            sets.add(this.beanProcessors[i].convertFields(conversions));
        }
        return new FieldSet<String>(sets);
    }

    @Override
    public void convertType(Class<?> type, Conversion ... conversions) {
        for (int i = 0; i < this.beanProcessors.length; ++i) {
            this.beanProcessors[i].convertType(type, conversions);
        }
    }
}

