/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.exception;

import com.weibo.api.motan.exception.MotanErrorMsg;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.rpc.RpcContext;

public abstract class MotanAbstractException
extends RuntimeException {
    private static final long serialVersionUID = -8742311167276890503L;
    protected MotanErrorMsg motanErrorMsg = MotanErrorMsgConstant.FRAMEWORK_DEFAULT_ERROR;
    protected String errorMsg = null;

    public MotanAbstractException() {
    }

    public MotanAbstractException(MotanErrorMsg motanErrorMsg) {
        this.motanErrorMsg = motanErrorMsg;
    }

    public MotanAbstractException(String message) {
        this(message, (MotanErrorMsg)null);
    }

    public MotanAbstractException(String message, MotanErrorMsg motanErrorMsg) {
        super(message);
        this.motanErrorMsg = motanErrorMsg;
        this.errorMsg = message;
    }

    public MotanAbstractException(String message, MotanErrorMsg motanErrorMsg, boolean writableStackTrace) {
        this(message, null, motanErrorMsg, writableStackTrace);
    }

    public MotanAbstractException(String message, Throwable cause, MotanErrorMsg motanErrorMsg, boolean writableStackTrace) {
        super(message, cause, false, writableStackTrace);
        this.motanErrorMsg = motanErrorMsg;
        this.errorMsg = message;
    }

    public MotanAbstractException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public MotanAbstractException(String message, Throwable cause, MotanErrorMsg motanErrorMsg) {
        super(message, cause);
        this.motanErrorMsg = motanErrorMsg;
        this.errorMsg = message;
    }

    public MotanAbstractException(Throwable cause) {
        super(cause);
    }

    public MotanAbstractException(Throwable cause, MotanErrorMsg motanErrorMsg) {
        super(cause);
        this.motanErrorMsg = motanErrorMsg;
    }

    @Override
    public String getMessage() {
        String message = this.getOriginMessage();
        return "error_message: " + message + ", status: " + this.motanErrorMsg.getStatus() + ", error_code: " + this.motanErrorMsg.getErrorCode() + ",r=" + RpcContext.getContext().getRequestId();
    }

    public String getOriginMessage() {
        if (this.motanErrorMsg == null) {
            return super.getMessage();
        }
        String message = this.errorMsg != null && !"".equals(this.errorMsg) ? this.errorMsg : this.motanErrorMsg.getMessage();
        return message;
    }

    public int getStatus() {
        return this.motanErrorMsg != null ? this.motanErrorMsg.getStatus() : 0;
    }

    public int getErrorCode() {
        return this.motanErrorMsg != null ? this.motanErrorMsg.getErrorCode() : 0;
    }

    public MotanErrorMsg getMotanErrorMsg() {
        return this.motanErrorMsg;
    }
}

