/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.proxy;

import com.weibo.api.motan.cluster.Cluster;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponseFuture;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.RpcContext;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.switcher.Switcher;
import com.weibo.api.motan.switcher.SwitcherService;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AbstractRefererHandler<T> {
    protected List<Cluster<T>> clusters;
    protected Class<T> clz;
    protected SwitcherService switcherService = null;
    protected String interfaceName;

    void init() {
        String switchName = this.clusters.get(0).getUrl().getParameter(URLParamType.switcherService.getName(), URLParamType.switcherService.getValue());
        this.switcherService = ExtensionLoader.getExtensionLoader(SwitcherService.class).getExtension(switchName);
    }

    Object invokeRequest(Request request, Class returnType, boolean async) throws Throwable {
        RpcContext curContext = RpcContext.getContext();
        curContext.putAttribute("Async", async);
        Map<String, String> attachments = curContext.getRpcAttachments();
        if (!attachments.isEmpty()) {
            for (Map.Entry<String, String> entry : attachments.entrySet()) {
                request.setAttachment(entry.getKey(), entry.getValue());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)curContext.getClientRequestId())) {
            request.setAttachment(URLParamType.requestIdFromClient.getName(), curContext.getClientRequestId());
        }
        for (Cluster cluster : this.clusters) {
            String protocolSwitcher = "protocol:" + cluster.getUrl().getProtocol();
            Switcher switcher = this.switcherService.getSwitcher(protocolSwitcher);
            if (switcher != null && !switcher.isOn()) continue;
            request.setAttachment(URLParamType.version.getName(), cluster.getUrl().getVersion());
            request.setAttachment(URLParamType.clientGroup.getName(), cluster.getUrl().getGroup());
            request.setAttachment(URLParamType.application.getName(), cluster.getUrl().getApplication());
            request.setAttachment(URLParamType.module.getName(), cluster.getUrl().getModule());
            Response response = null;
            boolean throwException = Boolean.parseBoolean(cluster.getUrl().getParameter(URLParamType.throwException.getName(), URLParamType.throwException.getValue()));
            try {
                MotanFrameworkUtil.logEvent(request, "TRACE_INVOKE");
                response = cluster.call(request);
                if (async) {
                    if (response instanceof ResponseFuture) {
                        ((ResponseFuture)response).setReturnType(returnType);
                        return response;
                    }
                    DefaultResponseFuture responseFuture = new DefaultResponseFuture(request, 0, cluster.getUrl());
                    if (response.getException() != null) {
                        responseFuture.onFailure(response);
                    } else {
                        responseFuture.onSuccess(response);
                    }
                    responseFuture.setReturnType(returnType);
                    return responseFuture;
                }
                Object value = response.getValue();
                if (value != null && value instanceof DeserializableObject) {
                    try {
                        value = ((DeserializableObject)value).deserialize(returnType);
                    }
                    catch (IOException e) {
                        LoggerUtil.error("deserialize response value fail! deserialize type:" + returnType, e);
                        throw new MotanFrameworkException("deserialize return value fail! deserialize type:" + returnType, e);
                    }
                }
                return value;
            }
            catch (RuntimeException e) {
                if (ExceptionUtil.isBizException(e)) {
                    Throwable t = e.getCause();
                    if (t != null && t instanceof Exception) {
                        throw t;
                    }
                    String msg = t == null ? "biz exception cause is null. origin error msg : " + e.getMessage() : "biz exception cause is throwable error:" + t.getClass() + ", errmsg:" + t.getMessage();
                    throw new MotanServiceException(msg);
                }
                if (!throwException) {
                    LoggerUtil.warn("RefererInvocationHandler invoke false, so return default value: uri=" + cluster.getUrl().getUri() + " " + MotanFrameworkUtil.toString(request), e);
                    return this.getDefaultReturnValue(returnType);
                }
                LoggerUtil.error("RefererInvocationHandler invoke Error: uri=" + cluster.getUrl().getUri() + " " + MotanFrameworkUtil.toString(request), e);
                throw e;
            }
        }
        throw new MotanServiceException("Referer call Error: cluster not exist, interface=" + this.interfaceName + " " + MotanFrameworkUtil.toString(request), MotanErrorMsgConstant.SERVICE_UNFOUND, false);
    }

    private Object getDefaultReturnValue(Class<?> returnType) {
        if (returnType != null && returnType.isPrimitive()) {
            return PrimitiveDefault.getDefaultReturnValue(returnType);
        }
        return null;
    }

    private static class PrimitiveDefault {
        private static boolean defaultBoolean;
        private static char defaultChar;
        private static byte defaultByte;
        private static short defaultShort;
        private static int defaultInt;
        private static long defaultLong;
        private static float defaultFloat;
        private static double defaultDouble;
        private static Map<Class<?>, Object> primitiveValues;

        private PrimitiveDefault() {
        }

        public static Object getDefaultReturnValue(Class<?> returnType) {
            return primitiveValues.get(returnType);
        }

        static {
            primitiveValues = new HashMap();
            primitiveValues.put(Boolean.TYPE, defaultBoolean);
            primitiveValues.put(Character.TYPE, Character.valueOf(defaultChar));
            primitiveValues.put(Byte.TYPE, defaultByte);
            primitiveValues.put(Short.TYPE, defaultShort);
            primitiveValues.put(Integer.TYPE, defaultInt);
            primitiveValues.put(Long.TYPE, defaultLong);
            primitiveValues.put(Float.TYPE, Float.valueOf(defaultFloat));
            primitiveValues.put(Double.TYPE, defaultDouble);
        }
    }
}

