/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.http.support.HttpHeader;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthResponse;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.Base64Utils;
import com.xingyuv.jushauth.utils.GlobalAuthUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import com.xingyuv.jushauth.utils.UuidUtils;
import java.util.HashMap;

public class AuthElemeRequest
extends AuthDefaultRequest {
    private static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded;charset=UTF-8";
    private static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";

    public AuthElemeRequest(AuthConfig config) {
        super(config, AuthDefaultSource.ELEME);
    }

    public AuthElemeRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.ELEME, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.config.getClientId());
        form.put("redirect_uri", this.config.getRedirectUri());
        form.put("code", authCallback.getCode());
        form.put("grant_type", "authorization_code");
        HttpHeader httpHeader = this.buildHeader(CONTENT_TYPE_FORM, this.getRequestId(), true);
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), form, httpHeader, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        String action = "eleme.user.getUser";
        long timestamp = System.currentTimeMillis();
        HashMap<String, Object> metasHashMap = new HashMap<String, Object>(4);
        metasHashMap.put("app_key", this.config.getClientId());
        metasHashMap.put("timestamp", timestamp);
        String signature = GlobalAuthUtils.generateElemeSignature(this.config.getClientId(), this.config.getClientSecret(), timestamp, action, authToken.getAccessToken(), parameters);
        String requestId = this.getRequestId();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        paramsMap.put("nop", "1.0.0");
        paramsMap.put("id", requestId);
        paramsMap.put("action", action);
        paramsMap.put("token", authToken.getAccessToken());
        paramsMap.put("metas", metasHashMap);
        paramsMap.put("params", parameters);
        paramsMap.put("signature", signature);
        HttpHeader httpHeader = this.buildHeader(CONTENT_TYPE_JSON, requestId, false);
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.userInfo(), JSONObject.toJSONString(paramsMap), httpHeader).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"name")) {
            throw new AuthException(object.getString("message"));
        }
        if (object.containsKey((Object)"error") && null != object.get((Object)"error")) {
            throw new AuthException(object.getJSONObject("error").getString("message"));
        }
        JSONObject result = object.getJSONObject("result");
        return AuthUser.builder().rawUserInfo(result).uuid(result.getString("userId")).username(result.getString("userName")).nickname(result.getString("userName")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        HashMap<String, String> form = new HashMap<String, String>(4);
        form.put("refresh_token", oldToken.getRefreshToken());
        form.put("grant_type", "refresh_token");
        HttpHeader httpHeader = this.buildHeader(CONTENT_TYPE_FORM, this.getRequestId(), true);
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.refresh(), form, httpHeader, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).build()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", "all").build();
    }

    private String getBasic(String appKey, String appSecret) {
        StringBuilder sb = new StringBuilder();
        String encodeToString = Base64Utils.encode((appKey + ":" + appSecret).getBytes());
        sb.append("Basic").append(" ").append(encodeToString);
        return sb.toString();
    }

    private HttpHeader buildHeader(String contentType, String requestId, boolean auth) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Accept", "text/xml,text/javascript,text/html");
        httpHeader.add("Content-Type", contentType);
        httpHeader.add("Accept-Encoding", "gzip");
        httpHeader.add("User-Agent", "eleme-openapi-java-sdk");
        httpHeader.add("x-eleme-requestid", requestId);
        if (auth) {
            httpHeader.add("Authorization", this.getBasic(this.config.getClientId(), this.config.getClientSecret()));
        }
        return httpHeader;
    }

    private String getRequestId() {
        return (UuidUtils.getUUID() + "|" + System.currentTimeMillis()).toUpperCase();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }
}

