/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.enums.scope.AuthHuaweiScope;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthResponse;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.AuthScopeUtils;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import java.util.HashMap;

public class AuthHuaweiRequest
extends AuthDefaultRequest {
    public AuthHuaweiRequest(AuthConfig config) {
        super(config, AuthDefaultSource.HUAWEI);
    }

    public AuthHuaweiRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.HUAWEI, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> form = new HashMap<String, String>(8);
        form.put("grant_type", "authorization_code");
        form.put("code", authCallback.getAuthorization_code());
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        form.put("redirect_uri", this.config.getRedirectUri());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), form, false).getBody();
        return this.getAuthToken(response);
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("nsp_ts", "" + System.currentTimeMillis());
        form.put("access_token", authToken.getAccessToken());
        form.put("nsp_fmt", "JS");
        form.put("nsp_svc", "OpenUP.User.getInfo");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.userInfo(), form, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        AuthUserGender gender = this.getRealGender(object);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("userID")).username(object.getString("userName")).nickname(object.getString("userName")).gender(gender).avatar(object.getString("headPictureURL")).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("grant_type", "refresh_token");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.refresh(), form, false).getBody();
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    private AuthToken getAuthToken(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthHuaweiScope.values()))).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("nsp_ts", System.currentTimeMillis()).queryParam("access_token", authToken.getAccessToken()).queryParam("nsp_fmt", "JS").queryParam("nsp_svc", "OpenUP.User.getInfo").build();
    }

    private AuthUserGender getRealGender(JSONObject object) {
        int genderCodeInt = object.getIntValue("gender");
        String genderCode = genderCodeInt == 1 ? "0" : (genderCodeInt == 0 ? "1" : "" + genderCodeInt);
        return AuthUserGender.getRealGender(genderCode);
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"NSP_STATUS")) {
            throw new AuthException(object.getString("error"));
        }
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("sub_error") + ":" + object.getString("error_description"));
        }
    }
}

