/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthResponse;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;

public class AuthWeChatOpenRequest
extends AuthDefaultRequest {
    public AuthWeChatOpenRequest(AuthConfig config) {
        super(config, AuthDefaultSource.WECHAT_OPEN);
    }

    public AuthWeChatOpenRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.WECHAT_OPEN, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String openId = authToken.getOpenId();
        String response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        String location = String.format("%s-%s-%s", object.getString("country"), object.getString("province"), object.getString("city"));
        if (object.containsKey((Object)"unionid")) {
            authToken.setUnionId(object.getString("unionid"));
        }
        return AuthUser.builder().rawUserInfo(object).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("headimgurl")).location(location).uuid(openId).gender(AuthUserGender.getWechatRealGender(object.getString("sex"))).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(oldToken.getRefreshToken()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new AuthException(object.getIntValue("errcode"), object.getString("errmsg"));
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(accessTokenUrl).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).openId(accessTokenObject.getString("openid")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "snsapi_login").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("appid", this.config.getClientId()).queryParam("secret", this.config.getClientSecret()).queryParam("grant_type", "authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("openid", authToken.getOpenId()).queryParam("lang", "zh_CN").build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl(this.source.refresh()).queryParam("appid", this.config.getClientId()).queryParam("refresh_token", refreshToken).queryParam("grant_type", "refresh_token").build();
    }
}

