/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.executor.sample.frameless.jobhandler;

import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleXxlJob {
    private static Logger logger = LoggerFactory.getLogger(SampleXxlJob.class);

    @XxlJob(value="demoJobHandler")
    public void demoJobHandler() throws Exception {
        XxlJobHelper.log((String)"XXL-JOB, Hello World.", (Object[])new Object[0]);
        for (int i = 0; i < 5; ++i) {
            XxlJobHelper.log((String)("beat at:" + i), (Object[])new Object[0]);
            TimeUnit.SECONDS.sleep(2L);
        }
    }

    @XxlJob(value="shardingJobHandler")
    public void shardingJobHandler() throws Exception {
        int shardIndex = XxlJobHelper.getShardIndex();
        int shardTotal = XxlJobHelper.getShardTotal();
        XxlJobHelper.log((String)"\u5206\u7247\u53c2\u6570\uff1a\u5f53\u524d\u5206\u7247\u5e8f\u53f7 = {}, \u603b\u5206\u7247\u6570 = {}", (Object[])new Object[]{shardIndex, shardTotal});
        for (int i = 0; i < shardTotal; ++i) {
            if (i == shardIndex) {
                XxlJobHelper.log((String)"\u7b2c {} \u7247, \u547d\u4e2d\u5206\u7247\u5f00\u59cb\u5904\u7406", (Object[])new Object[]{i});
                continue;
            }
            XxlJobHelper.log((String)"\u7b2c {} \u7247, \u5ffd\u7565", (Object[])new Object[]{i});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="commandJobHandler")
    public void commandJobHandler() throws Exception {
        String command = XxlJobHelper.getJobParam();
        int exitValue = -1;
        try (BufferedReader bufferedReader = null;){
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(command);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
            while ((line = bufferedReader.readLine()) != null) {
                XxlJobHelper.log((String)line, (Object[])new Object[0]);
            }
            process.waitFor();
            exitValue = process.exitValue();
        }
        if (exitValue != 0) {
            XxlJobHelper.handleFail((String)("command exit value(" + exitValue + ") is failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="httpJobHandler")
    public void httpJobHandler() throws Exception {
        String param = XxlJobHelper.getJobParam();
        if (param == null || param.trim().length() == 0) {
            XxlJobHelper.log((String)("param[" + param + "] invalid."), (Object[])new Object[0]);
            XxlJobHelper.handleFail();
            return;
        }
        String[] httpParams = param.split("\n");
        String url = null;
        String method = null;
        String data = null;
        for (String httpParam : httpParams) {
            if (httpParam.startsWith("url:")) {
                url = httpParam.substring(httpParam.indexOf("url:") + 4).trim();
            }
            if (httpParam.startsWith("method:")) {
                method = httpParam.substring(httpParam.indexOf("method:") + 7).trim().toUpperCase();
            }
            if (!httpParam.startsWith("data:")) continue;
            data = httpParam.substring(httpParam.indexOf("data:") + 5).trim();
        }
        if (url == null || url.trim().length() == 0) {
            XxlJobHelper.log((String)("url[" + url + "] invalid."), (Object[])new Object[0]);
            XxlJobHelper.handleFail();
            return;
        }
        if (method == null || !Arrays.asList("GET", "POST").contains(method)) {
            XxlJobHelper.log((String)("method[" + method + "] invalid."), (Object[])new Object[0]);
            XxlJobHelper.handleFail();
            return;
        }
        boolean isPostMethod = method.equals("POST");
        HttpURLConnection connection = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            int statusCode;
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod(method);
            connection.setDoOutput(isPostMethod);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(3000);
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestProperty("Accept-Charset", "application/json;charset=UTF-8");
            connection.connect();
            if (isPostMethod && data != null && data.trim().length() > 0) {
                DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                dataOutputStream.write(data.getBytes("UTF-8"));
                dataOutputStream.flush();
                dataOutputStream.close();
            }
            if ((statusCode = connection.getResponseCode()) != 200) {
                throw new RuntimeException("Http Request StatusCode(" + statusCode + ") Invalid.");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder result = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line);
            }
            String responseMsg = result.toString();
            XxlJobHelper.log((String)responseMsg, (Object[])new Object[0]);
            return;
        }
        catch (Exception e) {
            XxlJobHelper.log((Throwable)e);
            XxlJobHelper.handleFail();
            return;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                XxlJobHelper.log((Throwable)e2);
            }
        }
    }

    @XxlJob(value="demoJobHandler2", init="init", destroy="destroy")
    public void demoJobHandler2() throws Exception {
        XxlJobHelper.log((String)"XXL-JOB, Hello World.", (Object[])new Object[0]);
    }

    public void init() {
        logger.info("init");
    }

    public void destroy() {
        logger.info("destory");
    }
}

