/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.filter;

import com.xxl.sso.core.conf.Conf;
import com.xxl.sso.core.login.SsoWebLoginHelper;
import com.xxl.sso.core.path.impl.AntPathMatcher;
import com.xxl.sso.core.user.XxlSsoUser;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlSsoWebFilter
extends HttpServlet
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(XxlSsoWebFilter.class);
    private static final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private String ssoServer;
    private String logoutPath;
    private String excludedPaths;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.ssoServer = filterConfig.getInitParameter("sso_server");
        this.logoutPath = filterConfig.getInitParameter("SSO_LOGOUT_PATH");
        this.excludedPaths = filterConfig.getInitParameter("SSO_EXCLUDED_PATHS");
        logger.info("XxlSsoWebFilter init.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String servletPath = req.getServletPath();
        if (this.excludedPaths != null && this.excludedPaths.trim().length() > 0) {
            for (String excludedPath : this.excludedPaths.split(",")) {
                String uriPattern = excludedPath.trim();
                if (!antPathMatcher.match(uriPattern, servletPath)) continue;
                chain.doFilter(request, response);
                return;
            }
        }
        if (this.logoutPath != null && this.logoutPath.trim().length() > 0 && this.logoutPath.equals(servletPath)) {
            SsoWebLoginHelper.removeSessionIdByCookie(req, res);
            String logoutPageUrl = this.ssoServer.concat("/logout");
            res.sendRedirect(logoutPageUrl);
            return;
        }
        XxlSsoUser xxlUser = SsoWebLoginHelper.loginCheck(req, res);
        if (xxlUser == null) {
            boolean isJson;
            String header = req.getHeader("content-type");
            boolean bl = isJson = header != null && header.contains("json");
            if (isJson) {
                res.setContentType("application/json;charset=utf-8");
                res.getWriter().println("{\"code\":" + Conf.SSO_LOGIN_FAIL_RESULT.getCode() + ", \"msg\":\"" + Conf.SSO_LOGIN_FAIL_RESULT.getMsg() + "\"}");
                return;
            }
            String link = req.getRequestURL().toString();
            String loginPageUrl = this.ssoServer.concat("/login") + "?" + "redirect_url" + "=" + link;
            res.sendRedirect(loginPageUrl);
            return;
        }
        request.setAttribute("xxl_sso_user", (Object)xxlUser);
        chain.doFilter(request, response);
    }
}

