/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.login;

import com.xxl.sso.core.store.SsoLoginStore;
import com.xxl.sso.core.store.SsoSessionIdHelper;
import com.xxl.sso.core.user.XxlSsoUser;
import javax.servlet.http.HttpServletRequest;

public class SsoTokenLoginHelper {
    public static void login(String sessionId, XxlSsoUser xxlUser) {
        String storeKey = SsoSessionIdHelper.parseStoreKey(sessionId);
        if (storeKey == null) {
            throw new RuntimeException("parseStoreKey Fail, sessionId:" + sessionId);
        }
        SsoLoginStore.put(storeKey, xxlUser);
    }

    public static void logout(String sessionId) {
        String storeKey = SsoSessionIdHelper.parseStoreKey(sessionId);
        if (storeKey == null) {
            return;
        }
        SsoLoginStore.remove(storeKey);
    }

    public static void logout(HttpServletRequest request) {
        String headerSessionId = request.getHeader("xxl_sso_sessionid");
        SsoTokenLoginHelper.logout(headerSessionId);
    }

    public static XxlSsoUser loginCheck(String sessionId) {
        String storeKey = SsoSessionIdHelper.parseStoreKey(sessionId);
        if (storeKey == null) {
            return null;
        }
        XxlSsoUser xxlUser = SsoLoginStore.get(storeKey);
        if (xxlUser != null) {
            String version = SsoSessionIdHelper.parseVersion(sessionId);
            if (xxlUser.getVersion().equals(version)) {
                if (System.currentTimeMillis() - xxlUser.getExpireFreshTime() > (long)(xxlUser.getExpireMinite() / 2)) {
                    xxlUser.setExpireFreshTime(System.currentTimeMillis());
                    SsoLoginStore.put(storeKey, xxlUser);
                }
                return xxlUser;
            }
        }
        return null;
    }

    public static XxlSsoUser loginCheck(HttpServletRequest request) {
        String headerSessionId = request.getHeader("xxl_sso_sessionid");
        return SsoTokenLoginHelper.loginCheck(headerSessionId);
    }
}

