/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.login;

import com.xxl.sso.core.login.SsoTokenLoginHelper;
import com.xxl.sso.core.store.SsoLoginStore;
import com.xxl.sso.core.store.SsoSessionIdHelper;
import com.xxl.sso.core.user.XxlSsoUser;
import com.xxl.sso.core.util.CookieUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SsoWebLoginHelper {
    public static void login(HttpServletResponse response, String sessionId, XxlSsoUser xxlUser, boolean ifRemember) {
        String storeKey = SsoSessionIdHelper.parseStoreKey(sessionId);
        if (storeKey == null) {
            throw new RuntimeException("parseStoreKey Fail, sessionId:" + sessionId);
        }
        SsoLoginStore.put(storeKey, xxlUser);
        CookieUtil.set(response, "xxl_sso_sessionid", sessionId, ifRemember);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        String cookieSessionId = CookieUtil.getValue(request, "xxl_sso_sessionid");
        if (cookieSessionId == null) {
            return;
        }
        String storeKey = SsoSessionIdHelper.parseStoreKey(cookieSessionId);
        if (storeKey != null) {
            SsoLoginStore.remove(storeKey);
        }
        CookieUtil.remove(request, response, "xxl_sso_sessionid");
    }

    public static XxlSsoUser loginCheck(HttpServletRequest request, HttpServletResponse response) {
        String cookieSessionId = CookieUtil.getValue(request, "xxl_sso_sessionid");
        XxlSsoUser xxlUser = SsoTokenLoginHelper.loginCheck(cookieSessionId);
        if (xxlUser != null) {
            return xxlUser;
        }
        SsoWebLoginHelper.removeSessionIdByCookie(request, response);
        String paramSessionId = request.getParameter("xxl_sso_sessionid");
        xxlUser = SsoTokenLoginHelper.loginCheck(paramSessionId);
        if (xxlUser != null) {
            CookieUtil.set(response, "xxl_sso_sessionid", paramSessionId, false);
            return xxlUser;
        }
        return null;
    }

    public static void removeSessionIdByCookie(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.remove(request, response, "xxl_sso_sessionid");
    }

    public static String getSessionIdByCookie(HttpServletRequest request) {
        String cookieSessionId = CookieUtil.getValue(request, "xxl_sso_sessionid");
        return cookieSessionId;
    }
}

