/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.store;

import com.xxl.sso.core.user.XxlSsoUser;
import com.xxl.sso.core.util.JedisUtil;

public class SsoLoginStore {
    private static int redisExpireMinite = 1440;

    public static void setRedisExpireMinite(int redisExpireMinite) {
        if (redisExpireMinite < 30) {
            redisExpireMinite = 30;
        }
        SsoLoginStore.redisExpireMinite = redisExpireMinite;
    }

    public static int getRedisExpireMinite() {
        return redisExpireMinite;
    }

    public static XxlSsoUser get(String storeKey) {
        String redisKey = SsoLoginStore.redisKey(storeKey);
        Object objectValue = JedisUtil.getObjectValue(redisKey);
        if (objectValue != null) {
            XxlSsoUser xxlUser = (XxlSsoUser)objectValue;
            return xxlUser;
        }
        return null;
    }

    public static void remove(String storeKey) {
        String redisKey = SsoLoginStore.redisKey(storeKey);
        JedisUtil.del(redisKey);
    }

    public static void put(String storeKey, XxlSsoUser xxlUser) {
        String redisKey = SsoLoginStore.redisKey(storeKey);
        JedisUtil.setObjectValue(redisKey, xxlUser, redisExpireMinite * 60);
    }

    private static String redisKey(String sessionId) {
        return "xxl_sso_sessionid".concat("#").concat(sessionId);
    }
}

