/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class JedisUtil {
    private static Logger logger = LoggerFactory.getLogger(JedisUtil.class);
    private static String address;
    private static ShardedJedisPool shardedJedisPool;
    private static ReentrantLock INSTANCE_INIT_LOCL;

    public static void init(String address) {
        JedisUtil.address = address;
        JedisUtil.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShardedJedis getInstance() {
        block9: {
            if (shardedJedisPool == null) {
                try {
                    if (!INSTANCE_INIT_LOCL.tryLock(2L, TimeUnit.SECONDS)) break block9;
                    try {
                        if (shardedJedisPool == null) {
                            JedisPoolConfig config = new JedisPoolConfig();
                            config.setMaxTotal(200);
                            config.setMaxIdle(50);
                            config.setMinIdle(8);
                            config.setMaxWaitMillis(10000L);
                            config.setTestOnBorrow(true);
                            config.setTestOnReturn(false);
                            config.setTestWhileIdle(true);
                            config.setTimeBetweenEvictionRunsMillis(30000L);
                            config.setNumTestsPerEvictionRun(10);
                            config.setMinEvictableIdleTimeMillis(60000L);
                            LinkedList<JedisShardInfo> jedisShardInfos = new LinkedList<JedisShardInfo>();
                            String[] addressArr = address.split(",");
                            for (int i = 0; i < addressArr.length; ++i) {
                                JedisShardInfo jedisShardInfo = new JedisShardInfo(addressArr[i]);
                                jedisShardInfos.add(jedisShardInfo);
                            }
                            shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)config, jedisShardInfos);
                            logger.info(">>>>>>>>>>> xxl-sso, JedisUtil.ShardedJedisPool init success.");
                        }
                    }
                    finally {
                        INSTANCE_INIT_LOCL.unlock();
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (shardedJedisPool == null) {
            throw new NullPointerException(">>>>>>>>>>> xxl-sso, JedisUtil.ShardedJedisPool is null.");
        }
        ShardedJedis shardedJedis = shardedJedisPool.getResource();
        return shardedJedis;
    }

    public static void close() throws IOException {
        if (shardedJedisPool != null) {
            shardedJedisPool.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] serialize(Object object) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = null;
        try {
            byte[] bytes;
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                oos.close();
                baos.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object unserialize(byte[] bytes) {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setStringValue(String key, String value, int seconds) {
        String result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.setex(key, seconds, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObjectValue(String key, Object obj, int seconds) {
        String result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.setex(key.getBytes(), seconds, JedisUtil.serialize(obj));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringValue(String key) {
        String value = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            value = client.get(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectValue(String key) {
        Object obj = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            byte[] bytes = client.get(key.getBytes());
            if (bytes != null && bytes.length > 0) {
                obj = JedisUtil.unserialize(bytes);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long del(String key) {
        Long result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.del(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long incrBy(String key, int i) {
        Long result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.incrBy(key, (long)i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String key) {
        Boolean result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.exists(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long expire(String key, int seconds) {
        Long result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.expire(key, seconds);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long expireAt(String key, long unixTime) {
        Long result = null;
        try (ShardedJedis client = JedisUtil.getInstance();){
            result = client.expireAt(key, unixTime);
        }
        return result;
    }

    public static void main(String[] args) {
        String xxlSsoRedisAddress = "redis://xxl-sso:password@127.0.0.1:6379/0";
        xxlSsoRedisAddress = "redis://127.0.0.1:6379/0";
        JedisUtil.init(xxlSsoRedisAddress);
        JedisUtil.setObjectValue("key", "666", 7200);
        System.out.println(JedisUtil.getObjectValue("key"));
    }

    static {
        INSTANCE_INIT_LOCL = new ReentrantLock(false);
    }
}

