/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.base.security.cert.parser;

import com.yeepay.yop.sdk.base.security.cert.parser.AbstractYopPublicKeyParser;
import com.yeepay.yop.sdk.base.security.cert.parser.YopCertParser;
import com.yeepay.yop.sdk.config.provider.file.YopCertConfig;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.security.CertTypeEnum;
import com.yeepay.yop.sdk.security.cert.YopCertCategory;
import com.yeepay.yop.sdk.security.cert.YopPublicKey;
import org.apache.commons.lang3.StringUtils;

public class YopSm2PublicKeyParser
extends AbstractYopPublicKeyParser
implements YopCertParser {
    public YopPublicKey parse(YopCertConfig certConfig) {
        if (null == certConfig.getStoreType()) {
            throw new YopClientException("Can't init YOP public key!,  Store type is error.");
        }
        switch (certConfig.getStoreType()) {
            case STRING: {
                try {
                    return new YopPublicKey(SmUtils.string2PublicKey(certConfig.getValue()));
                }
                catch (Exception ex) {
                    throw new YopClientException("Can't init YOP public key!, cert_config:" + certConfig, (Throwable)ex);
                }
            }
            case FILE_CER: {
                try {
                    return new YopPublicKey(this.getX509Cert(certConfig.getValue(), CertTypeEnum.SM2));
                }
                catch (Exception e) {
                    throw new YopClientException("Can't init YOP public key! cert_config:" + certConfig, (Throwable)e);
                }
            }
        }
        throw new YopClientException("Can't init YOP public key!, cert_config:" + certConfig);
    }

    public String parserId() {
        return StringUtils.joinWith((String)",", (Object[])new Object[]{YopCertCategory.PUBLIC, CertTypeEnum.SM2});
    }
}

