/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.monitor;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Singleton;
import com.yomahub.liteflow.core.FlowExecutorHolder;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorFile {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> PATH_SET = new HashSet<String>();

    public static MonitorFile getInstance() {
        return (MonitorFile)Singleton.get(MonitorFile.class, (Object[])new Object[0]);
    }

    public void addMonitorFilePath(String path) {
        if (FileUtil.isFile((String)path)) {
            String parentFolder = FileUtil.getParent((String)path, (int)1);
            this.PATH_SET.add(parentFolder);
        } else {
            this.PATH_SET.add(path);
        }
    }

    public void addMonitorFilePaths(List<String> filePaths) {
        filePaths.forEach(this::addMonitorFilePath);
    }

    public void create() throws Exception {
        for (String path : this.PATH_SET) {
            long interval = TimeUnit.MILLISECONDS.toMillis(2L);
            FileAlterationObserver observer = new FileAlterationObserver(new File(path));
            observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

                public void onFileChange(File file) {
                    MonitorFile.this.logger.info("file modify,filePath={}", (Object)file.getAbsolutePath());
                    FlowExecutorHolder.loadInstance().reloadRule();
                }

                public void onFileDelete(File file) {
                    MonitorFile.this.logger.info("file delete,filePath={}", (Object)file.getAbsolutePath());
                    FlowExecutorHolder.loadInstance().reloadRule();
                }
            });
            FileAlterationMonitor monitor = new FileAlterationMonitor(interval, new FileAlterationObserver[]{observer});
            monitor.start();
        }
    }
}

