package com.yomahub.liteflow.enums;


public enum LanguageTypeEnum {

    JS("js", "js","com.yomahub.liteflow.script.javascript.JavaScriptExecutor"),
    GRAALJS("graaljs", "graaljs", "com.yomahub.liteflow.script.graaljs.GraalJavaScriptExecutor"),
    PYTHON("python", "python", "com.yomahub.liteflow.script.python.PythonScriptExecutor"),
    LUA("lua", "lua", "com.yomahub.liteflow.script.lua.LuaScriptExecutor"),
    QLEXPRESS("qlexpress", "qlexpress", "com.yomahub.liteflow.script.qlexpress.QLExpressScriptExecutor"),
    GROOVY("groovy", "groovy", "com.yomahub.liteflow.script.groovy.GroovyScriptExecutor");

    private String code;
    private String name;
    private String className;

    LanguageTypeEnum(String code, String name, String className) {
        this.code = code;
        this.name = name;
        this.className = className;
    }

    public static LanguageTypeEnum getLanguage(String code){
        for (LanguageTypeEnum value : LanguageTypeEnum.values()) {
            if(value.getCode().equals(code)){
                return value;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }


}
