/*
 * Decompiled with CFR 0.152.
 */
package com.zhuozhengsoft.base64;

import com.zhuozhengsoft.base64.BaseNCodec$Context;
import com.zhuozhengsoft.base64.BinaryDecoder;
import com.zhuozhengsoft.base64.BinaryEncoder;
import com.zhuozhengsoft.base64.DecoderException;
import com.zhuozhengsoft.base64.EncoderException;
import com.zhuozhengsoft.base64.StringUtils;

public abstract class BaseNCodec
implements BinaryDecoder,
BinaryEncoder {
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected final byte PAD = (byte)61;
    protected final byte pad;
    private final int a;
    private final int b;
    protected final int lineLength;
    private final int c;

    protected BaseNCodec(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 61);
    }

    protected BaseNCodec(int n, int n2, int n3, int n4, byte by) {
        this.a = n;
        this.b = n2;
        n = n3 > 0 && n4 > 0 ? 1 : 0;
        this.lineLength = n != 0 ? n3 / n2 * n2 : 0;
        this.c = n4;
        this.pad = by;
    }

    static boolean a(BaseNCodec$Context baseNCodec$Context) {
        return baseNCodec$Context.b != null;
    }

    static int b(BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.b != null) {
            return baseNCodec$Context.c - baseNCodec$Context.d;
        }
        return 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    protected byte[] ensureBufferSize(int n, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.b == null || baseNCodec$Context.b.length < baseNCodec$Context.c + n) {
            Object object = this;
            if (baseNCodec$Context.b == null) {
                baseNCodec$Context.b = new byte[((BaseNCodec)object).getDefaultBufferSize()];
                baseNCodec$Context.c = 0;
                baseNCodec$Context.d = 0;
            } else {
                object = new byte[baseNCodec$Context.b.length << 1];
                System.arraycopy(baseNCodec$Context.b, 0, object, 0, baseNCodec$Context.b.length);
                baseNCodec$Context.b = (byte[])object;
            }
            return baseNCodec$Context.b;
        }
        return baseNCodec$Context.b;
    }

    final int c(byte[] byArray, int n, int n2, BaseNCodec$Context baseNCodec$Context) {
        if (baseNCodec$Context.b != null) {
            n2 = Math.min(BaseNCodec.b(baseNCodec$Context), n2);
            System.arraycopy(baseNCodec$Context.b, baseNCodec$Context.d, byArray, n, n2);
            baseNCodec$Context.d += n2;
            if (baseNCodec$Context.d >= baseNCodec$Context.c) {
                baseNCodec$Context.b = null;
            }
            return n2;
        }
        if (baseNCodec$Context.e) {
            return -1;
        }
        return 0;
    }

    protected static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object encode(Object object) {
        if (!(object instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public String encodeToString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    public String encodeAsString(byte[] byArray) {
        return StringUtils.newStringUtf8(this.encode(byArray));
    }

    @Override
    public Object decode(Object object) {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    public byte[] decode(String string) {
        return this.decode(StringUtils.getBytesUtf8(string));
    }

    @Override
    public byte[] decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        BaseNCodec$Context baseNCodec$Context = new BaseNCodec$Context();
        this.b(byArray, 0, byArray.length, baseNCodec$Context);
        this.b(byArray, 0, -1, baseNCodec$Context);
        byArray = new byte[baseNCodec$Context.c];
        this.c(byArray, 0, byArray.length, baseNCodec$Context);
        return byArray;
    }

    @Override
    public byte[] encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        BaseNCodec$Context baseNCodec$Context = new BaseNCodec$Context();
        this.a(byArray, 0, byArray.length, baseNCodec$Context);
        this.a(byArray, 0, -1, baseNCodec$Context);
        byArray = new byte[baseNCodec$Context.c - baseNCodec$Context.d];
        this.c(byArray, 0, byArray.length, baseNCodec$Context);
        return byArray;
    }

    abstract void a(byte[] var1, int var2, int var3, BaseNCodec$Context var4);

    abstract void b(byte[] var1, int var2, int var3, BaseNCodec$Context var4);

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl) {
        for (int i = 0; i < byArray.length; ++i) {
            if (this.isInAlphabet(byArray[i]) || bl && (byArray[i] == this.pad || BaseNCodec.isWhiteSpace(byArray[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(StringUtils.getBytesUtf8(string), true);
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (byte by : byArray) {
            if (this.pad != by && !this.isInAlphabet(by)) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] byArray) {
        long l = (long)((byArray.length + this.a - 1) / this.a) * (long)this.b;
        if (this.lineLength > 0) {
            l += (l + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.c;
        }
        return l;
    }
}

