/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.config;

import de.codecentric.boot.admin.server.config.AdminServerAutoConfiguration;
import de.codecentric.boot.admin.server.services.CloudFoundryInstanceIdGenerator;
import de.codecentric.boot.admin.server.services.HashingInstanceUrlIdGenerator;
import de.codecentric.boot.admin.server.services.InstanceIdGenerator;
import de.codecentric.boot.admin.server.web.client.CloudFoundryHttpHeaderProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
@AutoConfigureBefore(value={AdminServerAutoConfiguration.class})
@Lazy(value=false)
public class AdminServerCloudFoundryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public InstanceIdGenerator instanceIdGenerator() {
        return new CloudFoundryInstanceIdGenerator(new HashingInstanceUrlIdGenerator());
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundryHttpHeaderProvider cloudFoundryHttpHeaderProvider() {
        return new CloudFoundryHttpHeaderProvider();
    }
}

