/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.eventstore;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.eventstore.InstanceEventPublisher;
import de.codecentric.boot.admin.server.eventstore.InstanceEventStore;
import de.codecentric.boot.admin.server.eventstore.OptimisticLockingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ConcurrentMapEventStore
extends InstanceEventPublisher
implements InstanceEventStore {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentMapEventStore.class);
    private static final Comparator<InstanceEvent> byTimestampAndIdAndVersion = Comparator.comparing(InstanceEvent::getTimestamp).thenComparing(InstanceEvent::getInstance).thenComparing(InstanceEvent::getVersion);
    private final int maxLogSizePerAggregate;
    private final ConcurrentMap<InstanceId, List<InstanceEvent>> eventLog;

    protected ConcurrentMapEventStore(int maxLogSizePerAggregate, ConcurrentMap<InstanceId, List<InstanceEvent>> eventLog) {
        this.eventLog = eventLog;
        this.maxLogSizePerAggregate = maxLogSizePerAggregate;
    }

    @Override
    public Flux<InstanceEvent> findAll() {
        return Flux.defer(() -> Flux.fromIterable(this.eventLog.values()).flatMapIterable(Function.identity()).sort(byTimestampAndIdAndVersion));
    }

    @Override
    public Flux<InstanceEvent> find(InstanceId id) {
        return Flux.defer(() -> Flux.fromIterable((Iterable)this.eventLog.getOrDefault(id, Collections.emptyList())));
    }

    @Override
    public Mono<Void> append(List<InstanceEvent> events) {
        return Mono.fromRunnable(() -> {
            while (!this.doAppend(events)) {
            }
        });
    }

    protected boolean doAppend(List<InstanceEvent> events) {
        if (events.isEmpty()) {
            return true;
        }
        InstanceId id = events.get(0).getInstance();
        if (!events.stream().allMatch(event -> event.getInstance().equals(id))) {
            throw new IllegalArgumentException("'events' must only refer to the same instance.");
        }
        List oldEvents = this.eventLog.computeIfAbsent(id, key -> new ArrayList(this.maxLogSizePerAggregate + 1));
        long lastVersion = ConcurrentMapEventStore.getLastVersion(oldEvents);
        if (lastVersion >= events.get(0).getVersion()) {
            throw this.createOptimisticLockException(events.get(0), lastVersion);
        }
        ArrayList<InstanceEvent> newEvents = new ArrayList<InstanceEvent>(oldEvents);
        newEvents.addAll(events);
        if (newEvents.size() > this.maxLogSizePerAggregate) {
            log.debug("Threshold for {} reached. Compacting events", (Object)id);
            this.compact(newEvents);
        }
        if (this.eventLog.replace(id, oldEvents, newEvents)) {
            log.debug("Events appended to log {}", events);
            return true;
        }
        log.debug("Unsuccessful attempt append the events {} ", events);
        return false;
    }

    private void compact(List<InstanceEvent> events) {
        BinaryOperator latestEvent = (e1, e2) -> e1.getVersion() > e2.getVersion() ? e1 : e2;
        Map latestPerType = events.stream().collect(Collectors.groupingBy(Object::getClass, Collectors.reducing(latestEvent)));
        events.removeIf(e -> !Objects.equals(e, ((Optional)latestPerType.get(e.getClass())).orElse(null)));
    }

    private OptimisticLockingException createOptimisticLockException(InstanceEvent event, long lastVersion) {
        return new OptimisticLockingException("Version " + event.getVersion() + " was overtaken by " + lastVersion + " for " + String.valueOf(event.getInstance()));
    }

    protected static long getLastVersion(List<InstanceEvent> events) {
        return events.isEmpty() ? -1L : events.get(events.size() - 1).getVersion();
    }
}

