/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.kson;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nustaq.logging.FSTLogger;

public class KsonTypeMapper {
    private static final FSTLogger logger = FSTLogger.getLogger(KsonTypeMapper.class);
    public static final Object NULL_LITERAL = "NULL";
    protected boolean useSimplClzName = true;
    protected HashMap<String, Class> typeMap = new HashMap(31);
    protected HashMap<Class, String> reverseTypeMap = new HashMap(31);
    protected DateFormat dateTimeInstance = DateFormat.getDateTimeInstance();
    final Class NONE = Object.class;

    public KsonTypeMapper() {
        this.map("map", HashMap.class).map("list", HashMap.class).map("set", HashSet.class);
    }

    public Class getType(String type) {
        Class<?> res = this.typeMap.get(type);
        if (res == null) {
            try {
                res = Class.forName(type);
                if (res == null) {
                    this.typeMap.put(type, this.NONE);
                } else {
                    this.typeMap.put(type, res);
                }
            }
            catch (ClassNotFoundException e) {
                this.typeMap.put(type, this.NONE);
                return null;
            }
        }
        if (res == this.NONE) {
            res = null;
        }
        return res;
    }

    public KsonTypeMapper map(String name, Class c) {
        this.typeMap.put(name, c);
        this.reverseTypeMap.put(c, name);
        return this;
    }

    public KsonTypeMapper map(Object ... stringAndClasses) {
        for (int i = 0; i < stringAndClasses.length; i += 2) {
            this.map(stringAndClasses[i], stringAndClasses[i + 1]);
        }
        return this;
    }

    public KsonTypeMapper map(Class ... c) {
        for (int i = 0; i < c.length; ++i) {
            Class aClass = c[i];
            this.map(aClass.getSimpleName(), aClass);
        }
        return this;
    }

    public boolean isUseSimplClzName() {
        return this.useSimplClzName;
    }

    public void setUseSimplClzName(boolean useSimplClzName) {
        this.useSimplClzName = useSimplClzName;
    }

    public Object coerceReading(Class type, Object readObject) {
        if (type == null) {
            return readObject;
        }
        if (Map.class.isAssignableFrom(type) && readObject.getClass().isArray()) {
            try {
                Map c = (Map)type.newInstance();
                int len = Array.getLength(readObject);
                for (int i = 0; i < len; i += 2) {
                    c.put(Array.get(readObject, i), Array.get(readObject, i + 1));
                }
                return c;
            }
            catch (Exception e) {
                logger.log(FSTLogger.Level.INFO, "Exception thrown by newInstance", e);
            }
        } else if (Collection.class.isAssignableFrom(type) && readObject.getClass().isArray()) {
            try {
                if (type.isInterface()) {
                    if (List.class.isAssignableFrom(type)) {
                        type = ArrayList.class;
                    } else if (Map.class.isAssignableFrom(type)) {
                        type = HashMap.class;
                    }
                }
                Collection c = (Collection)type.newInstance();
                int len = Array.getLength(readObject);
                for (int i = 0; i < len; ++i) {
                    c.add(Array.get(readObject, i));
                }
                return c;
            }
            catch (Exception e) {
                logger.log(FSTLogger.Level.ERROR, "Exception thrown by newInstance", e);
            }
        } else if (Date.class.isAssignableFrom(type) && readObject instanceof String) {
            try {
                return this.dateTimeInstance.parse((String)readObject);
            }
            catch (ParseException pe) {
                logger.log(FSTLogger.Level.ERROR, "Failed to parse date", pe);
            }
        } else if ((type == Character.TYPE || Character.class.isAssignableFrom(type)) && readObject instanceof String) {
            return Character.valueOf(((String)readObject).charAt(0));
        }
        return readObject;
    }

    public DateFormat getDateTimeInstance() {
        return this.dateTimeInstance;
    }

    public void setDateTimeInstance(DateFormat dateTimeInstance) {
        this.dateTimeInstance = dateTimeInstance;
    }

    public Object mapLiteral(String type) {
        if (type.equals("null")) {
            return NULL_LITERAL;
        }
        if (type.equals("true") || type.equals("yes") || type.equals("y")) {
            return Boolean.TRUE;
        }
        if (type.equals("false") || type.equals("no") || type.equals("n")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String getStringForType(Class<? extends Object> aClass) {
        String res = this.reverseTypeMap.get(aClass);
        if (res == null) {
            res = this.useSimplClzName ? aClass.getSimpleName() : aClass.getName();
        }
        return res;
    }
}

