/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.CatalogAssistAI;
import dev.equo.ide.CatalogJdt;
import dev.equo.ide.CatalogPde;
import dev.equo.ide.CatalogPlatform;
import dev.equo.ide.EquoChromium;
import dev.equo.solstice.p2.P2Model;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public class Catalog
implements Comparable<Catalog> {
    protected static final String V = "${VERSION}";
    public static final CatalogPlatform PLATFORM = new CatalogPlatform();
    public static final CatalogJdt JDT = new CatalogJdt();
    public static final CatalogPde PDE = new CatalogPde();
    public static final Catalog EGIT = new Catalog("egit", "https://download.eclipse.org/egit/updates-${VERSION}/", Catalog.jre11("6.6"), List.of("org.eclipse.egit.feature.group"), new Catalog[0]);
    static final Catalog ORBIT = new Catalog("orbit", "https://download.eclipse.org/tools/orbit/downloads/drops/${VERSION}/repository/", Catalog.jre11("R20230531010532"), List.of(), new Catalog[0]);
    public static final CatalogAssistAI ASSIST_AI = new CatalogAssistAI();
    public static final Catalog TABNINE = new Catalog("tabnine", "https://eclipse-update-site.tabnine.com/", Catalog.jre11(""), List.of("Tabnine Eclipse Plugin"), new Catalog[0]);
    public static final Catalog GRADLE_BUILDSHIP = new Catalog("gradleBuildship", "https://download.eclipse.org/buildship/updates/e431/releases/3.x/${VERSION}", Catalog.jre17("3.1.10.v20240802-1211"), List.of("org.eclipse.buildship.feature.group"), JDT);
    private static final Catalog WST = new Catalog("wst", "https://download.eclipse.org/webtools/downloads/drops/${VERSION}/repository/", Catalog.jre11("R3.30.0/R-3.30.0-20230603084739"), List.of(), new Catalog[0]);
    public static final Catalog M2E = new Catalog("m2e", "https://download.eclipse.org/technology/m2e/releases/${VERSION}", Catalog.jre11("1.20.1").jre(17, "2.6.2"), (List)List.of("org.eclipse.m2e.feature.feature.group"), new Catalog[]{JDT, WST, ORBIT}){

        @Override
        public Map<String, P2Model.Filter> getFiltersFor(@Nullable String override) {
            return Map.of("m2e-nested-jar-has-lucene", P2Model.Filter.create(filter -> filter.excludePrefix("org.apache.lucene.")));
        }
    };
    public static final Catalog KOTLIN = new Catalog("kotlin", "https://files.pkg.jetbrains.space/kotlin/p/kotlin-eclipse/main/${VERSION}", Catalog.jre11("0.8.21"), List.of("org.jetbrains.kotlin.feature.feature.group", "org.jetbrains.kotlin.gradle.feature.feature.group"), JDT);
    public static final Catalog TM_TERMINAL = new Catalog("tmTerminal", "https://download.eclipse.org/tools/cdt/releases/${VERSION}", Catalog.jre11("11.2/cdt-11.2.0"), List.of("org.eclipse.tm.terminal.feature.feature.group", "org.eclipse.tm.terminal.view.feature.feature.group"), PLATFORM);
    public static final Catalog CDT = new Catalog("cdt", TM_TERMINAL, List.of("org.eclipse.launchbar.feature.group", "org.eclipse.cdt.visualizer.feature.group", "org.eclipse.cdt.unittest.feature.feature.group", "org.eclipse.cdt.testsrunner.feature.feature.group", "org.eclipse.cdt.native.feature.group", "org.eclipse.cdt.msw.feature.group", "org.eclipse.cdt.managedbuilder.llvm.feature.group", "org.eclipse.cdt.llvm.dsf.lldb.feature.group", "org.eclipse.cdt.launch.serial.feature.feature.group", "org.eclipse.cdt.launch.remote.feature.group", "org.eclipse.cdt.gnu.multicorevisualizer.feature.group", "org.eclipse.cdt.feature.group", "org.eclipse.cdt.debug.ui.memory.feature.group", "org.eclipse.cdt.debug.standalone.feature.group", "org.eclipse.cdt.debug.gdbjtag.feature.group", "org.eclipse.cdt.core.autotools.feature.group", "org.eclipse.cdt.cmake.feature.group", "org.eclipse.cdt.build.crossgcc.feature.group", "org.eclipse.cdt.autotools.feature.group"), TM_TERMINAL);
    public static final Catalog RUST = new Catalog("rust", "https://download.eclipse.org/corrosion/releases/${VERSION}", Catalog.jre11("1.2.4"), List.of("org.eclipse.corrosion.product", "org.eclipse.corrosion.feature.feature.group"), TM_TERMINAL);
    public static final Catalog GROOVY = new Catalog("groovy", "https://groovy.jfrog.io/artifactory/plugins-release/org/codehaus/groovy/groovy-eclipse-integration/${VERSION}", Catalog.jre11("4.9.0/e4.27"), List.of("org.codehaus.groovy.compilerless.feature.feature.group", "org.codehaus.groovy40.feature.feature.group"), PLATFORM);
    public static final EquoChromium EQUO_CHROMIUM = new EquoChromium();
    public static final Catalog CHATGPT = new PureMaven("chatGPT", Catalog.jre11("1.0.1"), List.of("dev.equo.ide:equo-ide-chatgpt:${VERSION}"), PLATFORM, EQUO_CHROMIUM);
    private final String name;
    private final String p2urlTemplate;
    protected final VmVersion versions;
    private final List<String> toInstall;
    private final List<Catalog> requires;
    private static final int JVM_VER;

    static String defaultPerspectiveFor(Catalog catalog) {
        if (catalog == JDT || catalog == GROOVY) {
            return "org.eclipse.jdt.ui.JavaPerspective";
        }
        if (catalog == PDE) {
            return "org.eclipse.pde.ui.PDEPerspective";
        }
        if (catalog == KOTLIN) {
            return "org.jetbrains.kotlin.perspective";
        }
        if (catalog == CDT || catalog == RUST) {
            return "org.eclipse.cdt.ui.CPerspective";
        }
        return null;
    }

    Catalog(String name, Catalog copyFrom, List<String> toInstall, Catalog ... requires) {
        this(name, copyFrom.p2urlTemplate, copyFrom.versions, toInstall, requires);
    }

    protected Catalog(String name, String p2urlTemplate, VmVersion versions, List<String> toInstall, Catalog ... requires) {
        this.name = name;
        this.p2urlTemplate = p2urlTemplate.endsWith("/") ? p2urlTemplate : p2urlTemplate + "/";
        this.versions = versions;
        this.toInstall = toInstall;
        this.requires = List.of(requires);
    }

    public String getP2UrlTemplate() {
        return this.p2urlTemplate;
    }

    public String getName() {
        return this.name;
    }

    public List<Catalog> getRequires() {
        return this.requires;
    }

    public String getUrlForOverride(@Nullable String override) {
        if (override == null) {
            return this.p2urlTemplate.replace(V, this.versions.getAndWarn(this));
        }
        if (Catalog.isUrl(override)) {
            return override;
        }
        return this.p2urlTemplate.replace(V, override);
    }

    public List<String> getTargetsFor(@Nullable String override) {
        return this.toInstall;
    }

    public Map<String, P2Model.Filter> getFiltersFor(@Nullable String override) {
        return Map.of();
    }

    public static boolean isUrl(String maybeUrl) {
        return maybeUrl.startsWith("https:") || maybeUrl.startsWith("http:");
    }

    @Override
    public int compareTo(Catalog o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Catalog) {
            return ((Catalog)obj).name.equals(this.name);
        }
        return false;
    }

    protected static VmVersion jre11(String ver) {
        return new VmVersion().jre(11, ver);
    }

    protected static VmVersion jre17(String ver) {
        return new VmVersion().jre(17, ver);
    }

    public boolean isPureMaven() {
        return this instanceof PureMaven;
    }

    static {
        String ver = System.getProperty("java.version");
        if (ver.startsWith("1.8")) {
            JVM_VER = 8;
        } else {
            Matcher matcher = Pattern.compile("(\\d+)").matcher(ver);
            matcher.find();
            JVM_VER = Integer.parseInt(matcher.group(1));
        }
    }

    static class VmVersion {
        private TreeMap<Integer, String> versions = new TreeMap();

        VmVersion() {
        }

        public VmVersion jre(int vm, String catalog) {
            this.versions.put(vm, catalog);
            return this;
        }

        public String getAndWarn(Catalog catalog) {
            Map.Entry<Integer, String> entry = this.versions.floorEntry(JVM_VER);
            if (entry == null) {
                Map.Entry<Integer, String> oldest = this.versions.firstEntry();
                throw new IllegalArgumentException("You are running on JRE " + JVM_VER + ", but the minimum supported version of " + catalog.name + " is " + oldest.getValue() + " which requires JRE " + oldest.getKey() + "+.");
            }
            Map.Entry<Integer, String> latest = this.versions.lastEntry();
            if (!entry.equals(latest)) {
                LoggerFactory.getLogger(Catalog.class).warn("You are using " + catalog.name + " " + entry.getValue() + " which is the latest version for JRE " + entry.getKey() + ". There is a newer version available, " + catalog.name + " " + latest.getValue() + ", but it requires JRE " + latest.getKey() + " and you are running JRE " + JVM_VER + ".");
            }
            return entry.getValue();
        }
    }

    public static class PureMaven
    extends Catalog {
        protected PureMaven(String name, VmVersion versions, List<String> toInstall, Catalog ... requires) {
            super(name, "PureMaven", versions, toInstall, requires);
        }
    }
}

