/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class AnnotationUtil {
    public static <T extends Annotation> Map<Field, T> getAnnotatedFields(Class<?> type, Class<T> annotation) {
        HashMap<Field, T> fields = new HashMap<Field, T>();
        while (type != Object.class) {
            for (Field field : type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotation)) continue;
                fields.put(field, field.getAnnotation(annotation));
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    public static <T extends Annotation> Map<Method, T> getAnnotatedMethods(Class<?> type, Class<T> annotation) {
        HashMap<Method, T> methods = new HashMap<Method, T>();
        while (type != Object.class) {
            for (Method method : type.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.put(method, method.getAnnotation(annotation));
            }
            type = type.getSuperclass();
        }
        return methods;
    }
}

