/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class DateTimeUtil {
    public static final Function<Long, LocalDateTime> MILLIS_TO_LOCALDATETIME_UTC = epochMillis -> LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC);
    public static final Function<LocalDateTime, Long> LOCALDATETIME_UTC_TO_MILLIS = t -> t == null ? Long.MIN_VALUE : t.toInstant(ZoneOffset.UTC).toEpochMilli();

    static Date substract(Date date, long durationToSubstract, TimeUnit unit) {
        long result = unit.toSeconds(durationToSubstract);
        if (result >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot substract " + durationToSubstract);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, -((int)result));
        return c.getTime();
    }

    public static Interval toInterval(Date startDate, Date endDate) {
        return new Interval(startDate.getTime(), endDate.getTime());
    }

    public static Interval toInterval(String isoXXInterval) {
        if (!isoXXInterval.contains("/")) {
            isoXXInterval = isoXXInterval + "/" + DateTime.now();
        }
        return Interval.parse((String)isoXXInterval);
    }

    public static Interval toIntervalFromNow(long timeback, TimeUnit unit) {
        Date now = new Date();
        return DateTimeUtil.toInterval(DateTimeUtil.substract(now, timeback, unit), now);
    }
}

