/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import java.util.Locale;

public class FormatUtil {
    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String latToPrintable(double lat) {
        String ns = "N";
        if (lat < 0.0) {
            ns = "S";
            lat *= -1.0;
        }
        int hours = (int)lat;
        lat -= (double)hours;
        String latStr = String.format(Locale.US, "%3.3f", lat *= 60.0);
        while (latStr.indexOf(46) < 2) {
            latStr = "0" + latStr;
        }
        return String.format(Locale.US, "%02d %s%s", hours, latStr, ns);
    }

    public static String lonToPrintable(double lon) {
        String ns = "E";
        if (lon < 0.0) {
            ns = "W";
            lon *= -1.0;
        }
        int hours = (int)lon;
        lon -= (double)hours;
        String lonStr = String.format(Locale.US, "%3.3f", lon *= 60.0);
        while (lonStr.indexOf(46) < 2) {
            lonStr = "0" + lonStr;
        }
        return String.format(Locale.US, "%03d %s%s", hours, lonStr, ns);
    }
}

