/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util;

import com.google.common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class Iterators {
    public static <T> Iterator<T> counting(final Iterator<T> iterator, final AtomicLong counter) {
        Objects.requireNonNull(iterator);
        Objects.requireNonNull(counter);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object next = iterator.next();
                counter.incrementAndGet();
                return next;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> unfiltered, final Predicate<? super T> predicate) {
        Objects.requireNonNull(unfiltered);
        Objects.requireNonNull(predicate);
        return new AbstractIterator<T>(){

            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    Object element = unfiltered.next();
                    if (!predicate.test(element)) continue;
                    return element;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> Iterator<T> combine(Collection<? extends Iterator<T>> iterators, Comparator<T> comparator) {
        if (iterators.size() == 1) {
            return iterators.iterator().next();
        }
        final PriorityQueue<Entry<T>> q = new PriorityQueue<Entry<T>>();
        for (Iterator<T> i : iterators) {
            Entry<T> e = new Entry<T>(i, Objects.requireNonNull(comparator));
            if (e.next == null) continue;
            q.add(e);
        }
        return new AbstractIterator<T>(){

            protected T computeNext() {
                Entry e = (Entry)q.poll();
                if (e != null) {
                    Object p = e.next;
                    if (e.iterator.hasNext()) {
                        e.next = e.iterator.next();
                        q.add(e);
                    }
                    return p;
                }
                return this.endOfData();
            }
        };
    }

    static class Entry<T>
    implements Comparable<Entry<T>> {
        T next;
        final Iterator<T> iterator;
        final Comparator<T> comparator;

        Entry(Iterator<T> i, Comparator<T> comparator) {
            this.iterator = Objects.requireNonNull(i);
            this.comparator = comparator;
            if (i.hasNext()) {
                this.next = i.next();
            }
        }

        @Override
        public int compareTo(Entry<T> o) {
            if (this.comparator == null) {
                ((Comparable)this.next).compareTo(o.next);
            }
            return this.comparator.compare(this.next, o.next);
        }
    }
}

