/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util.filtering;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class Cleaner
extends Thread {
    static final Set<Runnable> SET = Collections.newSetFromMap(new WeakHashMap());
    private static ScheduledExecutorService ses;

    Cleaner() {
    }

    static synchronized void add(Runnable runnable) {
        SET.add(Objects.requireNonNull(runnable));
        if (ses == null) {
            ses = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName("Filter cleaning thread [dk.dma.app.util.filtering.Cleaner]");
                    return t;
                }
            });
            ses.schedule(new Runnable(){

                @Override
                public void run() {
                    for (Runnable r : SET) {
                        if (r == null) continue;
                        r.run();
                    }
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }
}

