/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.commons.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public abstract class OutputStreamSink<T> {
    public static final OutputStreamSink<Object> IGNORE = new OutputStreamSink<Object>(){

        @Override
        public void process(OutputStream os, Object msg, long count) {
        }
    };
    public static final OutputStreamSink<Object> TO_STRING_US_ASCII_SINK = OutputStreamSink.toStringSink(StandardCharsets.US_ASCII);
    public static final OutputStreamSink<Object> TO_STRING_UTF8_SINK = OutputStreamSink.toStringSink(StandardCharsets.UTF_8);

    public void footer(OutputStream stream, long count) throws IOException {
    }

    public abstract void process(OutputStream var1, T var2, long var3) throws IOException;

    public void header(OutputStream stream) throws IOException {
    }

    public final OutputStreamSink<T> closeWhenFooterWritten() {
        return new DelegatingOutputStreamSink<T>(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void footer(OutputStream stream, long count) throws IOException {
                try {
                    OutputStreamSink.this.footer(stream, count);
                }
                finally {
                    stream.close();
                }
            }
        };
    }

    public final OutputStreamSink<T> newFlushEveryTimeSink() {
        return new OutputStreamSink<T>(){

            @Override
            public void footer(OutputStream stream, long count) throws IOException {
                OutputStreamSink.this.footer(stream, count);
                stream.flush();
            }

            @Override
            public void header(OutputStream stream) throws IOException {
                OutputStreamSink.this.header(stream);
                stream.flush();
            }

            @Override
            public void process(OutputStream stream, T message, long count) throws IOException {
                OutputStreamSink.this.process(stream, message, count);
                stream.flush();
            }
        };
    }

    public final void writeAll(Iterable<T> iterable, OutputStream os) throws IOException {
        this.header(os);
        long count = 0L;
        for (T t : iterable) {
            this.process(os, t, ++count);
        }
        this.footer(os, count);
    }

    protected final OutputStreamSink<T> writeFooter(final String footer, final Charset charset) {
        Objects.requireNonNull(footer);
        Objects.requireNonNull(charset);
        return new DelegatingOutputStreamSink<T>(this){

            @Override
            public void footer(OutputStream stream, long count) throws IOException {
                OutputStreamSink.this.footer(stream, count);
                stream.write(footer.getBytes(charset));
            }
        };
    }

    protected final OutputStreamSink<T> writeFooterAscii(String footer) {
        return this.writeFooter(footer, StandardCharsets.US_ASCII);
    }

    protected final OutputStreamSink<T> withFixedHeader(final String header, final Charset charset) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(charset);
        return new DelegatingOutputStreamSink<T>(this){

            @Override
            public void header(OutputStream stream) throws IOException {
                stream.write(header.getBytes(charset));
                OutputStreamSink.this.header(stream);
            }
        };
    }

    protected final OutputStreamSink<T> writeHeaderAscii(String header) {
        return this.withFixedHeader(header, StandardCharsets.US_ASCII);
    }

    public static <T> OutputStreamSink<T> toStringSink(final Charset charset) {
        Objects.requireNonNull(charset);
        return new OutputStreamSink<T>(){

            @Override
            public void process(OutputStream stream, T message, long count) throws IOException {
                String s = message.toString();
                stream.write(s.getBytes(charset));
                stream.write(10);
            }
        };
    }

    static class DelegatingOutputStreamSink<T>
    extends OutputStreamSink<T> {
        private final OutputStreamSink<T> oss;

        DelegatingOutputStreamSink(OutputStreamSink<T> oss) {
            this.oss = Objects.requireNonNull(oss);
        }

        @Override
        public void footer(OutputStream stream, long count) throws IOException {
            this.oss.footer(stream, count);
        }

        @Override
        public void header(OutputStream stream) throws IOException {
            this.oss.header(stream);
        }

        @Override
        public void process(OutputStream stream, T message, long count) throws IOException {
            this.oss.process(stream, message, count);
        }
    }
}

