/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.zhipuai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.ai.model.ModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.zhipuai.api.ApiUtils;
import org.springframework.ai.zhipuai.api.ZhiPuAiStreamFunctionCallingHelper;
import org.springframework.boot.context.properties.bind.ConstructorBinding;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ZhiPuAiApi {
    public static final String DEFAULT_CHAT_MODEL = ChatModel.GLM_3_Turbo.getValue();
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.Embedding_2.getValue();
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final RestClient restClient;
    private final WebClient webClient;
    private final ZhiPuAiStreamFunctionCallingHelper chunkMerger = new ZhiPuAiStreamFunctionCallingHelper();

    public ZhiPuAiApi(String zhiPuAiToken) {
        this("https://open.bigmodel.cn/api/paas", zhiPuAiToken);
    }

    public ZhiPuAiApi(String baseUrl, String zhiPuAiToken) {
        this(baseUrl, zhiPuAiToken, RestClient.builder());
    }

    public ZhiPuAiApi(String baseUrl, String zhiPuAiToken, RestClient.Builder restClientBuilder) {
        this(baseUrl, zhiPuAiToken, restClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public ZhiPuAiApi(String baseUrl, String zhiPuAiToken, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(zhiPuAiToken)).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = WebClient.builder().baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(zhiPuAiToken)).build();
    }

    public static String getTextContent(List<ChatCompletionMessage.MediaContent> content) {
        return content.stream().filter(c -> "text".equals(c.type())).map(ChatCompletionMessage.MediaContent::text).reduce("", (a, b) -> a + b);
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the steam property to false.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v4/chat/completions", new Object[0])).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the steam property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)this.webClient.post().uri("/v4/chat/completions", new Object[0])).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (this.chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && this.chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null, null, null, null), this.chunkMerger::merge);
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public <T> ResponseEntity<EmbeddingList<Embedding>> embeddings(EmbeddingRequest<T> embeddingRequest) {
        Assert.notNull(embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull(embeddingRequest.input(), (String)"The input can not be null.");
        Assert.isTrue((embeddingRequest.input() instanceof String || embeddingRequest.input() instanceof List ? 1 : 0) != 0, (String)"The input must be either a String, or a List of Strings or List of List of integers.");
        T t = embeddingRequest.input();
        if (t instanceof List) {
            List list = (List)t;
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"The input list can not be empty.");
            Assert.isTrue((list.size() <= 512 ? 1 : 0) != 0, (String)"The list must be 512 dimensions or less");
            Assert.isTrue((list.get(0) instanceof String || list.get(0) instanceof Integer || list.get(0) instanceof List ? 1 : 0) != 0, (String)"The input must be either a String, or a List of Strings or list of list of integers.");
        }
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v4/embeddings", new Object[0])).body(embeddingRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<EmbeddingList<Embedding>>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="model") String model, @JsonProperty(value="frequency_penalty") Float frequencyPenalty, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="n") Integer n, @JsonProperty(value="presence_penalty") Float presencePenalty, @JsonProperty(value="response_format") ResponseFormat responseFormat, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="temperature") Float temperature, @JsonProperty(value="top_p") Float topP, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice, @JsonProperty(value="user") String user) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Float temperature) {
            this(messages, model, null, null, null, null, null, null, null, false, temperature, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Float temperature, boolean stream) {
            this(messages, model, null, null, null, null, null, null, null, stream, temperature, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, List<FunctionTool> tools, Object toolChoice) {
            this(messages, model, null, null, null, null, null, null, null, false, Float.valueOf(0.8f), null, tools, toolChoice, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, Boolean stream) {
            this(messages, null, null, null, null, null, null, null, null, stream, null, null, null, null, null);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ResponseFormat(@JsonProperty(value="type") String type) {
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object FUNCTION(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest<T>(@JsonProperty(value="input") T input, @JsonProperty(value="model") String model) {
        public EmbeddingRequest(T input) {
            this(input, DEFAULT_EMBEDDING_MODEL);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<ChunkChoice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChunkChoice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="delta") ChatCompletionMessage delta, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") List<ToolCall> toolCalls) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCall(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record MediaContent(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="image_url") ImageUrl imageUrl) {
            public MediaContent(String text) {
                this("text", text, null);
            }

            public MediaContent(ImageUrl imageUrl) {
                this("image_url", null, imageUrl);
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record ImageUrl(@JsonProperty(value="url") String url, @JsonProperty(value="detail") String detail) {
                public ImageUrl(String url) {
                    this(url, null);
                }
            }
        }
    }

    public static enum ChatModel implements ModelDescription
    {
        GLM_4("GLM-4"),
        GLM_3_Turbo("GLM-3-Turbo");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getModelName() {
            return this.value;
        }
    }

    public static enum EmbeddingModel {
        Embedding_2("Embedding-2");

        public final String value;

        private EmbeddingModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingList<T>(@JsonProperty(value="object") String object, @JsonProperty(value="data") List<T> data, @JsonProperty(value="model") String model, @JsonProperty(value="usage") Usage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embedding(@JsonProperty(value="index") Integer index, @JsonProperty(value="embedding") List<Double> embedding, @JsonProperty(value="object") String object) {
        public Embedding(Integer index, List<Double> embedding) {
            this(index, embedding, "embedding");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Usage(@JsonProperty(value="completion_tokens") Integer completionTokens, @JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record LogProbs(@JsonProperty(value="content") List<Content> content) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Content(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes, @JsonProperty(value="top_logprobs") List<TopLogProbs> topLogprobs) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record TopLogProbs(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes) {
            }
        }
    }

    public static enum ChatCompletionFinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        FUNCTION_CALL,
        TOOL_CALL;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FunctionTool(@JsonProperty(value="type") Type type, @JsonProperty(value="function") Function function) {
        @ConstructorBinding
        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public static enum Type {
            FUNCTION;

        }

        public record Function(@JsonProperty(value="description") String description, @JsonProperty(value="name") String name, @JsonProperty(value="parameters") Map<String, Object> parameters) {
            @ConstructorBinding
            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema));
            }
        }
    }
}

